/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.bridge;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.MatchResult;
import com.sun.xacml.Policy;
import com.sun.xacml.PolicyMetaData;
import com.sun.xacml.PolicySet;
import com.sun.xacml.VersionConstraints;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.PolicyFinderResult;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetFinderModule
extends PolicyFinderModule {
    private PolicySet policySet;
    private List<Policy> policies = new ArrayList<Policy>();
    protected PolicyFinder policyFinder = null;

    public PolicySetFinderModule() {
    }

    public PolicySetFinderModule(PolicySet policySet) {
        this.policySet = policySet;
    }

    public PolicySetFinderModule(PolicySet policySet, List<Policy> policies) {
        this.policySet = policySet;
        this.policies.addAll(policies);
    }

    public void init(PolicyFinder finder) {
        this.policyFinder = finder;
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        PolicySet selectedPolicy = null;
        MatchResult match = this.policySet.match(context);
        int result = match.getResult();
        if (result == 2) {
            return new PolicyFinderResult(match.getStatus());
        }
        if (result == 0) {
            if (selectedPolicy != null) {
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            selectedPolicy = this.policySet;
        }
        return new PolicyFinderResult(selectedPolicy);
    }

    public PolicyFinderResult findPolicy(URI idReference, int type, VersionConstraints constraints, PolicyMetaData parentMetaData) {
        for (Policy p : this.policies) {
            if (p.getId().compareTo(idReference) != 0) continue;
            return new PolicyFinderResult((AbstractPolicy)p);
        }
        return new PolicyFinderResult();
    }

    public boolean isRequestSupported() {
        return true;
    }

    public boolean isIdReferenceSupported() {
        return true;
    }

    public void set(PolicySet ps, List<Policy> policies) {
        this.policySet = ps;
        this.policies = policies;
    }
}

