/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.util;

import com.sun.xacml.Policy;
import com.sun.xacml.PolicySet;
import com.sun.xacml.finder.PolicyFinder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XACMLPolicyUtil {
    public PolicySet createPolicySet(URL location, PolicyFinder finder) throws Exception {
        return this.createPolicySet(location.openStream(), finder);
    }

    public PolicySet createPolicySet(InputStream is, PolicyFinder finder) throws Exception {
        if (finder == null) {
            throw new IllegalArgumentException("Policy Finder is null");
        }
        Document doc = this.getDocument(is);
        return PolicySet.getInstance((Node)doc.getFirstChild(), (PolicyFinder)finder);
    }

    public Policy createPolicy(URL location) throws Exception {
        return this.createPolicy(location.openStream());
    }

    public Policy createPolicy(InputStream is) throws Exception {
        Document doc = this.getDocument(is);
        return Policy.getInstance((Node)doc.getFirstChild());
    }

    private Document getDocument(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(is);
        return doc;
    }
}

