/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.core;

import com.sun.xacml.PDP;
import com.sun.xacml.PDPConfig;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.finder.AttributeFinder;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.impl.CurrentEnvModule;
import com.sun.xacml.finder.impl.SelectorModule;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jboss.security.xacml.bridge.JBossPolicyFinder;
import org.jboss.security.xacml.core.SecurityActions;
import org.jboss.security.xacml.factories.PolicyFactory;
import org.jboss.security.xacml.factories.RequestResponseContextFactory;
import org.jboss.security.xacml.interfaces.PolicyDecisionPoint;
import org.jboss.security.xacml.interfaces.PolicyLocator;
import org.jboss.security.xacml.interfaces.RequestContext;
import org.jboss.security.xacml.interfaces.ResponseContext;
import org.jboss.security.xacml.interfaces.XACMLPolicy;
import org.jboss.security.xacml.jaxb.LocatorType;
import org.jboss.security.xacml.jaxb.LocatorsType;
import org.jboss.security.xacml.jaxb.PoliciesType;
import org.jboss.security.xacml.jaxb.PolicySetType;
import org.jboss.security.xacml.jaxb.PolicyType;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossPDP
implements PolicyDecisionPoint {
    private Unmarshaller unmarshaller = null;
    private Set<PolicyLocator> locators = new HashSet<PolicyLocator>();
    private Set<XACMLPolicy> policies = new HashSet<XACMLPolicy>();
    private JBossPolicyFinder policyFinder = new JBossPolicyFinder();

    public JBossPDP() {
    }

    public JBossPDP(InputStream configFile) {
        this.createValidatingUnMarshaller();
        try {
            JAXBElement jxb = (JAXBElement)this.unmarshaller.unmarshal(configFile);
            this.bootstrap((org.jboss.security.xacml.jaxb.PDP)jxb.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JBossPDP(InputSource configFile) {
        this.createValidatingUnMarshaller();
        try {
            JAXBElement jxb = (JAXBElement)this.unmarshaller.unmarshal(configFile);
            this.bootstrap((org.jboss.security.xacml.jaxb.PDP)jxb.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JBossPDP(Node configFile) {
        this.createValidatingUnMarshaller();
        try {
            JAXBElement jxb = (JAXBElement)this.unmarshaller.unmarshal(configFile);
            this.bootstrap((org.jboss.security.xacml.jaxb.PDP)jxb.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JBossPDP(XMLStreamReader configFile) {
        this.createValidatingUnMarshaller();
        try {
            JAXBElement jxb = (JAXBElement)this.unmarshaller.unmarshal(configFile);
            this.bootstrap((org.jboss.security.xacml.jaxb.PDP)jxb.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JBossPDP(URL configFileURL) {
        this.createValidatingUnMarshaller();
        try {
            JAXBElement jxb = (JAXBElement)this.unmarshaller.unmarshal(configFileURL.openStream());
            this.bootstrap((org.jboss.security.xacml.jaxb.PDP)jxb.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setLocators(Set<PolicyLocator> locators) {
        this.locators = locators;
    }

    @Override
    public void setPolicies(Set<XACMLPolicy> policies) {
        this.policies = policies;
    }

    @Override
    public ResponseContext evaluate(RequestContext request) {
        HashSet policyModules = new HashSet();
        for (PolicyLocator locator : this.locators) {
            List finderModulesList = (List)locator.get("policy_finder_module");
            if (finderModulesList == null) {
                throw new IllegalStateException("Locator " + locator.getClass().getName() + " has no policy finder modules");
            }
            policyModules.addAll(finderModulesList);
        }
        this.policyFinder.setModules(policyModules);
        AttributeFinder attributeFinder = new AttributeFinder();
        ArrayList<Object> attributeModules = new ArrayList<Object>();
        attributeModules.add(new CurrentEnvModule());
        attributeModules.add(new SelectorModule());
        attributeFinder.setModules(attributeModules);
        PDP pdp = new PDP(new PDPConfig(attributeFinder, (PolicyFinder)this.policyFinder, null));
        RequestCtx req = (RequestCtx)request.get("request_ctx");
        if (req == null) {
            throw new IllegalStateException("Request Context does not contain a request");
        }
        ResponseCtx resp = pdp.evaluate(req);
        ResponseContext response = RequestResponseContextFactory.createResponseContext();
        response.set("response_ctx", resp);
        return response;
    }

    private void bootstrap(org.jboss.security.xacml.jaxb.PDP pdp) throws Exception {
        PoliciesType policiesType = pdp.getPolicies();
        List<PolicySetType> pset = policiesType.getPolicySet();
        for (PolicySetType pst : pset) {
            String loc = pst.getLocation();
            XACMLPolicy policySet = PolicyFactory.createPolicySet(this.getInputStream(loc), this.policyFinder);
            List<PolicyType> policyTypeList = pst.getPolicy();
            ArrayList<XACMLPolicy> policyList = new ArrayList<XACMLPolicy>();
            for (PolicyType pt : policyTypeList) {
                policyList.add(PolicyFactory.createPolicy(this.getInputStream(pt.getLocation())));
            }
            policySet.setEnclosingPolicies(policyList);
            this.policies.add(policySet);
        }
        List<PolicyType> policyList = policiesType.getPolicy();
        for (PolicyType pt : policyList) {
            this.policies.add(PolicyFactory.createPolicy(this.getInputStream(pt.getLocation())));
        }
        LocatorsType locatorsType = pdp.getLocators();
        List<LocatorType> locs = locatorsType.getLocator();
        for (LocatorType lt : locs) {
            PolicyLocator pl = (PolicyLocator)this.loadClass(lt.getName()).newInstance();
            pl.setPolicies(this.policies);
            this.locators.add(pl);
        }
    }

    private void createValidatingUnMarshaller() {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.jboss.security.xacml.jaxb");
            this.unmarshaller = jc.createUnmarshaller();
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            URL schemaURL = tcl.getResource("schema/jbossxacml-2.0.xsd");
            SchemaFactory scFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = scFact.newSchema(schemaURL);
            this.unmarshaller.setSchema(schema);
        }
        catch (Exception jxb) {
            throw new RuntimeException(jxb);
        }
    }

    private InputStream getInputStream(String loc) {
        InputStream is = null;
        try {
            URL url = new URL(loc);
            is = url.openStream();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (is == null) {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            is = tcl.getResourceAsStream(loc);
        }
        return is;
    }

    private Class loadClass(String fqn) throws Exception {
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        return tcl.loadClass(fqn);
    }
}

