/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.core;

import com.sun.xacml.ctx.RequestCtx;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBElement;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.security.xacml.core.model.context.ObjectFactory;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.jboss.security.xacml.interfaces.RequestContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossRequestContext
implements RequestContext {
    private Map<String, Object> map = new HashMap<String, Object>();

    @Override
    public <T> T get(String key) {
        return (T)this.map.get(key);
    }

    @Override
    public <T> void set(String key, T obj) {
        this.map.put(key, obj);
    }

    @Override
    public void setRequest(RequestType requestType) throws IOException {
        JAXBElement<RequestType> requestJAXB = new ObjectFactory().createRequest(requestType);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JAXB.marshal(requestJAXB, (OutputStream)baos);
        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
        this.readRequest(bis);
    }

    @Override
    public void readRequest(InputStream is) throws IOException {
        try {
            RequestCtx request = RequestCtx.getInstance((Node)this.getRequest(is));
            this.set("request_ctx", request);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void marshall(OutputStream os) throws IOException {
        RequestCtx storedRequest = (RequestCtx)this.get("request_ctx");
        if (storedRequest != null) {
            storedRequest.encode(os);
        }
    }

    private Node getRequest(InputStream is) throws Exception {
        String contextSchema = "urn:oasis:names:tc:xacml:2.0:context:schema:os";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        Document doc = factory.newDocumentBuilder().parse(is);
        NodeList nodes = doc.getElementsByTagNameNS(contextSchema, "Request");
        return nodes.item(0);
    }
}

