/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.security.auth.login;

import java.util.ArrayList;
import java.util.List;

//$Id: BaseAuthenticationInfo.java 64295 2007-07-26 06:28:58Z anil.saldhana@jboss.com $

/**
 *  Base for AuthenticationInfo(JAAS) and JASPIAuthenticationInfo(JSR-196)
 *  @author <a href="mailto:anil.saldhana@jboss.org>Anil.Saldhana@jboss.org</a>
 *  @since  Dec 21, 2005 
 */
public class BaseAuthenticationInfo
{
   /**
    * A Set of modules - either LoginModules or AuthModules
    * In the form of AppConfigurationEntry or AuthModuleEntry
    */
   protected List moduleEntries = new ArrayList(); 
   
   protected String name;  
   
   public BaseAuthenticationInfo()
   {
      this(null);
   }
   
   public BaseAuthenticationInfo(String name)
   {
      this.name = name;
   } 
   
   public String getName()
   {
      return name;
   }
   
   public void add(List moduleEntries)
   {
      this.moduleEntries.addAll(moduleEntries);
   }
   
   public List getModuleEntries()
   {
      return this.moduleEntries;
   }
}
