/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.security.authorization.modules;
  
import org.jboss.logging.Logger; 
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.ResourceType;

//$Id: JACCAuthorizationModule.java 59234 2006-12-26 21:11:55Z anil.saldhana@jboss.com $

/**
 *  Authorization Module that enforces JACC semantics
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @since  Jul 7, 2006 
 *  @version $Revision: 59234 $
 */
public class JACCAuthorizationModule extends AbstractAuthorizationModule
{   
   public JACCAuthorizationModule()
   { 
      log = Logger.getLogger(getClass());
      delegateMap.put(ResourceType.WEB,
          "org.jboss.web.tomcat.security.authorization.delegates.WebJACCPolicyModuleDelegate");
      delegateMap.put(ResourceType.EJB,
         "org.jboss.security.authorization.modules.ejb.EJBJACCPolicyModuleDelegate");
   }

   /**
    * @see AbstractAuthorizationModule#authorize(Resource)
    */
   public int authorize(Resource resource)
   {
      return this.invokeDelegate(resource);
   }  
}
