/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.security.config;

import java.util.ArrayList;
import java.util.List;

import javax.security.auth.AuthPermission;

import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;

/**
 *  Identity Trust Info
 *  @author <a href="mailto:Anil.Saldhana@redhat.com">Anil Saldhana</a>
 *  @version $Revision$
 *  @since  July 25, 2007
 */
public class IdentityTrustInfo
{ 
   public static final AuthPermission GET_CONFIG_ENTRY_PERM = new AuthPermission("getLoginConfiguration");
   public static final AuthPermission SET_CONFIG_ENTRY_PERM = new AuthPermission("setLoginConfiguration");
   protected String name;
   protected ArrayList<IdentityTrustModuleEntry> moduleEntries = new ArrayList<IdentityTrustModuleEntry>();

   public IdentityTrustInfo(String name)
   { 
      this.name = name;
   }

   public String getName()
   {
      return name;
   }

   public void add(List<IdentityTrustModuleEntry> moduleEntries)
   {
      this.moduleEntries.addAll(moduleEntries);
   }

   public void add(IdentityTrustModuleEntry ame)
   {
      moduleEntries.add(ame);
   }

   public IdentityTrustModuleEntry[] getIdentityTrustModuleEntry()
   {
      SecurityManager sm = System.getSecurityManager();
      if( sm != null )
         sm.checkPermission(GET_CONFIG_ENTRY_PERM); 
      IdentityTrustModuleEntry[] entries = new IdentityTrustModuleEntry[moduleEntries.size()];
      moduleEntries.toArray(entries);
      return entries;
   }
   
   public void setName(String n)
   {
      this.name = n;
   } 
}