/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.security.audit.config.AuditProviderEntry;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.AppConfigurationEntryHolder;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.authorization.config.AuthorizationConfigEntryHolder;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuditInfo;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.IdentityTrustInfo;
import org.jboss.security.config.RoleMappingInfo;
import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;
import org.jboss.xb.binding.GenericValueContainer;

public class ApplicationPolicyContainer
implements GenericValueContainer {
    private static Logger log = Logger.getLogger(ApplicationPolicyContainer.class);
    ApplicationPolicy info = null;
    String authName = null;
    List authenticationModuleEntries = new ArrayList();
    List authorizationModuleEntries = new ArrayList();
    List auditProviderEntries = new ArrayList();
    List identityTrustModuleEntries = new ArrayList();
    Map loginModuleStackMap = new HashMap();
    boolean isJASPIAuthentication = false;
    boolean isJAASAuthentication = false;
    boolean isAuthorization = false;
    boolean containsAudit = false;
    boolean containsIdentityTrust = false;
    boolean containsRoleMapping = false;
    RoleMappingInfo roleMappingInfo = null;
    AuditInfo auditInfo = null;
    IdentityTrustInfo identityTrustInfo = null;

    public void addChild(QName name, Object value) {
        log.debug((Object)("addChild::" + name + ":" + value));
        if ("name".equals(name.getLocalPart())) {
            this.authName = (String)value;
        } else if (value instanceof AppConfigurationEntryHolder) {
            AppConfigurationEntryHolder ace = (AppConfigurationEntryHolder)value;
            this.authenticationModuleEntries.add(ace.getEntry());
            this.isJAASAuthentication = true;
        } else if (value instanceof AppConfigurationEntry) {
            AppConfigurationEntry ace = (AppConfigurationEntry)value;
            this.authenticationModuleEntries.add(ace);
            this.isJAASAuthentication = true;
        } else if (value instanceof AuthModuleEntry) {
            AuthModuleEntry ame = (AuthModuleEntry)value;
            String lmshName = ame.getLoginModuleStackHolderName();
            if (lmshName != null) {
                ame.setLoginModuleStackHolder((LoginModuleStackHolder)this.loginModuleStackMap.get(lmshName));
            }
            this.authenticationModuleEntries.add(ame);
            this.isJASPIAuthentication = true;
        } else if (value instanceof LoginModuleStackHolder) {
            LoginModuleStackHolder lmsh = (LoginModuleStackHolder)value;
            this.loginModuleStackMap.put(lmsh.getName(), lmsh);
            this.isJASPIAuthentication = true;
        } else if (value instanceof AuthorizationModuleEntry) {
            AuthorizationModuleEntry ame = (AuthorizationModuleEntry)value;
            if (!this.authorizationModuleEntries.contains(ame)) {
                this.authorizationModuleEntries.add(ame);
            }
            this.isAuthorization = true;
        } else if (value instanceof AuthorizationConfigEntryHolder) {
            AuthorizationConfigEntryHolder ame = (AuthorizationConfigEntryHolder)value;
            AuthorizationModuleEntry ameEntry = ame.getEntry();
            if (!this.authorizationModuleEntries.contains(ameEntry)) {
                this.authorizationModuleEntries.add(ameEntry);
            }
            this.isAuthorization = true;
        } else if (value instanceof AuditProviderEntry) {
            AuditProviderEntry ameEntry = (AuditProviderEntry)value;
            if (!this.auditProviderEntries.contains(ameEntry)) {
                this.auditProviderEntries.add(ameEntry);
            }
            this.containsAudit = true;
        } else if (value instanceof IdentityTrustModuleEntry) {
            IdentityTrustModuleEntry ameEntry = (IdentityTrustModuleEntry)value;
            if (!this.identityTrustModuleEntries.contains(ameEntry)) {
                this.identityTrustModuleEntries.add(ameEntry);
            }
            this.containsIdentityTrust = true;
        }
    }

    public void addMappingInfo(Object obj) {
        log.debug(obj);
        if (obj instanceof RoleMappingInfo) {
            this.roleMappingInfo = (RoleMappingInfo)obj;
            this.roleMappingInfo.setName(this.authName);
            this.containsRoleMapping = true;
        }
    }

    public Object instantiate() {
        this.info = new ApplicationPolicy(this.authName);
        BaseAuthenticationInfo binfo = null;
        AuthorizationInfo ainfo = null;
        if (this.isJAASAuthentication) {
            binfo = new AuthenticationInfo(this.authName);
            binfo.add(this.authenticationModuleEntries);
            this.info.setAuthenticationInfo(binfo);
        }
        if (this.isJASPIAuthentication) {
            binfo = new JASPIAuthenticationInfo(this.authName);
            binfo.add(this.authenticationModuleEntries);
            this.info.setAuthenticationInfo(binfo);
        }
        if (this.isAuthorization) {
            ainfo = new AuthorizationInfo(this.authName);
            ainfo.add(this.authorizationModuleEntries);
            this.info.setAuthorizationInfo(ainfo);
        }
        if (this.containsRoleMapping) {
            this.info.setRoleMappingInfo(this.roleMappingInfo);
        }
        if (this.containsAudit) {
            this.auditInfo = new AuditInfo(this.authName);
            this.auditInfo.add(this.auditProviderEntries);
            this.info.setAuditInfo(this.auditInfo);
        }
        if (this.containsIdentityTrust) {
            this.identityTrustInfo = new IdentityTrustInfo(this.authName);
            this.identityTrustInfo.add(this.identityTrustModuleEntries);
            this.info.setIdentityTrustInfo(this.identityTrustInfo);
        }
        return this.info;
    }

    public Class getTargetClass() {
        return ApplicationPolicy.class;
    }
}

