/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SubjectInfo;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.security.identitytrust.IdentityTrustManager;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.plugins.DefaultSecurityManagement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossSecurityContext
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = Logger.getLogger(JBossSecurityContext.class);
    protected boolean trace = log.isTraceEnabled();
    protected Map<String, Object> contextData = new HashMap<String, Object>();
    protected String securityDomain = "other";
    protected SubjectInfo subjectInfo = null;
    protected RunAs incomingRunAs = null;
    protected RunAs outgoingRunAs = null;
    protected ISecurityManagement iSecurityManagement;
    protected CallbackHandler callbackHandler = new SecurityAssociationHandler();

    public JBossSecurityContext(String securityDomain) {
        this.securityDomain = securityDomain;
        this.iSecurityManagement = new DefaultSecurityManagement(this.callbackHandler);
        this.getUtil().createSubjectInfo(null, null, null);
    }

    public ISecurityManagement getSecurityManagement() {
        return this.iSecurityManagement;
    }

    public void setSecurityManagement(ISecurityManagement ism) {
        if (ism == null) {
            throw new IllegalArgumentException("ism is null");
        }
        this.iSecurityManagement = ism;
    }

    public Map<String, Object> getData() {
        return this.contextData;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public SubjectInfo getSubjectInfo() {
        return this.subjectInfo;
    }

    public RunAs getIncomingRunAs() {
        return this.incomingRunAs;
    }

    public void setIncomingRunAs(RunAs runAs) {
        this.incomingRunAs = runAs;
    }

    public RunAs getOutgoingRunAs() {
        return this.outgoingRunAs;
    }

    public void setOutgoingRunAs(RunAs runAs) {
        this.outgoingRunAs = runAs;
    }

    public SecurityContextUtil getUtil() {
        SecurityContextUtil util = null;
        try {
            util = SecurityContextFactory.createUtil((SecurityContext)this);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return util;
    }

    public AuditManager getAuditManager() {
        return this.iSecurityManagement.getAuditManager(this.securityDomain);
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.iSecurityManagement.getAuthenticationManager(this.securityDomain);
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.iSecurityManagement.getAuthorizationManager(this.securityDomain);
    }

    public IdentityTrustManager getIdentityTrustManager() {
        return this.iSecurityManagement.getIdentityTrustManager(this.securityDomain);
    }

    public MappingManager getMappingManager() {
        return this.iSecurityManagement.getMappingManager(this.securityDomain);
    }

    public void setSubjectInfo(SubjectInfo si) {
        this.subjectInfo = si;
    }

    public void setRoles(Group roles, boolean replace) {
        Group mergedRoles = roles;
        if (!replace) {
            mergedRoles = this.mergeGroups((Group)this.contextData.get("Roles"), roles);
        }
        this.contextData.put("Roles", mergedRoles);
    }

    private Group mergeGroups(Group a, Group b) {
        Group newGroup = b;
        if (a != null) {
            Enumeration en = a.members();
            while (en.hasMoreElements()) {
                newGroup.addMember((Principal)en.nextElement());
            }
        }
        return newGroup;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public Object clone() throws CloneNotSupportedException {
        JBossSecurityContext jsc = (JBossSecurityContext)super.clone();
        if (jsc != null) {
            jsc.contextData = (Map)((HashMap)this.contextData).clone();
        }
        return super.clone();
    }
}

