/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore;

import com.arjuna.ats.arjuna.utils.ThreadUtil;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import java.util.Hashtable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public class BaseTransaction {
    private static boolean _supportSubtransactions = false;
    private static Hashtable _timeouts = new Hashtable();

    public void begin() throws NotSupportedException, SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.begin");
        }
        if (!_supportSubtransactions) {
            try {
                this.checkTransactionState();
            }
            catch (IllegalStateException e1) {
                throw new NotSupportedException(e1.getMessage());
            }
            catch (Exception e2) {
                throw new SystemException(e2.toString());
            }
        }
        Integer value = (Integer)_timeouts.get(ThreadUtil.getThreadId());
        int v = 0;
        if (value != null) {
            v = value;
        }
        TransactionImple.putTransaction(new TransactionImple(v));
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImple theTransaction;
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.commit");
        }
        if ((theTransaction = TransactionImple.getTransaction()) == null) {
            throw new IllegalStateException("BaseTransaction.commit - " + jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.notx"));
        }
        theTransaction.commitAndDisassociate();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionImple theTransaction;
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.rollback");
        }
        if ((theTransaction = TransactionImple.getTransaction()) == null) {
            throw new IllegalStateException("BaseTransaction.rollback - " + jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.notx"));
        }
        theTransaction.rollbackAndDisassociate();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TransactionImple theTransaction;
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.setRollbackOnly");
        }
        if ((theTransaction = TransactionImple.getTransaction()) == null) {
            throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.nosuchtx"));
        }
        theTransaction.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        TransactionImple theTransaction;
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.getStatus");
        }
        if ((theTransaction = TransactionImple.getTransaction()) == null) {
            return 6;
        }
        return theTransaction.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds >= 0) {
            _timeouts.put(ThreadUtil.getThreadId(), new Integer(seconds));
        }
    }

    public int getTimeout() throws SystemException {
        Integer value = (Integer)_timeouts.get(ThreadUtil.getThreadId());
        if (value != null) {
            return value;
        }
        return 0;
    }

    public String toString() {
        TransactionImple theTransaction = TransactionImple.getTransaction();
        if (theTransaction == null) {
            return "Transaction: unknown";
        }
        return "Transaction: " + theTransaction;
    }

    public TransactionImple createSubordinate() throws NotSupportedException, SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.createSubordinate");
        }
        try {
            this.checkTransactionState();
        }
        catch (IllegalStateException e1) {
            throw new NotSupportedException();
        }
        catch (Exception e2) {
            throw new SystemException(e2.toString());
        }
        Integer value = (Integer)_timeouts.get(ThreadUtil.getThreadId());
        int v = 0;
        if (value != null) {
            v = value;
        }
        return new com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.TransactionImple(v);
    }

    protected BaseTransaction() {
    }

    final void checkTransactionState() throws IllegalStateException, SystemException {
        TransactionImple theTransaction = TransactionImple.getTransaction();
        if (theTransaction == null) {
            return;
        }
        if (theTransaction.getStatus() != 6 && !_supportSubtransactions) {
            throw new IllegalStateException("BaseTransaction.checkTransactionState - " + jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.alreadyassociated"));
        }
    }

    static {
        String subtran = jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.supportSubtransactions");
        if (subtran != null && subtran.equals("YES")) {
            _supportSubtransactions = true;
        }
    }
}

