/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jbossatx.jta;

import com.arjuna.ats.jta.recovery.XAResourceRecovery;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;

public class AppServerJDBCXARecovery
implements XAResourceRecovery {
    private boolean _supportsIsValidMethod;
    private XAConnection _connection;
    private XADataSource _dataSource;
    private LocalConnectionEventListener _connectionEventListener;
    private boolean _hasMoreResources;
    private String _dataSourceId;
    private Logger log = Logger.getLogger(AppServerJDBCXARecovery.class);

    public AppServerJDBCXARecovery() throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"AppServerJDBCXARecovery<init>");
        }
        this._hasMoreResources = false;
        this._connectionEventListener = new LocalConnectionEventListener();
    }

    public boolean initialise(String parameter) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("AppServerJDBCXARecovery.initialise(" + parameter + ")"));
        }
        if (parameter == null) {
            return false;
        }
        this._dataSourceId = parameter;
        return true;
    }

    public synchronized XAResource getXAResource() throws SQLException {
        this.createConnection();
        if (this._connection == null) {
            throw new SQLException("The data source named [" + this._dataSourceId + "] is not deployed.");
        }
        return this._connection.getXAResource();
    }

    public boolean hasMoreResources() {
        if (this._dataSource == null) {
            try {
                this.createDataSource();
            }
            catch (SQLException sqlException) {
                return false;
            }
        }
        if (this._dataSource != null) {
            this._hasMoreResources = !this._hasMoreResources;
            return this._hasMoreResources;
        }
        return false;
    }

    private final void createDataSource() throws SQLException {
        block7: {
            try {
                if (this._dataSource != null) break block7;
                InitialContext context = new InitialContext();
                MBeanServerConnection server = (MBeanServerConnection)context.lookup("jmx/invoker/RMIAdaptor");
                ObjectName objectName = new ObjectName("jboss.jca:name=" + this._dataSourceId + ",service=ManagedConnectionFactory");
                String className = (String)server.invoke(objectName, "getManagedConnectionFactoryAttribute", new Object[]{"XADataSourceClass"}, new String[]{"java.lang.String"});
                this.log.debug((Object)("AppServerJDBCXARecovery datasource classname = " + className));
                String properties = (String)server.invoke(objectName, "getManagedConnectionFactoryAttribute", new Object[]{"XADataSourceProperties"}, new String[]{"java.lang.String"});
                try {
                    this._dataSource = this.getXADataSource(className, properties);
                    this._supportsIsValidMethod = true;
                }
                catch (Exception e) {
                    this._dataSource = null;
                    this.log.error((Object)("AppServerJDBCXARecovery.createDataSource got exception during getXADataSource call: " + e.toString()), (Throwable)e);
                    throw new SQLException(e.toString());
                }
            }
            catch (MBeanException mbe) {
                if (mbe.getTargetException() instanceof InstanceNotFoundException) {
                    this.log.warn((Object)("AppServerJDBCXARecovery.createDataSource(name=" + this._dataSourceId + "): InstanceNotFound. Datasource not deployed, or wrong name?"));
                    return;
                }
                this.log.error((Object)("AppServerJDBCXARecovery.createDataSource(name=" + this._dataSourceId + ") got exception " + mbe.toString()), (Throwable)mbe);
                throw new SQLException(mbe.toString());
            }
            catch (SQLException ex) {
                this.log.error((Object)("AppServerJDBCXARecovery.createDataSource got exception " + ex.toString()), (Throwable)ex);
                throw ex;
            }
            catch (Exception e) {
                this.log.error((Object)("AppServerJDBCXARecovery.createDataSource got exception " + e.toString()), (Throwable)e);
                throw new SQLException(e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createConnection() throws SQLException {
        block16: {
            try {
                Boolean isConnectionValid;
                if (this._dataSource == null) {
                    this.createDataSource();
                    if (this._dataSource == null) {
                        return;
                    }
                }
                try {
                    if (this._connection != null && this._supportsIsValidMethod) {
                        Connection connection = this._connection.getConnection();
                        Method method = connection.getClass().getMethod("isValid", Integer.class);
                        isConnectionValid = (Boolean)method.invoke((Object)connection, new Integer(5));
                    } else {
                        isConnectionValid = Boolean.FALSE;
                    }
                }
                catch (NoSuchMethodException nsme) {
                    isConnectionValid = Boolean.FALSE;
                    this._supportsIsValidMethod = false;
                    this.log.debug((Object)"XA datasource does not support isValid method - connection will always be recreated");
                }
                catch (Throwable t) {
                    isConnectionValid = Boolean.FALSE;
                    this.log.debug((Object)("XA connection is invalid - will recreate a new one. Cause: " + t));
                }
                if (isConnectionValid.booleanValue()) break block16;
                if (this._connection != null) {
                    try {
                        this._connection.close();
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        this._connection = null;
                    }
                }
                this._connection = this._dataSource.getXAConnection();
                this._connection.addConnectionEventListener(this._connectionEventListener);
                this.log.debug((Object)"Created new XAConnection");
            }
            catch (SQLException ex) {
                this.log.error((Object)("AppServerJDBCXARecovery.createConnection got exception " + ex.toString()), (Throwable)ex);
                throw ex;
            }
            catch (Exception e) {
                this.log.error((Object)("AppServerJDBCXARecovery.createConnection got exception " + e.toString()), (Throwable)e);
                throw new SQLException(e.toString());
            }
        }
    }

    private XADataSource getXADataSource(String xaDataSourceClassname, String propertiesString) throws Exception {
        propertiesString = propertiesString.replaceAll("\\\\", "\\\\\\\\");
        Properties properties = new Properties();
        ByteArrayInputStream is = new ByteArrayInputStream(propertiesString.getBytes());
        properties.load(is);
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(xaDataSourceClassname);
        XADataSource xads = (XADataSource)clazz.newInstance();
        Class[] NOCLASSES = new Class[]{};
        for (String string : properties.keySet()) {
            String value = properties.getProperty(string);
            Class type = null;
            try {
                Method getter = clazz.getMethod("get" + string, NOCLASSES);
                type = getter.getReturnType();
            }
            catch (NoSuchMethodException e) {
                type = String.class;
                try {
                    Method getter = clazz.getMethod("is" + string, NOCLASSES);
                    type = getter.getReturnType();
                }
                catch (NoSuchMethodException nsme) {
                    type = String.class;
                }
            }
            Method setter = clazz.getMethod("set" + string, type);
            PropertyEditor editor = PropertyEditorManager.findEditor(type);
            editor.setAsText(value);
            setter.invoke((Object)xads, editor.getValue());
        }
        return xads;
    }

    private class LocalConnectionEventListener
    implements ConnectionEventListener {
        private LocalConnectionEventListener() {
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            AppServerJDBCXARecovery.this._connection.removeConnectionEventListener(AppServerJDBCXARecovery.this._connectionEventListener);
            AppServerJDBCXARecovery.this._connection = null;
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            AppServerJDBCXARecovery.this._connection.removeConnectionEventListener(AppServerJDBCXARecovery.this._connectionEventListener);
            AppServerJDBCXARecovery.this._connection = null;
        }
    }
}

