/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jbossatx.agent;

import com.arjuna.ats.tsmx.agent.AgentInterface;
import com.arjuna.ats.tsmx.agent.exceptions.AgentNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

public class JBossAgentImpl
implements AgentInterface {
    private MBeanServer _server = null;

    public JBossAgentImpl() {
        InitialContext ctx;
        String providerUrl = System.getProperty("java.naming.provider.url", "jnp://localhost:1099");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        env.put("java.naming.provider.url", providerUrl);
        env.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        try {
            ctx = new InitialContext(env);
        }
        catch (NamingException ne) {
            throw new ExceptionInInitializerError(ne);
        }
        RMIAdaptor adaptor = null;
        try {
            adaptor = (RMIAdaptor)ctx.lookup("jmx/rmi/RMIAdaptor");
        }
        catch (NamingException ne) {
            try {
                adaptor = (RMIAdaptor)ctx.lookup("jmx/invoker/RMIAdaptor");
            }
            catch (NamingException ne2) {
                throw new ExceptionInInitializerError(ne2);
            }
        }
        Class<MBeanServer> serverClass = MBeanServer.class;
        this._server = (MBeanServer)Proxy.newProxyInstance(serverClass.getClassLoader(), new Class[]{serverClass}, (InvocationHandler)new RemoteInvocationHandler(adaptor));
    }

    public MBeanServer getAgent() throws AgentNotFoundException {
        if (this._server == null) {
            throw new AgentNotFoundException("Failed to lookup JBOSS agent");
        }
        return this._server;
    }

    public static class RuntimeIOException
    extends RuntimeException {
        private static final long serialVersionUID = 3976733670713669941L;
        private final Throwable nestedThrowable;

        public RuntimeIOException(Throwable nestedThrowable) {
            this.nestedThrowable = nestedThrowable;
        }

        @Override
        public String getLocalizedMessage() {
            return this.nestedThrowable.getLocalizedMessage();
        }

        @Override
        public String getMessage() {
            return this.nestedThrowable.getMessage();
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            return this.nestedThrowable.getStackTrace();
        }

        @Override
        public void printStackTrace() {
            this.nestedThrowable.printStackTrace();
        }

        @Override
        public void printStackTrace(PrintStream ps) {
            this.nestedThrowable.printStackTrace(ps);
        }

        @Override
        public void printStackTrace(PrintWriter pw) {
            this.nestedThrowable.printStackTrace(pw);
        }
    }

    public static class RemoteInvocationHandler
    implements InvocationHandler {
        private static final Class ADAPTOR_CLASS = RMIAdaptor.class;
        private final RMIAdaptor adaptor;

        public RemoteInvocationHandler(RMIAdaptor adaptor) {
            this.adaptor = adaptor;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method adaptorMethod;
            String methodName = method.getName();
            try {
                adaptorMethod = ADAPTOR_CLASS.getMethod(methodName, method.getParameterTypes());
            }
            catch (NoSuchMethodException nsme) {
                throw new UnsupportedOperationException("Operation " + methodName + " not supported with remote proxy", nsme);
            }
            try {
                return adaptorMethod.invoke((Object)this.adaptor, args);
            }
            catch (InvocationTargetException ite) {
                Throwable target = ite.getTargetException();
                if (target instanceof IOException) {
                    throw new RuntimeIOException(target);
                }
                throw target;
            }
        }
    }
}

