/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jbossatx.jta;

import com.arjuna.ats.arjuna.common.Configuration;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.internal.jbossatx.jta.XAResourceRecoveryHelperWrapper;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import org.jboss.logging.Logger;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;

public class RecoveryManagerService
implements XAResourceRecoveryRegistry {
    protected Logger log = Logger.getLogger(RecoveryManagerService.class);
    private RecoveryManager _recoveryManager;

    public void create() throws Exception {
        String tag = Configuration.getBuildTimeProperty((String)"SOURCEID");
        this.log.info((Object)("JBossTS Recovery Service (tag:" + tag + ") - JBoss Inc."));
        RecoveryManager.delayRecoveryManagerThread();
        this._recoveryManager = RecoveryManager.manager();
    }

    public void destroy() {
    }

    public void start() {
        this.log.info((Object)"Starting transaction recovery manager");
        this._recoveryManager.initialize();
        this._recoveryManager.startRecoveryManagerThread();
    }

    public void stop() throws Exception {
        this.log.info((Object)"Stopping transaction recovery manager");
        this._recoveryManager.terminate();
    }

    public void addXAResourceRecovery(XAResourceRecovery xaResourceRecovery) {
        if (this._recoveryManager == null) {
            this.log.error((Object)"No recovery system in which to register XAResourceRecovery instance");
            throw new IllegalStateException("No recovery system present in this server");
        }
        XARecoveryModule xaRecoveryModule = null;
        for (RecoveryModule recoveryModule : this._recoveryManager.getModules()) {
            if (!(recoveryModule instanceof XARecoveryModule)) continue;
            xaRecoveryModule = (XARecoveryModule)recoveryModule;
            break;
        }
        if (xaRecoveryModule == null) {
            this.log.error((Object)"No suitable recovery module in which to register XAResourceRecovery instance");
            throw new IllegalStateException("No xa recovery module present in this server");
        }
        xaRecoveryModule.addXAResourceRecoveryHelper((XAResourceRecoveryHelper)new XAResourceRecoveryHelperWrapper(xaResourceRecovery));
    }

    public void removeXAResourceRecovery(XAResourceRecovery xaResourceRecovery) {
        if (this._recoveryManager == null) {
            this.log.warn((Object)"No recovery system from which to remove XAResourceRecovery instance");
            return;
        }
        XARecoveryModule xaRecoveryModule = null;
        for (RecoveryModule recoveryModule : this._recoveryManager.getModules()) {
            if (!(recoveryModule instanceof XARecoveryModule)) continue;
            xaRecoveryModule = (XARecoveryModule)recoveryModule;
            break;
        }
        if (xaRecoveryModule == null) {
            this.log.warn((Object)"No suitable recovery module in which to register XAResourceRecovery instance");
            return;
        }
        xaRecoveryModule.removeXAResourceRecoveryHelper((XAResourceRecoveryHelper)new XAResourceRecoveryHelperWrapper(xaResourceRecovery));
    }
}

