/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.communication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.jrunit.communication.MessageBusListener;
import org.jboss.jrunit.communication.RemoteMemberListener;
import org.jboss.jrunit.communication.message.RemoteTestMessage;
import org.jgroups.Address;
import org.jgroups.blocks.NotificationBus;

public class MessageBus
implements NotificationBus.Consumer {
    private List listeners = new ArrayList();
    private List members = new ArrayList();
    private NotificationBus bus = new NotificationBus(this.busName, this.props);
    private RemoteMemberListener memberListener = null;
    private String busName = "BusDemo";
    private String props = "UDP(mcast_addr=228.15.2.3;mcast_port=45566;ip_ttl=64;ip_mcast=true;mcast_send_buf_size=150000;mcast_recv_buf_size=80000;ucast_send_buf_size=150000;ucast_recv_buf_size=80000;loopback=false;bind_addr=127.0.0.1):PING(timeout=2000;num_initial_members=3;up_thread=false;down_thread=false):MERGE2(min_interval=10000;max_interval=20000):FD_SOCK():VERIFY_SUSPECT(timeout=1500;up_thread=false;down_thread=false):pbcast.NAKACK(gc_lag=50;retransmit_timeout=600,1200,2400,4800;max_xmit_size=8192;up_thread=false;down_thread=false):UNICAST(timeout=600,1200,2400;window_size=100;min_threshold=10;down_thread=false):pbcast.STABLE(desired_avg_gossip=20000;up_thread=false;down_thread=false):FRAG(frag_size=8192;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true):pbcast.STATE_TRANSFER(up_thread=true;down_thread=false)";
    private static Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jboss.jrunit.communication.MessageBus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void start() throws Exception {
        this.bus.setConsumer((NotificationBus.Consumer)this);
        this.bus.start();
    }

    public void stop() {
        log.debug((Object)"Stop on bus");
        this.bus.stop();
    }

    public void addReceiver(MessageBusListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    public boolean removeReceiver(MessageBusListener listener) {
        MessageBusListener messageBusListener = listener;
        synchronized (messageBusListener) {
            return this.listeners.remove(listener);
        }
    }

    public void handleNotification(Serializable n) {
        log.debug((Object)("MessageBus received: " + n));
        List list = this.listeners;
        synchronized (list) {
            int x = 0;
            while (x < this.listeners.size()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending message " + n + " to receiver"));
                }
                MessageBusListener l = (MessageBusListener)this.listeners.get(x);
                if (n instanceof RemoteTestMessage) {
                    l.handleRemoteTestMessage((RemoteTestMessage)n);
                    log.debug((Object)("sent message " + n + " to receiver " + l));
                } else {
                    l.handleRemoteDataMessage(n);
                    log.debug((Object)("sent data message " + n + " to receiver " + l));
                }
                ++x;
            }
        }
    }

    public Serializable getCache() {
        return null;
    }

    public void memberJoined(Address mbr) {
        this.members.add(mbr);
        log.debug((Object)("Member joined.  List is now " + this.members.size()));
        if (this.memberListener != null) {
            this.memberListener.memberChange(this.members.size());
        }
    }

    public void memberLeft(Address mbr) {
        this.members.remove(mbr);
        log.debug((Object)("Member left.  List is now " + this.members.size()));
        if (this.memberListener != null) {
            this.memberListener.memberChange(this.members.size());
        }
    }

    public int getNumberOfMembers() {
        return this.members.size();
    }

    public void sendMessage(Serializable msg) {
        log.debug((Object)("MessageBus - sending " + msg));
        this.bus.sendNotification(msg);
        log.debug((Object)("MessageBus - sent " + msg));
    }

    public void setMememberChangeListener(RemoteMemberListener listener) {
        this.memberListener = listener;
    }
}

