/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.communication.message;

import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import org.jboss.jrunit.communication.message.RemoteTestMessage;
import org.jboss.jrunit.extensions.SerializableTestFailure;

public class ResultMessage
extends RemoteTestMessage {
    private List errorList = new ArrayList();
    private List failureList = new ArrayList();
    private VMID id = new VMID();

    public ResultMessage(String testClass, TestResult result) {
        super(testClass);
        this.storeTestResult(result);
    }

    public String getId() {
        return this.id.toString();
    }

    public String toString() {
        return "ResultMessage - id =" + this.getId() + ", errors = " + (this.errorList != null ? this.errorList.size() : 0) + ", failures = " + (this.failureList != null ? this.failureList.size() : 0);
    }

    private void storeTestResult(TestResult result) {
        SerializableTestFailure tf;
        Enumeration results;
        if (result.errorCount() > 0) {
            results = result.errors();
            while (results.hasMoreElements()) {
                TestFailure error = (TestFailure)results.nextElement();
                tf = new SerializableTestFailure(error.failedTest(), error.thrownException(), this.getTestClass());
                this.errorList.add(tf);
            }
        }
        if (result.failureCount() > 0) {
            results = result.failures();
            while (results.hasMoreElements()) {
                TestFailure failure = (TestFailure)results.nextElement();
                tf = new SerializableTestFailure(failure.failedTest(), failure.thrownException(), this.getTestClass());
                this.failureList.add(tf);
            }
        }
    }

    public TestResult getTestResult() {
        TestFailure tf;
        int x;
        TestResult newResult = new TestResult();
        if (this.errorList.size() > 0) {
            x = 0;
            while (x < this.errorList.size()) {
                tf = (TestFailure)this.errorList.get(x);
                newResult.addError(tf.failedTest(), tf.thrownException());
                ++x;
            }
        }
        if (this.failureList.size() > 0) {
            x = 0;
            while (x < this.failureList.size()) {
                tf = (TestFailure)this.failureList.get(x);
                newResult.addFailure(tf.failedTest(), (AssertionFailedError)tf.thrownException());
                ++x;
            }
        }
        return newResult;
    }
}

