/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.controller.reporters;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.jboss.jrunit.controller.persistence.BenchmarkDatabaseBenchmarkPersistence;
import org.jboss.jrunit.controller.persistence.BenchmarkPersistence;
import org.jboss.jrunit.controller.reporters.BenchmarkReporter;
import org.jboss.jrunit.data.Benchmark;

public class DatabaseBenchmarkReporter
extends BenchmarkReporter {
    String jdbcClass;
    String jdbcConnection;
    String jdbcUserName;
    String jdbcPassword;

    public DatabaseBenchmarkReporter(String jdbcConnection, String jdbcClass) throws Exception {
        this.jdbcClass = jdbcClass;
        this.jdbcConnection = jdbcConnection;
    }

    public DatabaseBenchmarkReporter(String jdbcConnection, String jdbcClass, String jdbcUserName, String jdbcPassword) throws Exception {
        this(jdbcClass, jdbcConnection);
        this.jdbcUserName = jdbcUserName;
        this.jdbcPassword = jdbcPassword;
    }

    public void writeBenchmarkResults(Benchmark benchmark) {
        try {
            Connection conn = this.createConnection();
            BenchmarkDatabaseBenchmarkPersistence benchmarkPersistence = new BenchmarkDatabaseBenchmarkPersistence(conn);
            ((BenchmarkPersistence)benchmarkPersistence).persist(benchmark);
            conn.commit();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Connection createConnection() throws ClassNotFoundException, SQLException {
        if (this.jdbcClass != null) {
            Class.forName(this.jdbcClass);
        }
        Connection conn = null;
        if (this.jdbcConnection != null) {
            conn = this.jdbcUserName != null ? DriverManager.getConnection(this.jdbcConnection, this.jdbcUserName, this.jdbcPassword) : DriverManager.getConnection(this.jdbcConnection);
            try {
                conn.setAutoCommit(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return conn;
    }
}

