/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.controller.reporters;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jboss.jrunit.controller.reporters.BenchmarkReporter;
import org.jboss.jrunit.data.Benchmark;
import org.jboss.jrunit.data.BenchmarkExecution;
import org.jboss.jrunit.table.AxisReference;
import org.jboss.jrunit.table.XrefsTableList;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class XrefReporter
extends BenchmarkReporter {
    public static final String ALIAS_KEY = "alias";
    File output;
    OutputStream out;

    public XrefReporter(String output) throws Exception {
        this.output = new File(output);
        this.out = new FileOutputStream(new File(output, "jrunit-report.html"));
    }

    public void writeBenchmarkResults(Benchmark benchmark) throws Exception {
        try {
            Iterator iter = benchmark.getSubBenchmarks().values().iterator();
            XrefsTableList tableList = new XrefsTableList(2);
            while (iter.hasNext()) {
                Benchmark rowBench = (Benchmark)iter.next();
                AxisReference row = new AxisReference((Comparable[])new String[]{rowBench.getName()});
                AxisReference column = new AxisReference((Comparable[])new String[]{this.getMetadata(rowBench, true)});
                int executions = rowBench.getDefaultExecution().getExecutions();
                long elapsedTime = rowBench.getDefaultExecution().getElapsedTime();
                if (executions <= 0) continue;
                tableList.addElement(new AxisReference[]{row, column}, elapsedTime / (long)executions);
            }
            tableList.doOrdering();
            PrintStream print = new PrintStream(this.out);
            print.println("<html><body>");
            this.printItems(print, tableList);
            print.println("<img src='./benchmarkChart.jpg'>");
            print.println("</body></html>");
            JFreeChart chart = this.createFreeChart(benchmark.getSubBenchmarks().values());
            FileOutputStream fileOut = new FileOutputStream(new File(this.output, "benchmarkChart.jpg"));
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOut);
            BufferedImage image = chart.createBufferedImage(1600, 600);
            encoder.encode(image);
            fileOut.flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Exception(e.getMessage(), e);
        }
    }

    private JFreeChart createFreeChart(Collection items) throws Exception {
        return this.createFreeChart(items, new DefaultCategoryDataset());
    }

    private JFreeChart createFreeChart(Collection items, DefaultCategoryDataset categorySet) throws Exception {
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            Benchmark benchmark = (Benchmark)iter.next();
            BenchmarkExecution[] executions = benchmark.getExecution();
            int i = 0;
            while (i < executions.length) {
                categorySet.addValue((double)(executions[i].getElapsedTime() / (long)executions[i].getExecutions()), (Comparable)((Object)benchmark.getName()), (Comparable)((Object)this.getMetadata(benchmark, false)));
                ++i;
            }
            if (benchmark.getSubBenchmarks().size() == 0) continue;
            this.createFreeChart(benchmark.getSubBenchmarks().values(), categorySet);
        }
        return ChartFactory.createBarChart((String)"Benchmarks Evolution", (String)"Executions", (String)"Avg Time", (CategoryDataset)categorySet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
    }

    private String getMetadata(Benchmark benchmark, boolean htmlValue) {
        StringBuffer buffer = new StringBuffer();
        Map metadata = benchmark.getMetadata();
        if (metadata != null && metadata.containsKey(ALIAS_KEY)) {
            Object value = metadata.get(ALIAS_KEY);
            if (htmlValue) {
                try {
                    String legendPage = this.writeAliasLegend(value, metadata);
                    buffer.append("<a href=\"" + legendPage + "\">" + value + "</a>");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    buffer.append("alias=" + value.toString());
                }
            } else {
                buffer.append("alias=" + value.toString());
            }
        } else {
            Iterator iter = benchmark.getMetadata().entrySet().iterator();
            if (!iter.hasNext()) {
                buffer.append("N/A");
            }
            while (iter.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = iter.next();
                buffer.append(String.valueOf(entry.getKey().toString()) + "=" + entry.getValue().toString());
                if (!iter.hasNext()) continue;
                buffer.append(", ");
            }
        }
        return buffer.toString();
    }

    private String writeAliasLegend(Object alias, Map metadata) throws IOException {
        String aliasName = alias.toString();
        String legendPage = String.valueOf(aliasName) + ".html";
        File reportFile = new File(this.output, legendPage);
        if (!reportFile.exists()) {
            reportFile.createNewFile();
        }
        FileWriter reportWriter = new FileWriter(reportFile, false);
        reportWriter.write("<html><head><title>Legend for " + aliasName + "</title></head><body><table " + "style=\"text-align: left; width: 100%;\" border=\"1\" cellspacing=\"2\"\n" + "      cellpadding=\"2\">\n" + "      <tbody>");
        reportWriter.write("<tr><td><b>Alias</b><br></td><td><b>" + aliasName + "</b><br></td></tr>");
        if (metadata != null) {
            Iterator itr = metadata.keySet().iterator();
            while (itr.hasNext()) {
                Object key = itr.next();
                if (ALIAS_KEY.equalsIgnoreCase(key.toString())) continue;
                Object value = metadata.get(key);
                reportWriter.write("<tr><td>" + key + "<br></td><td>" + value + "<br></td></tr>");
            }
        }
        reportWriter.write("</tbody></table><br></body></html>");
        reportWriter.close();
        return legendPage;
    }

    private void printItems(PrintStream out, XrefsTableList list) {
        AxisReference referenceRow = (AxisReference)list.getAxisSet()[0].first();
        AxisReference referenceColumn = (AxisReference)list.getAxisSet()[1].first();
        out.println("<table border=1>");
        Iterator iter = list.getAxisSet()[1].iterator();
        StringBuffer[] lines = new StringBuffer[referenceColumn.getReferences().length];
        int i = 0;
        while (i < lines.length) {
            lines[i] = new StringBuffer();
            if (referenceRow.getReferences().length > 0) {
                lines[i].append("<tr><td colspan='" + referenceRow.getReferences().length + "'>&nbsp</td>");
            }
            ++i;
        }
        while (iter.hasNext()) {
            AxisReference itemReference = (AxisReference)iter.next();
            Comparable[] references = itemReference.getReferences();
            int i2 = 0;
            while (i2 < lines.length) {
                lines[i2].append("<td>" + references[i2] + "</td>");
                ++i2;
            }
        }
        i = 0;
        while (i < lines.length) {
            lines[i].append("</tr>");
            out.println(lines[i]);
            ++i;
        }
        iter = list.getContentSet().iterator();
        int lastrow = -1;
        int lastcol = -1;
        while (iter.hasNext()) {
            XrefsTableList.ValueContainer valueContainer = (XrefsTableList.ValueContainer)iter.next();
            int currentrow = valueContainer.getAxis(0).getOrder();
            if (lastrow != currentrow) {
                lastcol = -1;
                if (lastrow != -1) {
                    out.println("</tr>");
                }
                lastrow = currentrow;
                out.println("<tr>");
                referenceRow = valueContainer.getAxis(0);
                int i3 = 0;
                while (i3 < referenceRow.getReferences().length) {
                    out.println("<td>" + referenceRow.getReferences()[i3] + "</td>");
                    ++i3;
                }
            }
            int currentcolumn = valueContainer.getAxis(1).getOrder();
            int i4 = lastcol + 1;
            while (i4 < currentcolumn) {
                System.out.println("column " + i4);
                out.println("<td>&nbsp;</td>");
                ++i4;
            }
            lastcol = currentcolumn;
            out.println("<td>" + valueContainer.getValue() + "</td>");
        }
        out.println("</tr></table>");
    }
}

