/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.decorators;

import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.jboss.jrunit.decorators.ThreadListener;

public class JunitLoopDecorator
implements Test,
Runnable {
    private static final String LOOPTEARDOWN = "loopTearDown";
    private static final String LOOPSETUP = "loopSetup";
    private static final String THREADTEARDOWN = "threadTearDown";
    private static final String THREADSETUP = "threadSetup";
    Test tests;
    TestResult result;
    Method threadSetupMethod;
    Method threadTearDownMethod;
    Method loopSetupMethod;
    Method loopTearDownMethod;
    TestCase testCase = new TestCase(){};
    Class testClazz;
    int loops;
    long timeWait;
    ThreadListener threadSynchronizer;

    public int countTestCases() {
        return this.loops;
    }

    public Test getTestDecorated() {
        return this.tests;
    }

    public JunitLoopDecorator(String loopName, Class testClazz, int loops, long timeWait) {
        this(loopName, testClazz, loops, timeWait, null);
    }

    public JunitLoopDecorator(String loopName, Class testClazz, int loops, long timeWait, ThreadListener threadSynchronizer) {
        this(loopName, testClazz, loops, timeWait, threadSynchronizer, new TestResult());
    }

    public JunitLoopDecorator(String loopName, Class testClazz, int loops, long timeWait, ThreadListener threadSynchronizer, TestResult result) {
        this.testCase.setName(loopName);
        this.loops = loops;
        this.timeWait = timeWait;
        this.testClazz = testClazz;
        this.tests = new TestSuite(testClazz, String.valueOf(testClazz.getName()) + " loop");
        this.threadSynchronizer = threadSynchronizer;
        this.result = result;
        this.findControlMethods();
    }

    private void findControlMethods() {
        this.threadSetupMethod = this.findMethod(THREADSETUP, false);
        this.threadTearDownMethod = this.findMethod(THREADTEARDOWN, false);
        this.loopSetupMethod = this.findMethod(LOOPSETUP, true);
        this.loopTearDownMethod = this.findMethod(LOOPTEARDOWN, true);
    }

    private Method findMethod(String name, boolean isLoop) {
        Class[] classArray = null;
        classArray = isLoop ? new Class[]{Integer.TYPE} : new Class[]{};
        Method method = null;
        try {
            method = this.testClazz.getDeclaredMethod(name, classArray);
        }
        catch (Exception e) {
            try {
                method = this.testClazz.getMethod(name, classArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(TestResult run) {
        block10: {
            block11: {
                block13: {
                    this.result = run;
                    this.loopSetup();
                    try {
                        try {
                            if (!this.executeStatic(this.threadSetupMethod, -1)) {
                                Object var3_2 = null;
                                this.loopTearDown();
                                if (this.threadSynchronizer == null) return;
                                this.threadSynchronizer.threadFinished((Test)this.getTestCase(), run);
                                return;
                            }
                            int i = 0;
                            while (true) {
                                if (i >= this.loops) {
                                    if (this.executeStatic(this.threadTearDownMethod, -1)) break block10;
                                    break block11;
                                }
                                if (!this.executeStatic(this.loopSetupMethod, i)) {
                                    break;
                                }
                                this.tests.run(run);
                                if (!this.executeStatic(this.loopTearDownMethod, i)) {
                                    break block13;
                                }
                                Thread.sleep(this.timeWait);
                                ++i;
                            }
                        }
                        catch (InterruptedException interrupted) {
                            interrupted.printStackTrace();
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_6 = null;
                        this.loopTearDown();
                        if (this.threadSynchronizer == null) throw throwable;
                        this.threadSynchronizer.threadFinished((Test)this.getTestCase(), run);
                        throw throwable;
                    }
                    Object var3_3 = null;
                    this.loopTearDown();
                    if (this.threadSynchronizer == null) return;
                    this.threadSynchronizer.threadFinished((Test)this.getTestCase(), run);
                    return;
                }
                Object var3_4 = null;
                this.loopTearDown();
                if (this.threadSynchronizer == null) return;
                this.threadSynchronizer.threadFinished((Test)this.getTestCase(), run);
                return;
            }
            Object var3_5 = null;
            this.loopTearDown();
            if (this.threadSynchronizer == null) return;
            this.threadSynchronizer.threadFinished((Test)this.getTestCase(), run);
            return;
        }
        Object var3_7 = null;
        this.loopTearDown();
        if (this.threadSynchronizer == null) return;
        this.threadSynchronizer.threadFinished((Test)this.getTestCase(), run);
    }

    private boolean executeStatic(Method method, int i) {
        if (method != null) {
            try {
                Object[] parameter = null;
                parameter = i >= 0 ? new Object[]{new Integer(i)} : new Object[]{};
                method.invoke(null, parameter);
            }
            catch (Exception e) {
                this.result.addError(this.tests, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void run() {
        this.run(this.result);
    }

    public TestResult getResult() {
        return this.result;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void loopSetup() {
    }

    public void loopTearDown() {
    }
}

