/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.harness;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jboss.jrunit.communication.MessageBus;
import org.jboss.jrunit.communication.MessageBusListener;
import org.jboss.jrunit.communication.RemoteMemberListener;
import org.jboss.jrunit.communication.message.AbortMessage;
import org.jboss.jrunit.communication.message.ExceptionMessage;
import org.jboss.jrunit.communication.message.OfflineMessage;
import org.jboss.jrunit.communication.message.OnlineMessage;
import org.jboss.jrunit.communication.message.RemoteTestMessage;
import org.jboss.jrunit.communication.message.ResultMessage;
import org.jboss.jrunit.communication.message.RunTestMessage;
import org.jboss.jrunit.communication.message.ServerResultMessage;
import org.jboss.jrunit.communication.message.StartupMessage;
import org.jboss.jrunit.communication.message.TearDownMessage;
import org.jboss.jrunit.communication.message.TornDownMessage;

public abstract class TestDriver
extends TestCase
implements MessageBusListener,
RemoteMemberListener {
    private List clientList = new ArrayList();
    private List serverlist = new ArrayList();
    private List processList = new ArrayList();
    private Latch serverStartupLock = new Latch();
    private long serverStartupTimeout = 30000L;
    private Latch resultsLock = new Latch();
    private Latch serverResultsLock = new Latch();
    private long serverResultsTimeout = 30000L;
    private Latch processStartupLock = new Latch();
    private long processStartupTimeout = 30000L;
    private Latch tornDownLock = new Latch();
    private long tornDownTimeout = 20000L;
    private Object messageLock = new Object();
    private int numOfStartupMsgs = 0;
    private boolean areServerTests = false;
    private List results = new ArrayList();
    private MessageBus bus = null;
    private int totalNumberOfMembers = 0;
    private int currentNumberOfMembers = 0;
    private TestResult localResult = null;
    private boolean clientOnly = false;
    public static final long RESULTS_TIMEOUT = 60000L;
    public static final long TEARDOWN_TIMEOUT = 360000L;
    public static final long RUN_TEST_TIMEOUT = 30000L;
    public static final Level DEFAULT_TEST_LOG_LEVEL = Level.DEBUG;
    public static final Level DEFAULT_TEST_HARNESS_LOG_LEVEL = Level.ERROR;
    private static Logger log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jboss.jrunit.harness.TestDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void setUp() {
        this.declareTestClasses();
        this.setupLogging();
    }

    private void setupLogging() {
        BasicConfigurator.configure();
        Category.getRoot().setLevel(Level.INFO);
        Category.getInstance((String)"org.jboss.jrunit").setLevel(Level.DEBUG);
        Category.getInstance((String)"org.jgroups").setLevel(Level.ERROR);
        String pattern = "%d %-5p [%c] %m%n";
        PatternLayout layout = new PatternLayout(pattern);
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)layout);
        Category.getRoot().addAppender((Appender)consoleAppender);
        try {
            File logFile = new File("test_logs");
            logFile.mkdir();
            FileAppender fileAppender = new FileAppender((Layout)layout, "test_logs" + File.separator + "TestDriver_output.log");
            fileAppender.setAppend(false);
            Category.getRoot().addAppender((Appender)fileAppender);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public abstract void declareTestClasses();

    protected void addTestClasses(String client, int numOfClients) {
        this.addTestClasses(client, numOfClients, null);
    }

    protected Level getTestLogLevel() {
        return DEFAULT_TEST_LOG_LEVEL;
    }

    protected Level getTestHarnessLogLevel() {
        return DEFAULT_TEST_HARNESS_LOG_LEVEL;
    }

    protected long getResultsTimeout() {
        return 60000L;
    }

    protected long getTearDownTimeout() {
        return 360000L;
    }

    protected long getRunTestTimeout() {
        return 30000L;
    }

    protected String getExtendedClientClasspath() {
        return null;
    }

    protected String getExtendedServerClasspath() {
        return null;
    }

    protected String getClientJVMArguments() {
        return null;
    }

    protected String getServerJVMArguments() {
        return null;
    }

    protected void addTestClasses(String client, int numOfClients, String server) {
        int serverCount;
        int x = 0;
        while (x < numOfClients) {
            this.clientList.add(client);
            ++x;
        }
        int n = serverCount = server == null ? 0 : 1;
        if (serverCount == 0) {
            this.clientOnly = true;
        } else {
            this.serverlist.add(server);
        }
        this.totalNumberOfMembers = numOfClients + serverCount;
    }

    public void run(TestResult result) {
        this.localResult = result;
        super.run(result);
    }

    private void initCommChannel() throws Exception {
        this.bus = new MessageBus();
        this.bus.addReceiver(this);
        this.bus.setMememberChangeListener(this);
        this.bus.start();
        log.debug((Object)"Comm channel initialized.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testStart() throws Exception {
        block14: {
            this.initCommChannel();
            try {
                try {
                    int x = 0;
                    while (true) {
                        if (x >= this.serverlist.size()) break;
                        this.executeRemoteTest((String)this.serverlist.get(x), x + 1, this.getExtendedServerClasspath(), this.getServerJVMArguments());
                        ++x;
                    }
                    x = 0;
                    while (true) {
                        if (x >= this.clientList.size()) {
                            log.debug((Object)"Waiting for process startup.");
                            this.waitForProcessStartup();
                            if (!this.clientOnly) {
                                log.debug((Object)"Waiting for server startup.");
                                this.waitForServerStartup();
                                log.debug((Object)"Server started up.");
                            }
                            log.debug((Object)"Sending message to run tests.");
                            this.sendRunTestsMessage();
                            log.debug((Object)"Waiting for results.");
                            this.waitForResults();
                            log.debug((Object)"Got all client results.");
                        }
                        this.executeRemoteTest((String)this.clientList.get(x), x + 1, this.getExtendedClientClasspath(), this.getClientJVMArguments());
                        ++x;
                    }
                }
                catch (Throwable thr) {
                    log.error((Object)("Was an error setting up tests due to " + thr.getMessage() + ".  Have all harnesses abort."));
                    this.sendAbortMessage();
                    this.addResultError(thr);
                }
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                if (!this.clientOnly) {
                    log.debug((Object)"Sending tear down message.");
                    this.sendTearDownMessage();
                    if (this.areServerTests) {
                        log.debug((Object)"Waiting for server results.");
                        this.waitForServerResults();
                    }
                }
                this.processResults();
                if (!this.clientOnly) {
                    log.debug((Object)"Waiting for torn down message.");
                    this.waitForTornDownMessage();
                }
                this.sendAbortMessage();
                this.shutdown();
                log.debug((Object)"TestDriver shutdown complete.  Will return from testStart().");
                throw throwable;
            }
            {
                Object var2_5 = null;
                if (this.clientOnly) break block14;
            }
            log.debug((Object)"Sending tear down message.");
            this.sendTearDownMessage();
            if (this.areServerTests) {
                log.debug((Object)"Waiting for server results.");
                this.waitForServerResults();
            }
        }
        this.processResults();
        if (!this.clientOnly) {
            log.debug((Object)"Waiting for torn down message.");
            this.waitForTornDownMessage();
        }
        this.sendAbortMessage();
        this.shutdown();
        log.debug((Object)"TestDriver shutdown complete.  Will return from testStart().");
    }

    private void addResultError(Throwable thr) {
        if (this.localResult != null) {
            this.localResult.addError((Test)this, thr);
        }
    }

    private void waitForServerResults() {
        boolean gotResults = false;
        try {
            gotResults = this.serverResultsLock.attempt(this.serverResultsTimeout);
        }
        catch (InterruptedException e) {
            log.error((Object)"Error waiting for server results.", (Throwable)e);
        }
        log.debug((Object)("Passed the results lock.  Got server results = " + gotResults));
        if (!gotResults) {
            throw new RuntimeException("Did not get expected result message from all the servers.");
        }
    }

    private void waitForTornDownMessage() {
        boolean gotTornDown = false;
        try {
            gotTornDown = this.tornDownLock.attempt(this.tornDownTimeout);
        }
        catch (InterruptedException e) {
            log.error((Object)"Error waiting for torn down message.", (Throwable)e);
        }
        log.debug((Object)("Passed the torn down lock.  Got torn down = " + gotTornDown));
    }

    private void sendTearDownMessage() {
        TearDownMessage tearDownMsg = new TearDownMessage(null);
        this.sendMessage(tearDownMsg);
    }

    private void waitForProcessStartup() {
        boolean gotAllMembers = false;
        try {
            gotAllMembers = this.processStartupLock.attempt(this.processStartupTimeout);
        }
        catch (InterruptedException e) {
            log.error((Object)"Error waiting for processes to startup.", (Throwable)e);
        }
        log.debug((Object)("Passed the process startup lock.  Got all members = " + gotAllMembers));
        if (!gotAllMembers) {
            throw new RuntimeException("Did not get all members online as expected.");
        }
        log.debug((Object)"Removing processes from list since received confirmation that all tests are online.");
        while (this.processList.size() > 0) {
            this.processList.remove(0);
        }
        log.debug((Object)("All processes removed from list.  List size = " + this.processList.size()));
    }

    protected void processResults() {
        log.debug((Object)"Processing results.");
        if (this.localResult != null) {
            int x = 0;
            while (x < this.results.size()) {
                TestResult r = (TestResult)this.results.get(x);
                Enumeration errorEnum = r.errors();
                while (errorEnum.hasMoreElements()) {
                    TestFailure error = (TestFailure)errorEnum.nextElement();
                    this.localResult.addError(error.failedTest(), error.thrownException());
                }
                Enumeration failureEnum = r.failures();
                while (failureEnum.hasMoreElements()) {
                    TestFailure error = (TestFailure)failureEnum.nextElement();
                    this.localResult.addFailure(error.failedTest(), (AssertionFailedError)error.thrownException());
                }
                ++x;
            }
        }
    }

    private void shutdown() {
        log.debug((Object)"Waiting for all other processes to shutdown and leave group.");
        log.debug((Object)("Current number of members: " + this.currentNumberOfMembers));
        int x = 0;
        while (x < 5 && this.currentNumberOfMembers != 0) {
            try {
                this.sendAbortMessage();
                Thread.currentThread().wait(4000L);
                log.debug((Object)("Current number of members: " + this.currentNumberOfMembers));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++x;
        }
        log.debug((Object)("TestDriver stopping message bus.  Current number of members is " + this.currentNumberOfMembers));
        if (this.bus != null) {
            this.bus.stop();
        }
        x = 0;
        while (x < this.processList.size()) {
            Process p = (Process)this.processList.get(x);
            try {
                log.info((Object)("Exit code for process: " + p.exitValue()));
            }
            catch (Exception e) {
                try {
                    p.destroy();
                }
                catch (Exception e1) {
                    log.error((Object)"Error destroying process.", (Throwable)e1);
                }
            }
            ++x;
        }
    }

    private void waitForResults() {
        boolean gotResults = false;
        try {
            gotResults = this.resultsLock.attempt(this.getResultsTimeout());
        }
        catch (InterruptedException e) {
            log.error((Object)"Error waiting for results.", (Throwable)e);
        }
        log.debug((Object)("Passed the results lock.  Got results = " + gotResults));
        if (!gotResults) {
            throw new RuntimeException("Did not get expected result message from all the servers.");
        }
    }

    private void sendRunTestsMessage() {
        RunTestMessage runTestMsg = new RunTestMessage(null);
        this.sendMessage(runTestMsg);
    }

    private void sendAbortMessage() {
        AbortMessage abortMsg = new AbortMessage(null);
        this.sendMessage(abortMsg);
    }

    private void sendMessage(Serializable msg) {
        this.bus.sendMessage(msg);
    }

    private void waitForServerStartup() {
        boolean gotStartup = false;
        try {
            gotStartup = this.serverStartupLock.attempt(this.serverStartupTimeout);
        }
        catch (InterruptedException e) {
            log.error((Object)"Error waiting for server startup.", (Throwable)e);
        }
        log.debug((Object)("Passed the startup lock.  Got startup = " + gotStartup));
        if (!gotStartup) {
            throw new RuntimeException("Did not get expected startup message from all the servers.");
        }
    }

    private void executeRemoteTest(String s, int num, String ec, String sysProps) {
        final String testClassName = s;
        final int number = num;
        final String extendedClasspath = ec;
        final String sysProperties = sysProps;
        new Thread(){

            public void run() {
                StringBuffer stringBuffer = new StringBuffer("java").append(TestDriver.this.getSystemProperties(sysProperties)).append("-cp \"").append(TestDriver.this.getExtendedClassPath(extendedClasspath)).append(System.getProperty("java.class.path")).append("\" ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.jboss.jrunit.harness.ServerTestHarness");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                String execCmd = stringBuffer.append(clazz.getName()).append(" ").append(testClassName).append(" ").append(number).append(" ").append(TestDriver.this.getTestLogLevel()).append(" ").append(TestDriver.this.getTestHarnessLogLevel()).append(" ").append(TestDriver.this.getTearDownTimeout()).append(" ").append(TestDriver.this.getRunTestTimeout()).toString();
                log.debug((Object)("execCmd: " + execCmd));
                try {
                    Process local = Runtime.getRuntime().exec(execCmd);
                    BufferedReader errStream = new BufferedReader(new InputStreamReader(local.getErrorStream()));
                    BufferedReader inStream = new BufferedReader(new InputStreamReader(local.getInputStream()));
                    OutputStream outStream = local.getOutputStream();
                    new Thread(this, errStream){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ BufferedReader val$errStream;
                        {
                            this.this$1 = var1_1;
                            this.val$errStream = bufferedReader;
                        }

                        public void run() {
                            try {
                                String errOut = null;
                                while ((errOut = this.val$errStream.readLine()) != null) {
                                    System.err.println(errOut);
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }.start();
                    new Thread(this, inStream){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ BufferedReader val$inStream;
                        {
                            this.this$1 = var1_1;
                            this.val$inStream = bufferedReader;
                        }

                        public void run() {
                            try {
                                String stdOut = null;
                                while ((stdOut = this.val$inStream.readLine()) != null) {
                                    System.out.println(stdOut);
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
                catch (IOException e) {
                    log.error((Object)("Error starting process: " + execCmd), (Throwable)e);
                }
            }
        }.start();
    }

    private String getSystemProperties(String vmArgs) {
        String path = " ";
        if (vmArgs != null && vmArgs.length() > 0) {
            path = " " + vmArgs + " ";
        }
        return path;
    }

    private String getExtendedClassPath(String extendedClasspath) {
        String path = "";
        if (extendedClasspath != null && extendedClasspath.length() > 0) {
            path = String.valueOf(this.convertFileSeperator(extendedClasspath)) + System.getProperty("path.separator");
        }
        return path;
    }

    private String convertFileSeperator(String property) {
        String newPath = property;
        try {
            String fileSeperator = System.getProperty("file.separator");
            String seperatorToReplace = "\\";
            if (seperatorToReplace.equals(fileSeperator)) {
                seperatorToReplace = "/";
            }
            log.debug((Object)("fileSeperator = " + fileSeperator));
            log.debug((Object)("seperatorToReplace = " + seperatorToReplace));
            CharSequence charSet = seperatorToReplace.subSequence(0, 1);
            log.debug((Object)("charSet = " + charSet));
            char c = charSet.charAt(0);
            log.debug((Object)("char = " + c));
            CharSequence charSet2 = fileSeperator.subSequence(0, 1);
            log.debug((Object)("charSet = " + charSet2));
            char c2 = charSet2.charAt(0);
            log.debug((Object)("char = " + c2));
            newPath = property.replace(c, c2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.debug((Object)("New path = " + newPath));
        return newPath;
    }

    public void handleRemoteDataMessage(Object message) {
    }

    public void handleRemoteTestMessage(RemoteTestMessage message) {
        Object object = this.messageLock;
        synchronized (object) {
            if (message instanceof StartupMessage) {
                log.debug((Object)("Got StartupMessage from " + ((StartupMessage)message).getTestClass()));
                StartupMessage startMsg = (StartupMessage)message;
                this.areServerTests = startMsg.areServerTests();
                ++this.numOfStartupMsgs;
                if (this.numOfStartupMsgs == this.serverlist.size()) {
                    this.serverStartupLock.release();
                }
            } else if (message instanceof ServerResultMessage) {
                ResultMessage resultMsg = (ResultMessage)message;
                log.debug((Object)("Got ServerResultMessage from " + resultMsg.getTestClass()));
                this.results.add(resultMsg.getTestResult());
                this.serverResultsLock.release();
            } else if (message instanceof ResultMessage) {
                ResultMessage resultMsg = (ResultMessage)message;
                log.debug((Object)("Got ResultMessage from " + resultMsg.getTestClass()));
                this.results.add(resultMsg.getTestResult());
                log.debug((Object)("results.size() = " + this.results.size()));
                log.debug((Object)("clientList.size() = " + this.clientList.size()));
                if (this.results.size() >= this.clientList.size()) {
                    log.debug((Object)"Releasing resultsLock");
                    this.resultsLock.release();
                }
            } else if (message instanceof TornDownMessage) {
                this.tornDownLock.release();
            } else if (message instanceof ExceptionMessage) {
                ExceptionMessage emsg = (ExceptionMessage)message;
                log.error((Object)("Error from " + emsg.getTestClass()));
                log.error((Object)emsg.getException());
            } else if (message instanceof OnlineMessage) {
                log.debug((Object)("Got online message from " + message.getTestClass()));
                ++this.currentNumberOfMembers;
                log.debug((Object)("Online instances changed.  Current number of members now " + this.currentNumberOfMembers + ".  Looking for total of " + this.totalNumberOfMembers));
                if (this.currentNumberOfMembers == this.totalNumberOfMembers) {
                    this.processStartupLock.release();
                }
            } else if (message instanceof OfflineMessage) {
                log.debug((Object)("Got offline message from " + message.getTestClass()));
                --this.currentNumberOfMembers;
                log.debug((Object)("Online instances changed.  Current number of members now " + this.currentNumberOfMembers + "."));
            } else {
                log.debug((Object)("Received RemoteTestMessage is of type " + message.getClass().getName()));
            }
        }
    }

    public void memberChange(int numberOfMembers) {
    }
}

