/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jrunit.table;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.jboss.jrunit.table.AxisReference;

public class XrefsTableList {
    HashMap[] axisHashMap;
    HashMap content;
    TreeSet[] axisSet;
    TreeSet contentSet;

    public void clear() {
        int i = 0;
        while (i < this.axisHashMap.length) {
            this.axisHashMap[i].clear();
            if (this.axisSet != null) {
                this.axisSet[i].clear();
                this.axisSet[i] = null;
            }
            ++i;
        }
        this.content.clear();
        this.content = null;
        if (this.contentSet != null) {
            this.contentSet.clear();
            this.contentSet = null;
        }
    }

    public XrefsTableList(int numberOfAxis) {
        this.axisHashMap = new HashMap[numberOfAxis];
        int i = 0;
        while (i < numberOfAxis) {
            this.axisHashMap[i] = new HashMap();
            ++i;
        }
        this.content = new HashMap();
    }

    public void addElement(AxisReference[] axisElement, double value) {
        Comparable[] cellReference = new AxisReference[this.axisHashMap.length];
        int i = 0;
        while (i < axisElement.length) {
            int j = 0;
            while (j < axisElement.length) {
                cellReference[j] = this.findOrCreateReference(this.axisHashMap[j], axisElement[j]);
                ++j;
            }
            ++i;
        }
        AxisReference cellAxis = new AxisReference(cellReference);
        ValueContainer container = (ValueContainer)this.content.get(cellAxis);
        if (container == null) {
            container = new ValueContainer(cellAxis);
            container.setValue(value);
            this.content.put(cellAxis, container);
        } else {
            container.addValue(value);
        }
    }

    private AxisReference findOrCreateReference(HashMap map, AxisReference parameter) {
        AxisReference axis = (AxisReference)map.get(parameter);
        if (axis == null) {
            map.put(parameter, parameter);
            axis = parameter;
        }
        return axis;
    }

    public TreeSet[] getAxisSet() {
        return this.axisSet;
    }

    public TreeSet getContentSet() {
        return this.contentSet;
    }

    public void doOrdering() {
        this.axisSet = new TreeSet[this.axisHashMap.length];
        int i = 0;
        while (i < this.axisSet.length) {
            this.axisSet[i] = new TreeSet();
            this.axisSet[i].addAll(this.axisHashMap[i].values());
            this.createOrdering(this.axisSet[i]);
            ++i;
        }
        this.contentSet = new TreeSet();
        this.contentSet.addAll(this.content.values());
    }

    private void createOrdering(TreeSet parameterAxis) {
        Iterator iterAxis = parameterAxis.iterator();
        int count = 0;
        while (iterAxis.hasNext()) {
            AxisReference reference = (AxisReference)iterAxis.next();
            reference.setOrder(count++);
        }
    }

    public static class ValueContainer
    implements Comparable {
        AxisReference xrefReference;
        double value;

        public ValueContainer(AxisReference xrefReference) {
            this.xrefReference = xrefReference;
        }

        public AxisReference getAxis(int axisNumber) {
            return (AxisReference)this.xrefReference.getReferences()[axisNumber];
        }

        public AxisReference getXrefReference() {
            return this.xrefReference;
        }

        public void setXrefReference(AxisReference xrefReference) {
            this.xrefReference = xrefReference;
        }

        public void addValue(double value) {
            this.value += value;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public int compareTo(Object o) {
            return this.xrefReference.compareTo(((ValueContainer)o).xrefReference);
        }
    }
}

