package org.jboss.maven.plugins.retro;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.jboss.ant.tasks.retrocheck.Checker;

/**
 * Maven wrapper for JBoss Retro.  By default
 * it will bind to the process classes phase, which takes
 * place immediately after the compile phase.
 * NOTE: The retro check functionality is not complete.  Please
 * do not use this part of the plugin in a production environment.
 * 
 * @phase process-classes
 * @goal retro-check
 * 
 */
public class RetroCheckMojo extends AbstractMojo
{

   //private static String lSep = System.getProperty("line.separator");

   /**
    * The Maven Project Object
    *
    * @parameter expression="${project}"
    * @required
    */
   protected MavenProject project;

   /**
    * The Maven Project Helper Object
    *
    * @component
    * @required
    */
   protected org.apache.maven.project.MavenProjectHelper projectHelper;

   /**
    * The Maven Plugin Object
    *
    * @parameter expression="${plugin.components}"
    * @required
    * @readonly
    */
   protected List pluginComponents;

   /**
    * The plugin dependencies.
    *
    * @parameter expression="${plugin.artifacts}"
    * @required
    * @readonly
    */
   private List pluginArtifacts;

   /**
    * Project classpath.
    *
    * @parameter expression="${project.compileClasspathElements}"
    * @required
    * @readonly
    */
   private List classpathElements;

   /**
    * @parameter expression="${project.pluginArtifacts}"
    * @required
    * @readonly
    */
   //private HashSet pluginArtifacts;
   /**
    * The directory for compiled classes.
    *
    * @parameter expression="${project.build.outputDirectory}"
    * @required
    * @readonly
    */
   private File targetClassesDirectory;

   /**
    * The directory for compiled classes.
    *
    * @parameter expression="${project.build.directory}"
    * @required
    * @readonly
    */
   private File targetDirectory;

   /**
    * @parameter
    */
   private boolean verbose = false;

   /**
    * @parameter
    */
   private boolean suppress = true;

   public void execute()
   {
      this.getLog().info("[retro-check] Checking classes for jdk14");

      if (!project.getArtifact().getType().equalsIgnoreCase("jar")) {
         this.getLog().info("[retro-check] Project " + project.getName() + " is not"
               + " a jar project.  No retro compile needed.");
         return;
      }
      ArrayList<String> argsList = new ArrayList<String>();

      if (verbose)
      {
         argsList.add("-verbose");
      }
      if (suppress)
      {
         argsList.add("-suppress");
      }
      /*argsList.add("-destdir");
      try
      {
         argsList.add(targetDirectory.getCanonicalPath() + "/classes-retro");
      }
      catch (Exception e)
      {
         this.getLog().error(e);
      }*/
      argsList.add("-cp");
      StringBuilder classpath = new StringBuilder();
      String pathSeparator = System.getProperty("path.separator");
      for (Object element : classpathElements)
      {
         classpath.append(element);
         classpath.append(pathSeparator);
      }

      for (Object artifact : pluginArtifacts)
      {
         try
         {
            File artifactFile = ((Artifact) artifact).getFile();
            if (artifactFile != null)
            {
               classpath.append(artifactFile.getCanonicalPath());
               classpath.append(pathSeparator);
            }
         }
         catch (IOException ioe)
         {
            this.getLog().warn("Could not get filename");
         }
      }
      
      argsList.add(classpath.toString());

      try
      {
         argsList.add(targetDirectory.getCanonicalPath() + 
               System.getProperty("file.separator") + "classes-retro");
      }
      catch (IOException ioe)
      {
         this.getLog().error(ioe.toString());
      }

      String[] args = new String[argsList.size()];
      for (int i = 0; i < args.length; ++i)
      {
         args[i] = argsList.get(i);
      }

      Checker checker = new Checker();
      try
      {
         checker.check(args);
      }
      catch (Exception e)
      {
         this.getLog().error(e);
      }

   }
}
