/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.retro;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.jboss.ant.tasks.retrocheck.Checker;

public class RetroCheckMojo
extends AbstractMojo {
    protected MavenProject project;
    protected MavenProjectHelper projectHelper;
    protected List pluginComponents;
    private List pluginArtifacts;
    private List classpathElements;
    private File targetClassesDirectory;
    private File targetDirectory;
    private boolean verbose = false;
    private boolean suppress = true;

    public void execute() {
        this.getLog().info((CharSequence)"[retro-check] Checking classes for jdk14");
        if (!this.project.getArtifact().getType().equalsIgnoreCase("jar")) {
            this.getLog().info((CharSequence)("[retro-check] Project " + this.project.getName() + " is not" + " a jar project.  No retro compile needed."));
            return;
        }
        ArrayList<String> argsList = new ArrayList<String>();
        if (this.verbose) {
            argsList.add("-verbose");
        }
        if (this.suppress) {
            argsList.add("-suppress");
        }
        argsList.add("-cp");
        StringBuilder classpath = new StringBuilder();
        String pathSeparator = System.getProperty("path.separator");
        for (Object element : this.classpathElements) {
            classpath.append(element);
            classpath.append(pathSeparator);
        }
        for (Object artifact : this.pluginArtifacts) {
            try {
                File artifactFile = ((Artifact)artifact).getFile();
                if (artifactFile == null) continue;
                classpath.append(artifactFile.getCanonicalPath());
                classpath.append(pathSeparator);
            }
            catch (IOException ioe) {
                this.getLog().warn((CharSequence)"Could not get filename");
            }
        }
        argsList.add(classpath.toString());
        try {
            argsList.add(this.targetDirectory.getCanonicalPath() + System.getProperty("file.separator") + "classes-retro");
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)ioe.toString());
        }
        String[] args = new String[argsList.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (String)argsList.get(i);
        }
        Checker checker = new Checker();
        try {
            checker.check(args);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }
}

