/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.retro;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.jboss.ant.tasks.retro.Weaver;

public class RetroMojo
extends AbstractMojo {
    protected MavenProject project;
    protected MavenProjectHelper projectHelper;
    protected List pluginComponents;
    private List pluginArtifacts;
    private List classpathElements;
    private File targetClassesDirectory;
    private File targetDirectory;
    private boolean verbose = false;
    private boolean suppress = true;
    private ArrayList<JarFileEntry> fileEntries = new ArrayList();

    public void execute() {
        this.getLog().info((CharSequence)"[retro] Compiling classes for jdk14");
        if (!this.project.getArtifact().getType().equalsIgnoreCase("jar")) {
            this.getLog().info((CharSequence)("[retro] Project " + this.project.getName() + " is not" + " a jar project.  No retro compile needed."));
            return;
        }
        ArrayList<String> argsList = new ArrayList<String>();
        if (this.verbose) {
            argsList.add("-verbose");
        }
        if (this.suppress) {
            argsList.add("-suppress");
        }
        argsList.add("-destdir");
        String fileSep = System.getProperty("file.separator");
        try {
            argsList.add(this.targetDirectory.getCanonicalPath() + fileSep + "classes-retro/");
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
        argsList.add("-cp");
        StringBuilder classpath = new StringBuilder();
        String pathSeparator = System.getProperty("path.separator");
        for (Object element : this.classpathElements) {
            classpath.append(element);
            classpath.append(pathSeparator);
        }
        for (Object artifact : this.pluginArtifacts) {
            try {
                File artifactFile = ((Artifact)artifact).getFile();
                if (artifactFile == null) continue;
                classpath.append(artifactFile.getCanonicalPath());
                classpath.append(pathSeparator);
            }
            catch (IOException ioe) {
                this.getLog().warn((CharSequence)"Could not get filename");
            }
        }
        argsList.add(classpath.toString());
        try {
            argsList.add(this.targetClassesDirectory.getCanonicalPath());
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)ioe.toString());
        }
        String[] args = new String[argsList.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (String)argsList.get(i);
        }
        Weaver weaver = new Weaver();
        try {
            weaver.weave(args);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
        File retroJarFile = new File(this.targetDirectory.getAbsolutePath() + "/" + this.project.getArtifactId() + "-jdk14.jar");
        File retroClassesDir = new File(this.targetDirectory.getAbsolutePath() + "/classes-retro");
        if (retroClassesDir.exists()) {
            this.createJarEntries(retroClassesDir);
            this.createRetroJarFile(retroJarFile);
            this.projectHelper.attachArtifact(this.project, retroJarFile, "jdk14");
        }
    }

    private void createJarEntries(File retroClassesDir) {
        try {
            this.getLog().info((CharSequence)("DEBUG: " + retroClassesDir.getAbsolutePath()));
            Collection retroClasses = FileUtils.listFiles((File)retroClassesDir, null, (boolean)true);
            for (Object classFile : retroClasses) {
                String relativePath = classFile.toString().replace(retroClassesDir.getAbsolutePath() + "/", "");
                byte[] content = FileUtils.readFileToByteArray((File)((File)classFile));
                this.fileEntries.add(new JarFileEntry(relativePath, content));
            }
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)("error reading class file: " + ioe));
        }
    }

    private void createRetroJarFile(File retroJarFile) {
        try {
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.putValue("Manifest-Version", "1.0");
            attributes.putValue("Created-By", System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
            JarOutputStream stream = new JarOutputStream((OutputStream)new FileOutputStream(retroJarFile), manifest);
            stream.setLevel(9);
            for (JarFileEntry fileEntry : this.fileEntries) {
                JarEntry jarEntry = new JarEntry(fileEntry.getName());
                stream.putNextEntry(jarEntry);
                stream.write(fileEntry.getContent());
            }
            stream.close();
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)("Unable to write retro jar: " + ioe));
        }
    }

    private static class JarFileEntry {
        private byte[] content;
        private String name;

        public JarFileEntry(String name, byte[] content) {
            this.name = name;
            this.content = content;
        }

        public byte[] getContent() {
            return this.content;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

