/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

public class BeanELResolver
extends ELResolver {
    private final boolean readOnly;
    private final ConcurrentCache<String, BeanProperties> cache = new ConcurrentCache(1000);

    public BeanELResolver() {
        this.readOnly = false;
    }

    public BeanELResolver(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(true);
        Method m = this.property(context, base, property).read(context);
        try {
            return m.invoke(base, (Object[])null);
        }
        catch (IllegalAccessException e) {
            throw new ELException(e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(BeanELResolver.message(context, "propertyReadError", new Object[]{base.getClass().getName(), property.toString()}), e.getCause());
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        context.setPropertyResolved(true);
        return this.property(context, base, property).getPropertyType();
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return;
        }
        context.setPropertyResolved(true);
        if (this.readOnly) {
            throw new PropertyNotWritableException(BeanELResolver.message(context, "resolverNotWriteable", new Object[]{base.getClass().getName()}));
        }
        Method m = this.property(context, base, property).write(context);
        try {
            m.invoke(base, value);
        }
        catch (IllegalAccessException e) {
            throw new ELException(e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(BeanELResolver.message(context, "propertyWriteError", new Object[]{base.getClass().getName(), property.toString()}), e.getCause());
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return false;
        }
        context.setPropertyResolved(true);
        return this.readOnly || this.property(context, base, property).isReadOnly();
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            return null;
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(base.getClass());
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                pds[i].setValue("resolvableAtDesignTime", Boolean.TRUE);
                pds[i].setValue("type", pds[i].getPropertyType());
            }
            return Arrays.asList((FeatureDescriptor[])pds).iterator();
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null) {
            return Object.class;
        }
        return null;
    }

    private final BeanProperty property(ELContext ctx, Object base, Object property) {
        Class<?> type = base.getClass();
        String prop = property.toString();
        BeanProperties props = this.cache.get(type.getName());
        if (props == null || type != props.getType()) {
            props = new BeanProperties(type);
            this.cache.put(type.getName(), props);
        }
        return props.get(ctx, prop);
    }

    private static final Method getMethod(Class type, Method m) {
        if (m == null || Modifier.isPublic(type.getModifiers())) {
            return m;
        }
        Class<?>[] inf = type.getInterfaces();
        Method mp = null;
        for (int i = 0; i < inf.length; ++i) {
            try {
                mp = inf[i].getMethod(m.getName(), m.getParameterTypes());
                mp = BeanELResolver.getMethod(mp.getDeclaringClass(), mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        Class sup = type.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m.getName(), m.getParameterTypes());
                mp = BeanELResolver.getMethod(mp.getDeclaringClass(), mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }

    private static final class ConcurrentCache<K, V> {
        private final int size;
        private final Map<K, V> eden;
        private final Map<K, V> longterm;

        public ConcurrentCache(int size) {
            this.size = size;
            this.eden = new ConcurrentHashMap(size);
            this.longterm = new WeakHashMap(size);
        }

        public V get(K key) {
            V value = this.eden.get(key);
            if (value == null && (value = this.longterm.get(key)) != null) {
                this.eden.put(key, value);
            }
            return value;
        }

        public void put(K key, V value) {
            if (this.eden.size() >= this.size) {
                this.longterm.putAll(this.eden);
                this.eden.clear();
            }
            this.eden.put(key, value);
        }
    }

    protected static final class BeanProperty {
        private final Class type;
        private final Class owner;
        private final PropertyDescriptor descriptor;
        private Method read;
        private Method write;

        public BeanProperty(Class<?> owner, PropertyDescriptor descriptor) {
            this.owner = owner;
            this.descriptor = descriptor;
            this.type = descriptor.getPropertyType();
        }

        public Class getPropertyType() {
            return this.type;
        }

        public boolean isReadOnly() {
            return this.write == null && null == (this.write = BeanELResolver.getMethod(this.owner, this.descriptor.getWriteMethod()));
        }

        public Method getWriteMethod() {
            return this.write(null);
        }

        public Method getReadMethod() {
            return this.read(null);
        }

        private Method write(ELContext ctx) {
            if (this.write == null) {
                this.write = BeanELResolver.getMethod(this.owner, this.descriptor.getWriteMethod());
                if (this.write == null) {
                    throw new PropertyNotFoundException(ELResolver.message(ctx, "propertyNotWritable", new Object[]{this.type.getName(), this.descriptor.getName()}));
                }
            }
            return this.write;
        }

        private Method read(ELContext ctx) {
            if (this.read == null) {
                this.read = BeanELResolver.getMethod(this.owner, this.descriptor.getReadMethod());
                if (this.read == null) {
                    throw new PropertyNotFoundException(ELResolver.message(ctx, "propertyNotReadable", new Object[]{this.type.getName(), this.descriptor.getName()}));
                }
            }
            return this.read;
        }
    }

    protected static final class BeanProperties {
        private final Map<String, BeanProperty> properties;
        private final Class<?> type;

        public BeanProperties(Class<?> type) throws ELException {
            this.type = type;
            this.properties = new HashMap<String, BeanProperty>();
            try {
                BeanInfo info = Introspector.getBeanInfo(this.type);
                PropertyDescriptor[] pds = info.getPropertyDescriptors();
                for (int i = 0; i < pds.length; ++i) {
                    this.properties.put(pds[i].getName(), new BeanProperty(type, pds[i]));
                }
            }
            catch (IntrospectionException ie) {
                throw new ELException(ie);
            }
        }

        private BeanProperty get(ELContext ctx, String name) {
            BeanProperty property = this.properties.get(name);
            if (property == null) {
                throw new PropertyNotFoundException(ELResolver.message(ctx, "propertyNotFound", new Object[]{this.type.getName(), name}));
            }
            return property;
        }

        public BeanProperty getBeanProperty(String name) {
            return this.get(null, name);
        }

        private Class<?> getType() {
            return this.type;
        }
    }
}

