/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.StringManager;
import org.jboss.web.comet.CometEvent;

public class CometEventImpl
implements CometEvent {
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    protected Request request = null;
    protected Response response = null;
    protected CometEvent.EventType eventType = CometEvent.EventType.BEGIN;

    public CometEventImpl(Request request, Response response) {
        this.request = request;
        this.response = response;
    }

    public void clear() {
        this.request = null;
        this.response = null;
    }

    public void setType(CometEvent.EventType eventType) {
        this.eventType = eventType;
    }

    public void close() throws IOException {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("cometEvent.nullRequest"));
        }
        this.request.setComet(false);
        this.response.finishResponse();
    }

    public CometEvent.EventType getType() {
        return this.eventType;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request.getRequest();
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.response.getResponse();
    }

    public void setTimeout(int timeout) {
        this.request.setTimeout(timeout);
    }

    public boolean ready() {
        return this.response.isWriteable();
    }

    public void resume() {
        this.request.resume();
    }

    public void suspend() {
        this.request.suspend();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("CometEventImpl[");
        buf.append(super.toString());
        buf.append("] Event:");
        buf.append((Object)this.getType());
        return buf.toString();
    }
}

