/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager.host;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.manager.host.HostManagerServlet;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ServerInfo;

public final class HTMLHostManagerServlet
extends HostManagerServlet {
    private static final String HOSTS_HEADER_SECTION = "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"5\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td class=\"header-left\"><small>{0}</small></td>\n <td class=\"header-center\"><small>{1}</small></td>\n <td class=\"header-center\"><small>{2}</small></td>\n</tr>\n";
    private static final String HOSTS_ROW_DETAILS_SECTION = "<tr>\n <td class=\"row-left\"><small><a href=\"http://{0}\">{0}</a></small></td>\n <td class=\"row-center\"><small>{1}</small></td>\n";
    private static final String MANAGER_HOST_ROW_BUTTON_SECTION = " <td class=\"row-left\">\n  <small>\n  &nbsp;{1}&nbsp;\n  &nbsp;{3}&nbsp;\n  &nbsp;{5}&nbsp;\n  </small>\n </td>\n</tr>\n";
    private static final String HOSTS_ROW_BUTTON_SECTION = " <td class=\"row-left\" NOWRAP>\n  <small>\n  &nbsp;<a href=\"{0}\" onclick=\"return(confirm(''{1} {6}\\n\\nAre you sure?''))\">{1}</a>&nbsp;\n  &nbsp;<a href=\"{2}\" onclick=\"return(confirm(''{3} {6}\\n\\nAre you sure?''))\">{3}</a>&nbsp;\n  &nbsp;<a href=\"{4}\" onclick=\"return(confirm(''{5} {6}\\n\\nAre you sure?''))\">{5}</a>&nbsp;\n  </small>\n </td>\n</tr>\n";
    private static final String ADD_SECTION_START = "</table>\n<br>\n<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"2\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td colspan=\"2\" class=\"header-left\"><small>{1}</small></td>\n</tr>\n<tr>\n <td colspan=\"2\">\n<form method=\"get\" action=\"{2}\">\n<table cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td class=\"row-right\">\n  <small>{3}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"name\" size=\"20\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  <small>{4}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"aliases\" size=\"64\">\n </td>\n</tr>\n<tr>\n <td class=\"row-right\">\n  <small>{5}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"text\" name=\"appBase\" size=\"64\">\n </td>\n</tr>\n";
    private static final String ADD_SECTION_BOOLEAN = "<tr>\n <td class=\"row-right\">\n  <small>{0}</small>\n </td>\n <td class=\"row-left\">\n  <input type=\"checkbox\" name=\"{1}\" {2}>\n </td>\n</tr>\n";
    private static final String ADD_SECTION_END = "<tr>\n <td class=\"row-right\">\n  &nbsp;\n </td>\n <td class=\"row-left\">\n  <input type=\"submit\" value=\"{0}\">\n </td>\n</tr>\n</table>\n</form>\n</td>\n</tr>\n</table>\n<br>\n\n";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String command = request.getPathInfo();
        String name = request.getParameter("name");
        response.setContentType("text/html; charset=utf-8");
        String message = "";
        if (command != null) {
            if (command.equals("/add")) {
                message = this.add(request, name);
            } else if (command.equals("/remove")) {
                message = this.remove(name);
            } else if (!command.equals("/list")) {
                message = command.equals("/start") ? this.start(name) : (command.equals("/stop") ? this.stop(name) : sm.getString("hostManagerServlet.unknownCommand", command));
            }
        }
        this.list(request, response, message);
    }

    protected String add(HttpServletRequest request, String name) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.add(request, printWriter, name, true);
        return stringWriter.toString();
    }

    protected String remove(String name) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.remove(printWriter, name);
        return stringWriter.toString();
    }

    protected String start(String name) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.start(printWriter, name);
        return stringWriter.toString();
    }

    protected String stop(String name) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.stop(printWriter, name);
        return stringWriter.toString();
    }

    public void list(HttpServletRequest request, HttpServletResponse response, String message) throws IOException {
        PrintWriter writer = response.getWriter();
        Object[] args = new Object[]{request.getContextPath()};
        writer.print(MessageFormat.format("<html>\n<head>\n<link href=\"{0}/jbossweb.css\" rel=\"stylesheet\" type=\"text/css\" />\n", args));
        args = new Object[]{request.getContextPath(), sm.getString("htmlHostManagerServlet.title")};
        writer.print(MessageFormat.format("<title>{1}</title>\n</head>\n\n<body>\n\n<div class=\"wrapper\">\n  <div class=\"header\">\n    <div class=\"floatleft\"><a href=\"list\"><img src=\"{0}/images/hdr_hdrtitle.gif\" border=\"0\"></a></div>\n    <div class=\"floatright\"><a href=\"http://www.jboss.com/\"><img src=\"{0}/images/hdr_jbosslogo.gif\" alt=\"JBoss, a division of Red Hat\" border=\"0\"></a><a href=\"http://www.jboss.org\"><img src=\"{0}/images/hdr_jbossorglogo.gif\" alt=\"JBoss.org - Community driven.\" border=\"0\" /></a></div>\n  </div>\n    <div class=\"container\">\n\n", args));
        args = new Object[]{sm.getString("htmlHostManagerServlet.manager"), response.encodeURL(request.getContextPath() + "/html/list"), sm.getString("htmlHostManagerServlet.list"), response.encodeURL(request.getContextPath() + "/" + sm.getString("htmlHostManagerServlet.helpHtmlManagerFile")), sm.getString("htmlHostManagerServlet.helpHtmlManager"), response.encodeURL(request.getContextPath() + "/" + sm.getString("htmlHostManagerServlet.helpManagerFile")), sm.getString("htmlHostManagerServlet.helpManager"), response.encodeURL("/manager/status"), sm.getString("statusServlet.title")};
        writer.print(MessageFormat.format("<div class=\"leftcol\"><dl>\n  <dt>Manager</dt>    <dd><a href=\"{1}\">{2}</a></dd>    <dd><a href=\"{3}\">{4}</a></dd>    <dd><a href=\"{5}\">{6}</a></dd>    <dd><a href=\"{7}\">{8}</a></dd></dl></div>\n<div class=\"maincol\">\n", args));
        args = new Object[3];
        args[0] = sm.getString("htmlHostManagerServlet.messageLabel");
        args[1] = message == null || message.length() == 0 ? "OK" : RequestUtil.filter(message);
        writer.print(MessageFormat.format("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n <tr>\n  <td class=\"row-left\" width=\"10%\"><small><strong>{0}</strong></small>&nbsp;</td>\n  <td class=\"row-left\"><pre>{1}</pre></td>\n </tr>\n</table>\n<br>\n\n", args));
        args = new Object[]{sm.getString("htmlHostManagerServlet.hostName"), sm.getString("htmlHostManagerServlet.hostAliases"), sm.getString("htmlHostManagerServlet.hostTasks")};
        writer.print(MessageFormat.format(HOSTS_HEADER_SECTION, args));
        Container[] children = this.engine.findChildren();
        String[] hostNames = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            hostNames[i] = children[i].getName();
        }
        TreeMap<String, String> sortedHostNamesMap = new TreeMap<String, String>();
        for (int i = 0; i < hostNames.length; ++i) {
            String displayPath = hostNames[i];
            sortedHostNamesMap.put(displayPath, hostNames[i]);
        }
        String hostsStart = sm.getString("htmlHostManagerServlet.hostsStart");
        String hostsStop = sm.getString("htmlHostManagerServlet.hostsStop");
        String hostsRemove = sm.getString("htmlHostManagerServlet.hostsRemove");
        for (Map.Entry entry : sortedHostNamesMap.entrySet()) {
            String hostName = (String)entry.getKey();
            Host host = (Host)this.engine.findChild(hostName);
            if (host == null) continue;
            args = new Object[2];
            args[0] = RequestUtil.filter(hostName);
            String[] aliases = host.findAliases();
            StringBuffer buf = new StringBuffer();
            if (aliases.length > 0) {
                buf.append(aliases[0]);
                for (int j = 1; j < aliases.length; ++j) {
                    buf.append(", ").append(aliases[j]);
                }
            }
            if (buf.length() == 0) {
                buf.append("&nbsp;");
                args[1] = buf.toString();
            } else {
                args[1] = RequestUtil.filter(buf.toString());
            }
            writer.print(MessageFormat.format(HOSTS_ROW_DETAILS_SECTION, args));
            args = new Object[]{response.encodeURL(request.getContextPath() + "/html/start?name=" + hostName), hostsStart, response.encodeURL(request.getContextPath() + "/html/stop?name=" + hostName), hostsStop, response.encodeURL(request.getContextPath() + "/html/remove?name=" + hostName), hostsRemove, hostName};
            if (host == this.host) {
                writer.print(MessageFormat.format(MANAGER_HOST_ROW_BUTTON_SECTION, args));
                continue;
            }
            writer.print(MessageFormat.format(HOSTS_ROW_BUTTON_SECTION, args));
        }
        args = new Object[]{sm.getString("htmlHostManagerServlet.addTitle"), sm.getString("htmlHostManagerServlet.addHost"), response.encodeURL(request.getContextPath() + "/html/add"), sm.getString("htmlHostManagerServlet.addName"), sm.getString("htmlHostManagerServlet.addAliases"), sm.getString("htmlHostManagerServlet.addAppBase")};
        writer.print(MessageFormat.format(ADD_SECTION_START, args));
        args = new Object[]{sm.getString("htmlHostManagerServlet.addAutoDeploy"), "autoDeploy", "checked"};
        writer.print(MessageFormat.format(ADD_SECTION_BOOLEAN, args));
        args[0] = sm.getString("htmlHostManagerServlet.addDeployOnStartup");
        args[1] = "deployOnStartup";
        args[2] = "checked";
        writer.print(MessageFormat.format(ADD_SECTION_BOOLEAN, args));
        args[0] = sm.getString("htmlHostManagerServlet.addDeployXML");
        args[1] = "deployXML";
        args[2] = "checked";
        writer.print(MessageFormat.format(ADD_SECTION_BOOLEAN, args));
        args[0] = sm.getString("htmlHostManagerServlet.addUnpackWARs");
        args[1] = "unpackWARs";
        args[2] = "checked";
        writer.print(MessageFormat.format(ADD_SECTION_BOOLEAN, args));
        args[0] = sm.getString("htmlHostManagerServlet.addXmlNamespaceAware");
        args[1] = "xmlNamespaceAware";
        args[2] = "";
        writer.print(MessageFormat.format(ADD_SECTION_BOOLEAN, args));
        args[0] = sm.getString("htmlHostManagerServlet.addXmlValidation");
        args[1] = "xmlValidation";
        args[2] = "";
        writer.print(MessageFormat.format(ADD_SECTION_BOOLEAN, args));
        args[0] = sm.getString("htmlHostManagerServlet.addManager");
        args[1] = "manager";
        args[2] = "checked";
        writer.print(MessageFormat.format(ADD_SECTION_BOOLEAN, args));
        args = new Object[]{sm.getString("htmlHostManagerServlet.addButton")};
        writer.print(MessageFormat.format(ADD_SECTION_END, args));
        args = new Object[]{sm.getString("htmlHostManagerServlet.serverTitle"), sm.getString("htmlHostManagerServlet.serverVersion"), sm.getString("htmlHostManagerServlet.serverJVMVersion"), sm.getString("htmlHostManagerServlet.serverJVMVendor"), sm.getString("htmlHostManagerServlet.serverOSName"), sm.getString("htmlHostManagerServlet.serverOSVersion"), sm.getString("htmlHostManagerServlet.serverOSArch")};
        writer.print(MessageFormat.format("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n<tr>\n <td colspan=\"6\" class=\"title\">{0}</td>\n</tr>\n<tr>\n <td class=\"header-center\"><small>{1}</small></td>\n <td class=\"header-center\"><small>{2}</small></td>\n <td class=\"header-center\"><small>{3}</small></td>\n <td class=\"header-center\"><small>{4}</small></td>\n <td class=\"header-center\"><small>{5}</small></td>\n <td class=\"header-center\"><small>{6}</small></td>\n</tr>\n", args));
        args = new Object[]{ServerInfo.getServerInfo(), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")};
        writer.print(MessageFormat.format("<tr>\n <td class=\"row-center\"><small>{0}</small></td>\n <td class=\"row-center\"><small>{1}</small></td>\n <td class=\"row-center\"><small>{2}</small></td>\n <td class=\"row-center\"><small>{3}</small></td>\n <td class=\"row-center\"><small>{4}</small></td>\n <td class=\"row-center\"><small>{5}</small></td>\n</tr>\n</table>\n<br>\n\n", args));
        writer.print("  </div>\n  </div>\n  <div class=\"footer\">&copy; 2008 Red Hat Middleware, LLC. All Rights Reserved. </div>\n</div></body></html>");
        writer.flush();
        writer.close();
    }
}

