/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.jboss.logging.Logger;

public class C2BConverter {
    protected static Logger log = Logger.getLogger(C2BConverter.class);
    protected CharsetEncoder encoder = null;
    protected ByteBuffer bb = null;
    protected CharBuffer cb = null;

    public C2BConverter(String charset) {
        this.encoder = Charset.forName(charset).newEncoder();
    }

    public void recycle() {
        this.encoder.reset();
    }

    public void convert(CharChunk cc, ByteChunk bc) throws IOException {
        if (this.bb == null || this.bb.array() != bc.getBuffer()) {
            this.bb = ByteBuffer.wrap(bc.getBuffer(), bc.getEnd(), bc.getBuffer().length - bc.getEnd());
        } else {
            this.bb.position(bc.getEnd());
            this.bb.limit(bc.getBuffer().length);
        }
        if (this.cb == null || this.cb.array() != cc.getBuffer()) {
            this.cb = CharBuffer.wrap(cc.getBuffer(), cc.getStart(), cc.getLength());
        } else {
            this.cb.position(cc.getStart());
            this.cb.limit(cc.getEnd());
        }
        CoderResult result = this.encoder.encode(this.cb, this.bb, false);
        if (result.isError() || result.isMalformed()) {
            result.throwException();
        } else if (result.isOverflow()) {
            bc.setEnd(this.bb.position());
            cc.setOffset(this.cb.position());
        } else if (result.isUnderflow()) {
            bc.setEnd(this.bb.position());
            cc.setOffset(this.cb.position());
        }
    }
}

