/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.cluster;

import java.net.InetAddress;
import java.util.HashMap;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.logging.Logger;

public class ClusterListener
implements LifecycleListener,
ContainerListener {
    private static Logger log = Logger.getLogger(ClusterListener.class);
    protected StringManager sm = StringManager.getManager("org.jboss.web.cluster");
    protected int proxyPort = 8000;
    protected InetAddress proxyAddress = null;

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public InetAddress getProxyAddress() {
        return this.proxyAddress;
    }

    public void setAddress(InetAddress proxyAddress) {
        this.proxyAddress = proxyAddress;
    }

    public void containerEvent(ContainerEvent event) {
        Container container = event.getContainer();
        Object child = event.getData();
        String type = event.getType();
        if (type.equals("addChild")) {
            if (container instanceof Host) {
                this.addContext((Context)child);
            } else if (container instanceof Engine) {
                container.addContainerListener(this);
            }
        } else if (type.equals("removeChild")) {
            if (container instanceof Host) {
                this.removeContext((Context)child);
            } else if (container instanceof Engine) {
                container.removeContainerListener(this);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source = event.getLifecycle();
        if ("start".equals(event.getType())) {
            if (source instanceof Context) {
                this.startContext((Context)((Object)source));
                return;
            } else {
                if (!(source instanceof Server)) return;
                Service[] services = ((Server)((Object)source)).findServices();
                for (int i = 0; i < services.length; ++i) {
                    services[i].getContainer().addContainerListener(this);
                    ((Lifecycle)((Object)services[i].getContainer())).addLifecycleListener(this);
                    this.config((Engine)services[i].getContainer());
                    Container[] children = services[i].getContainer().findChildren();
                    for (int j = 0; j < children.length; ++j) {
                        children[j].addContainerListener(this);
                        Container[] children2 = children[j].findChildren();
                        for (int k = 0; k < children2.length; ++k) {
                            this.addContext((Context)children2[k]);
                        }
                    }
                }
            }
            return;
        } else if ("stop".equals(event.getType())) {
            if (source instanceof Context) {
                this.stopContext((Context)((Object)source));
                return;
            } else {
                if (!(source instanceof Server)) return;
                Service[] services = ((Server)((Object)source)).findServices();
                for (int i = 0; i < services.length; ++i) {
                    services[i].getContainer().removeContainerListener(this);
                    ((Lifecycle)((Object)services[i].getContainer())).removeLifecycleListener(this);
                    this.removeAll((Engine)services[i].getContainer());
                    Container[] children = services[i].getContainer().findChildren();
                    for (int j = 0; j < children.length; ++j) {
                        children[j].removeContainerListener(this);
                        Container[] children2 = children[j].findChildren();
                        for (int k = 0; k < children2.length; ++k) {
                            this.removeContext((Context)children2[k]);
                        }
                    }
                }
            }
            return;
        } else {
            if (!"periodic".equals(event.getType()) || !(source instanceof Engine)) return;
            this.status((Engine)((Object)source));
        }
    }

    protected void config(Engine engine) {
        System.out.println("Config: " + engine.getName());
        Connector connector = this.findProxyConnector(engine.getService().findConnectors());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", engine.getJvmRoute());
        boolean reverseConnection = Boolean.TRUE.equals(IntrospectionUtils.getProperty(connector.getProtocolHandler(), "reverseConnection"));
        boolean ssl = Boolean.TRUE.equals(IntrospectionUtils.getProperty(connector.getProtocolHandler(), "SSLEnabled"));
        boolean ajp = ((String)IntrospectionUtils.getProperty(connector.getProtocolHandler(), "name")).startsWith("ajp-");
        if (reverseConnection) {
            parameters.put("Reversed", "true");
        }
        parameters.put("Host", this.getAddress(connector));
        parameters.put("Port", "" + connector.getPort());
        if (ajp) {
            parameters.put("Type", "ajp");
        } else if (ssl) {
            parameters.put("Type", "https");
        } else {
            parameters.put("Type", "http");
        }
    }

    protected void removeAll(Engine engine) {
        System.out.println("Stop: " + engine.getName());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", engine.getJvmRoute());
    }

    protected void status(Engine engine) {
        System.out.println("Status: " + engine.getName());
        Connector connector = this.findProxyConnector(engine.getService().findConnectors());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", engine.getJvmRoute());
    }

    protected void addContext(Context context) {
        System.out.println("Deploy context: " + context.getPath() + " to Host: " + context.getParent().getName() + " State: " + ((StandardContext)context).getState());
        ((Lifecycle)((Object)context)).addLifecycleListener(this);
        boolean started = ((StandardContext)context).getState() == 1;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", this.getJvmRoute(context));
        parameters.put("context", "".equals(context.getPath()) ? "/" : context.getPath());
    }

    protected void removeContext(Context context) {
        System.out.println("Undeploy context: " + context.getPath() + " to Host: " + context.getParent().getName() + " State: " + ((StandardContext)context).getState());
        ((Lifecycle)((Object)context)).removeLifecycleListener(this);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", this.getJvmRoute(context));
        parameters.put("context", "".equals(context.getPath()) ? "/" : context.getPath());
    }

    protected void startContext(Context context) {
        Container parent = context.getParent();
        System.out.println("Start context: " + context.getPath() + " to Host: " + parent.getName());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", this.getJvmRoute(context));
        parameters.put("context", "".equals(context.getPath()) ? "/" : context.getPath());
    }

    protected void stopContext(Context context) {
        Container parent = context.getParent();
        System.out.println("Stop context: " + context.getPath() + " to Host: " + parent.getName());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", this.getJvmRoute(context));
        parameters.put("context", "".equals(context.getPath()) ? "/" : context.getPath());
    }

    protected String getJvmRoute(Context context) {
        return ((Engine)context.getParent().getParent()).getJvmRoute();
    }

    protected Connector findProxyConnector(Connector[] connectors) {
        int pos = 0;
        int maxThreads = 0;
        for (int i = 0; i < connectors.length; ++i) {
            if (connectors[i].getProtocol().startsWith("AJP")) {
                return connectors[i];
            }
            if (Boolean.TRUE.equals(IntrospectionUtils.getProperty(connectors[i].getProtocolHandler(), "reverseConnection"))) {
                return connectors[i];
            }
            Integer mt = (Integer)IntrospectionUtils.getProperty(connectors[i].getProtocolHandler(), "maxThreads");
            if (mt <= maxThreads) continue;
            maxThreads = mt;
            pos = i;
        }
        return connectors[pos];
    }

    protected String getAddress(Connector connector) {
        InetAddress inetAddress = (InetAddress)IntrospectionUtils.getProperty(connector.getProtocolHandler(), "address");
        if (inetAddress == null) {
            return null;
        }
        return inetAddress.toString();
    }
}

