/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.cluster;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.UEncoder;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterListener
implements LifecycleListener,
ContainerListener {
    protected static Logger log = Logger.getLogger(ClusterListener.class);
    protected StringManager sm = StringManager.getManager("org.jboss.web.cluster");
    protected UEncoder encoder = new UEncoder();
    protected State state = State.OK;
    protected int proxyPort = 8000;
    protected InetAddress proxyAddress = null;
    protected String proxyURL = "/";
    protected int socketTimeout = 5000;

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public InetAddress getProxyAddress() {
        return this.proxyAddress;
    }

    public void setAddress(InetAddress proxyAddress) {
        this.proxyAddress = proxyAddress;
    }

    public String getProxyURL() {
        return this.proxyURL;
    }

    public void setProxyURL(String proxyURL) {
        this.proxyURL = proxyURL;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @Override
    public void containerEvent(ContainerEvent event) {
        Container container = event.getContainer();
        Object child = event.getData();
        String type = event.getType();
        if (type.equals("addChild")) {
            if (container instanceof Host) {
                this.addContext((Context)child);
            } else if (container instanceof Engine) {
                container.addContainerListener(this);
            }
        } else if (type.equals("removeChild")) {
            if (container instanceof Host) {
                this.removeContext((Context)child);
            } else if (container instanceof Engine) {
                container.removeContainerListener(this);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source = event.getLifecycle();
        if ("start".equals(event.getType())) {
            if (!(source instanceof Context)) return;
            this.startContext((Context)((Object)source));
            return;
        } else if ("after_start".equals(event.getType())) {
            if (!(source instanceof Server)) return;
            this.startServer((Server)((Object)source));
            return;
        } else if ("stop".equals(event.getType())) {
            if (source instanceof Context) {
                this.stopContext((Context)((Object)source));
                return;
            } else {
                if (!(source instanceof Server)) return;
                this.stopServer((Server)((Object)source));
            }
            return;
        } else {
            if (!"periodic".equals(event.getType()) || !(source instanceof Engine)) return;
            this.status((Engine)((Object)source));
        }
    }

    public String getProxyConfiguration() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        return this.sendRequest("DUMP", true, parameters);
    }

    public void reset() {
        if (this.state == State.DOWN) {
            this.state = State.ERROR;
        }
    }

    protected void startServer(Server server) {
        Service[] services = server.findServices();
        for (int i = 0; i < services.length; ++i) {
            services[i].getContainer().addContainerListener(this);
            ((Lifecycle)((Object)services[i].getContainer())).addLifecycleListener(this);
            this.config((Engine)services[i].getContainer());
            Container[] children = services[i].getContainer().findChildren();
            for (int j = 0; j < children.length; ++j) {
                children[j].addContainerListener(this);
                Container[] children2 = children[j].findChildren();
                for (int k = 0; k < children2.length; ++k) {
                    this.addContext((Context)children2[k]);
                }
            }
        }
    }

    protected void stopServer(Server server) {
        Service[] services = server.findServices();
        for (int i = 0; i < services.length; ++i) {
            services[i].getContainer().removeContainerListener(this);
            ((Lifecycle)((Object)services[i].getContainer())).removeLifecycleListener(this);
            this.removeAll((Engine)services[i].getContainer());
            Container[] children = services[i].getContainer().findChildren();
            for (int j = 0; j < children.length; ++j) {
                children[j].removeContainerListener(this);
                Container[] children2 = children[j].findChildren();
                for (int k = 0; k < children2.length; ++k) {
                    this.removeContext((Context)children2[k]);
                }
            }
        }
    }

    protected void config(Engine engine) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Config: " + engine.getName()));
        }
        Connector connector = this.findProxyConnector(engine.getService().findConnectors());
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (engine.getJvmRoute() == null) {
            throw new IllegalStateException("JVMRoute must be set");
        }
        parameters.put("JVMRoute", engine.getJvmRoute());
        boolean reverseConnection = Boolean.TRUE.equals(IntrospectionUtils.getProperty(connector.getProtocolHandler(), "reverseConnection"));
        boolean ssl = Boolean.TRUE.equals(IntrospectionUtils.getProperty(connector.getProtocolHandler(), "SSLEnabled"));
        boolean ajp = ((String)IntrospectionUtils.getProperty(connector.getProtocolHandler(), "name")).startsWith("ajp-");
        if (reverseConnection) {
            parameters.put("Reversed", "true");
        }
        parameters.put("Host", this.getAddress(connector));
        parameters.put("Port", "" + connector.getPort());
        if (ajp) {
            parameters.put("Type", "ajp");
        } else if (ssl) {
            parameters.put("Type", "https");
        } else {
            parameters.put("Type", "http");
        }
        this.sendRequest("CONFIG", false, parameters);
    }

    protected void removeAll(Engine engine) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stop: " + engine.getName()));
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", engine.getJvmRoute());
        this.sendRequest("REMOVE-APP", true, parameters);
    }

    protected void status(Engine engine) {
        if (this.state == State.ERROR) {
            this.state = State.OK;
            this.stopServer(ServerFactory.getServer());
            this.startServer(ServerFactory.getServer());
        } else if (this.state == State.OK) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Status: " + engine.getName()));
            }
            Connector connector = this.findProxyConnector(engine.getService().findConnectors());
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("JVMRoute", engine.getJvmRoute());
            parameters.put("Load", "1");
            this.sendRequest("STATUS", false, parameters);
        }
    }

    protected void addContext(Context context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deploy context: " + context.getPath() + " to Host: " + context.getParent().getName() + " State: " + ((StandardContext)context).getState()));
        }
        ((Lifecycle)((Object)context)).addLifecycleListener(this);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", this.getJvmRoute(context));
        parameters.put("Context", "".equals(context.getPath()) ? "/" : context.getPath());
        parameters.put("Alias", this.getHost(context));
        if (context.isStarted()) {
            this.sendRequest("ENABLE-APP", false, parameters);
        }
    }

    protected void removeContext(Context context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Undeploy context: " + context.getPath() + " to Host: " + context.getParent().getName() + " State: " + ((StandardContext)context).getState()));
        }
        ((Lifecycle)((Object)context)).removeLifecycleListener(this);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", this.getJvmRoute(context));
        parameters.put("Context", "".equals(context.getPath()) ? "/" : context.getPath());
        parameters.put("Alias", this.getHost(context));
        this.sendRequest("REMOVE-APP", false, parameters);
    }

    protected void startContext(Context context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start context: " + context.getPath() + " to Host: " + context.getParent().getName()));
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", this.getJvmRoute(context));
        parameters.put("Context", "".equals(context.getPath()) ? "/" : context.getPath());
        parameters.put("Alias", this.getHost(context));
        this.sendRequest("ENABLE-APP", false, parameters);
    }

    protected void stopContext(Context context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stop context: " + context.getPath() + " to Host: " + context.getParent().getName()));
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("JVMRoute", this.getJvmRoute(context));
        parameters.put("Context", "".equals(context.getPath()) ? "/" : context.getPath());
        parameters.put("Alias", this.getHost(context));
        this.sendRequest("STOP-APP", false, parameters);
    }

    protected String getJvmRoute(Context context) {
        return ((Engine)context.getParent().getParent()).getJvmRoute();
    }

    protected String getHost(Context context) {
        StringBuffer result = new StringBuffer();
        Host host = (Host)context.getParent();
        result.append(host.getName());
        String[] aliases = host.findAliases();
        for (int i = 0; i < aliases.length; ++i) {
            result.append(',');
            result.append(aliases[i]);
        }
        return result.toString();
    }

    protected Connector findProxyConnector(Connector[] connectors) {
        int pos = 0;
        int maxThreads = 0;
        for (int i = 0; i < connectors.length; ++i) {
            if (connectors[i].getProtocol().startsWith("AJP")) {
                return connectors[i];
            }
            if (Boolean.TRUE.equals(IntrospectionUtils.getProperty(connectors[i].getProtocolHandler(), "reverseConnection"))) {
                return connectors[i];
            }
            Integer mt = (Integer)IntrospectionUtils.getProperty(connectors[i].getProtocolHandler(), "maxThreads");
            if (mt <= maxThreads) continue;
            maxThreads = mt;
            pos = i;
        }
        return connectors[pos];
    }

    protected String getAddress(Connector connector) {
        InetAddress inetAddress = (InetAddress)IntrospectionUtils.getProperty(connector.getProtocolHandler(), "address");
        if (inetAddress == null) {
            return "127.0.0.1";
        }
        return inetAddress.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String sendRequest(String command, boolean wildcard, HashMap<String, String> parameters) {
        if (this.state != State.OK) {
            return null;
        }
        BufferedReader reader = null;
        BufferedWriter writer = null;
        CharChunk keyCC = null;
        Socket connection = null;
        try {
            Iterator<String> keys = parameters.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next();
                String value = parameters.get(key);
                if (value == null) {
                    throw new IllegalStateException("Value for attribute " + key + " cannot be null");
                }
                keyCC = this.encoder.encodeURL(key, 0, key.length());
                keyCC.append('=');
                if (value != null) {
                    keyCC = this.encoder.encodeURL(value, 0, value.length());
                }
                if (!keys.hasNext()) continue;
                keyCC.append('&');
            }
            connection = this.proxyAddress == null ? new Socket("127.0.0.1", this.proxyPort) : new Socket(this.proxyAddress, this.proxyPort);
            connection.setSoTimeout(this.socketTimeout);
            String requestLine = command + " " + (wildcard ? "*" : this.proxyURL) + " HTTP/1.0";
            int contentLength = keyCC.getLength();
            writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
            writer.write(requestLine);
            writer.write("\r\n");
            writer.write("Content-Length: " + contentLength + "\r\n");
            writer.write("User-Agent: ClusterListener/1.0\r\n");
            writer.write("\r\n");
            writer.write(keyCC.getBuffer(), keyCC.getStart(), keyCC.getLength());
            writer.write("\r\n");
            writer.flush();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String responseStatus = reader.readLine();
            int status = 500;
            String version = "0";
            String message = null;
            String errorType = null;
            try {
                responseStatus = responseStatus.substring(responseStatus.indexOf(32) + 1, responseStatus.indexOf(32, responseStatus.indexOf(32) + 1));
                status = Integer.parseInt(responseStatus);
                String header = reader.readLine();
                while (!"".equals(header)) {
                    int colon = header.indexOf(58);
                    String headerName = header.substring(0, colon).trim();
                    String headerValue = header.substring(colon + 1).trim();
                    if ("version".equalsIgnoreCase(headerName)) {
                        version = headerValue;
                    } else if ("type".equalsIgnoreCase(headerName)) {
                        errorType = headerValue;
                    } else if ("mess".equalsIgnoreCase(headerName)) {
                        message = headerValue;
                    }
                    header = reader.readLine();
                }
            }
            catch (Exception e) {
                log.info((Object)("Error parsing response header: " + command), (Throwable)e);
            }
            if (status == 200) {
                int n;
                StringBuffer result = new StringBuffer();
                char[] buf = new char[512];
                while ((n = reader.read(buf)) > 0) {
                    result.append(buf, 0, n);
                }
                String string = result.toString();
                return string;
            }
            this.state = "SYNTAX".equals(errorType) ? State.DOWN : State.ERROR;
            log.info((Object)("Error sending: " + command + " Version: " + version + " Error type: " + errorType + " Message: " + message));
        }
        catch (IOException e) {
            log.info((Object)("Error sending: " + command), (Throwable)e);
        }
        finally {
            if (keyCC != null) {
                keyCC.recycle();
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        OK,
        ERROR,
        DOWN;

    }
}

