/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.Context;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.http.mapper.MappingData;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;
import org.jboss.logging.Logger;

public class MapperListener
implements NotificationListener {
    private static Logger log = Logger.getLogger(MapperListener.class);
    protected Mapper mapper = null;
    protected MBeanServer mBeanServer = null;
    private StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    private String domain = "*";
    private String engine = "*";

    public MapperListener(Mapper mapper) {
        this.mapper = mapper;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public void init() {
        try {
            this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
            this.registerEngine();
            String onStr = this.domain + ":type=Host,*";
            ObjectName objectName = new ObjectName(onStr);
            Set<ObjectInstance> set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.registerHost(oi.getObjectName());
            }
            onStr = "*:j2eeType=WebModule,*";
            objectName = new ObjectName(onStr);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.registerContext(oi.getObjectName());
            }
            onStr = "*:j2eeType=Servlet,*";
            objectName = new ObjectName(onStr);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.registerWrapper(oi.getObjectName());
            }
            onStr = "JMImplementation:type=MBeanServerDelegate";
            objectName = new ObjectName(onStr);
            this.mBeanServer.addNotificationListener(objectName, this, null, null);
        }
        catch (Exception e) {
            log.warn((Object)"Error registering contexts", (Throwable)e);
        }
    }

    public void destroy() {
        try {
            ObjectName objectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            if (this.mBeanServer != null) {
                this.mBeanServer.removeNotificationListener(objectName, this);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error unregistering MBeanServerDelegate", (Throwable)e);
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            String j2eeType = objectName.getKeyProperty("j2eeType");
            String engineName = null;
            if (j2eeType != null && (j2eeType.equals("WebModule") || j2eeType.equals("Servlet")) && this.mBeanServer.isRegistered(objectName)) {
                try {
                    engineName = (String)this.mBeanServer.getAttribute(objectName, "engineName");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!("*".equals(this.domain) || this.domain.equals(objectName.getDomain()) || this.domain.equals(engineName) || engineName == null)) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handle " + objectName + " type : " + notification.getType()));
            }
            if (notification.getType().equals("JMX.mbean.registered")) {
                String type = objectName.getKeyProperty("type");
                if ("Host".equals(type) && this.domain.equals(objectName.getDomain())) {
                    try {
                        this.registerHost(objectName);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error registering Host " + objectName), (Throwable)e);
                    }
                }
                if (j2eeType != null) {
                    if (j2eeType.equals("WebModule")) {
                        try {
                            this.registerContext(objectName);
                        }
                        catch (Throwable t) {
                            log.warn((Object)("Error registering Context " + objectName), t);
                        }
                    } else if (j2eeType.equals("Servlet")) {
                        try {
                            this.registerWrapper(objectName);
                        }
                        catch (Throwable t) {
                            log.warn((Object)("Error registering Wrapper " + objectName), t);
                        }
                    }
                }
            } else if (notification.getType().equals("JMX.mbean.unregistered")) {
                String type = objectName.getKeyProperty("type");
                if ("Host".equals(type) && this.domain.equals(objectName.getDomain())) {
                    try {
                        this.unregisterHost(objectName);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error unregistering Host " + objectName), (Throwable)e);
                    }
                }
                if (j2eeType != null && j2eeType.equals("WebModule")) {
                    try {
                        this.unregisterContext(objectName);
                    }
                    catch (Throwable t) {
                        log.warn((Object)("Error unregistering webapp " + objectName), t);
                    }
                }
            }
        }
    }

    private void registerEngine() throws Exception {
        ObjectName engineName = new ObjectName(this.domain + ":type=Engine");
        if (!this.mBeanServer.isRegistered(engineName)) {
            return;
        }
        String defaultHost = (String)this.mBeanServer.getAttribute(engineName, "defaultHost");
        ObjectName hostName = new ObjectName(this.domain + ":type=Host," + "host=" + defaultHost);
        if (!this.mBeanServer.isRegistered(hostName)) {
            String onStr = this.domain + ":type=Host,*";
            ObjectName objectName = new ObjectName(onStr);
            Set<ObjectInstance> set = this.mBeanServer.queryMBeans(objectName, null);
            Iterator<ObjectInstance> iterator = set.iterator();
            boolean isRegisteredWithAlias = false;
            block0: while (iterator.hasNext() && !isRegisteredWithAlias) {
                ObjectInstance oi = iterator.next();
                hostName = oi.getObjectName();
                String[] aliases = (String[])this.mBeanServer.invoke(hostName, "findAliases", null, null);
                for (int i = 0; i < aliases.length; ++i) {
                    if (!aliases[i].equalsIgnoreCase(defaultHost)) continue;
                    isRegisteredWithAlias = true;
                    continue block0;
                }
            }
            if (!isRegisteredWithAlias) {
                log.warn((Object)this.sm.getString("mapperListener.unknownDefaultHost", defaultHost));
            }
        }
        if (defaultHost != null) {
            this.mapper.setDefaultHostName(defaultHost);
        }
    }

    private void registerHost(ObjectName objectName) throws Exception {
        String name = objectName.getKeyProperty("host");
        if (name != null) {
            String[] aliases = (String[])this.mBeanServer.invoke(objectName, "findAliases", null, null);
            this.mapper.addHost(name, aliases, objectName);
            if (log.isDebugEnabled()) {
                log.debug((Object)this.sm.getString("mapperListener.registerHost", name, this.domain));
            }
        }
    }

    private void unregisterHost(ObjectName objectName) throws Exception {
        String name = objectName.getKeyProperty("host");
        this.mapper.removeHost(name);
        if (log.isDebugEnabled()) {
            log.debug((Object)this.sm.getString("mapperListener.unregisterHost", name, this.domain));
        }
    }

    private void registerContext(ObjectName objectName) throws Exception {
        int slash;
        String name = objectName.getKeyProperty("name");
        String targetDomain = objectName.getDomain();
        if (!this.domain.equals(targetDomain)) {
            try {
                targetDomain = (String)this.mBeanServer.getAttribute(objectName, "engineName");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.domain.equals(targetDomain)) {
                return;
            }
        }
        String hostName = null;
        String contextName = null;
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        if ((slash = name.indexOf("/")) == -1) {
            return;
        }
        hostName = name.substring(0, slash);
        contextName = name.substring(slash);
        if (contextName.equals("/")) {
            contextName = "";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this.sm.getString("mapperListener.registerContext", contextName));
        }
        Object context = this.mBeanServer.invoke(objectName, "findMappingObject", null, null);
        Context resources = (Context)this.mBeanServer.invoke(objectName, "findStaticResources", null, null);
        String[] welcomeFiles = (String[])this.mBeanServer.getAttribute(objectName, "welcomeFiles");
        this.mapper.addContext(hostName, contextName, context, welcomeFiles, resources);
    }

    private void unregisterContext(ObjectName objectName) throws Exception {
        int slash;
        String name = objectName.getKeyProperty("name");
        String targetDomain = objectName.getDomain();
        if (!this.domain.equals(targetDomain)) {
            try {
                targetDomain = (String)this.mBeanServer.getAttribute(objectName, "engineName");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.domain.equals(targetDomain)) {
                return;
            }
        }
        String hostName = null;
        String contextName = null;
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        if ((slash = name.indexOf("/")) == -1) {
            return;
        }
        hostName = name.substring(0, slash);
        contextName = name.substring(slash);
        if (contextName.equals("/")) {
            contextName = "";
        }
        MessageBytes hostMB = MessageBytes.newInstance();
        hostMB.setString(hostName);
        MessageBytes contextMB = MessageBytes.newInstance();
        contextMB.setString(contextName);
        MappingData mappingData = new MappingData();
        this.mapper.map(hostMB, contextMB, mappingData);
        if (mappingData.context instanceof StandardContext && ((StandardContext)mappingData.context).getPaused()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this.sm.getString("mapperListener.unregisterContext", contextName));
        }
        this.mapper.removeContext(hostName, contextName);
    }

    private void registerWrapper(ObjectName objectName) throws Exception {
        int slash;
        String targetDomain = objectName.getDomain();
        if (!this.domain.equals(targetDomain)) {
            try {
                targetDomain = (String)this.mBeanServer.getAttribute(objectName, "engineName");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.domain.equals(targetDomain)) {
                return;
            }
        }
        String wrapperName = objectName.getKeyProperty("name");
        String name = objectName.getKeyProperty("WebModule");
        String hostName = null;
        String contextName = null;
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        if ((slash = name.indexOf("/")) == -1) {
            return;
        }
        hostName = name.substring(0, slash);
        contextName = name.substring(slash);
        if (contextName.equals("/")) {
            contextName = "";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this.sm.getString("mapperListener.registerWrapper", wrapperName, contextName));
        }
        String[] mappings = (String[])this.mBeanServer.invoke(objectName, "findMappings", null, null);
        Object wrapper = this.mBeanServer.invoke(objectName, "findMappingObject", null, null);
        for (int i = 0; i < mappings.length; ++i) {
            boolean jspWildCard = wrapperName.equals("jsp") && mappings[i].endsWith("/*");
            this.mapper.addWrapper(hostName, contextName, mappings[i], wrapper, jspWildCard);
        }
    }
}

