/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.InstanceManager;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.core.DefaultInstanceManager;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.log.SystemLogHandler;

final class ApplicationFilterConfig
implements FilterConfig,
Serializable {
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private Context context = null;
    private transient Filter filter = null;
    private FilterDef filterDef = null;
    private transient InstanceManager instanceManager;

    public ApplicationFilterConfig(Context context, FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException, InvocationTargetException, NamingException {
        this.context = context;
        this.setFilterDef(filterDef);
    }

    public String getFilterName() {
        return this.filterDef.getFilterName();
    }

    public String getInitParameter(String name) {
        Map map = this.filterDef.getParameterMap();
        if (map == null) {
            return null;
        }
        return (String)map.get(name);
    }

    public Enumeration getInitParameterNames() {
        Map map = this.filterDef.getParameterMap();
        if (map == null) {
            return new Enumerator(new ArrayList());
        }
        return new Enumerator(map.keySet());
    }

    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ApplicationFilterConfig[");
        sb.append("name=");
        sb.append(this.filterDef.getFilterName());
        sb.append(", filterClass=");
        sb.append(this.filterDef.getFilterClass());
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Filter getFilter() throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException, InvocationTargetException, NamingException {
        if (this.filter != null) {
            return this.filter;
        }
        String filterClass = this.filterDef.getFilterClass();
        this.filter = (Filter)this.getInstanceManager().newInstance(filterClass);
        if (this.context instanceof StandardContext && this.context.getSwallowOutput()) {
            try {
                SystemLogHandler.startCapture();
                this.filter.init((FilterConfig)this);
            }
            finally {
                String log = SystemLogHandler.stopCapture();
                if (log != null && log.length() > 0) {
                    this.getServletContext().log(log);
                }
            }
        } else {
            this.filter.init((FilterConfig)this);
        }
        return this.filter;
    }

    FilterDef getFilterDef() {
        return this.filterDef;
    }

    void release() {
        if (this.filter != null) {
            try {
                if (Globals.IS_SECURITY_ENABLED) {
                    SecurityUtil.doAsPrivilege("destroy", this.filter);
                    SecurityUtil.remove(this.filter);
                } else {
                    this.filter.destroy();
                }
            }
            catch (Exception ex) {
                this.context.getLogger().error((Object)"ApplicationFilterConfig.errorDestroyingFilter", (Throwable)ex);
            }
            if (!this.context.getIgnoreAnnotations()) {
                try {
                    ((StandardContext)this.context).getInstanceManager().destroyInstance(this.filter);
                }
                catch (Exception e) {
                    this.context.getLogger().error((Object)"ApplicationFilterConfig.preDestroy", (Throwable)e);
                }
            }
        }
        this.filter = null;
    }

    void setFilterDef(FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException, InvocationTargetException, NamingException {
        this.filterDef = filterDef;
        if (filterDef == null) {
            if (this.filter != null) {
                if (Globals.IS_SECURITY_ENABLED) {
                    try {
                        SecurityUtil.doAsPrivilege("destroy", this.filter);
                    }
                    catch (Exception ex) {
                        this.context.getLogger().error((Object)"ApplicationFilterConfig.doAsPrivilege", (Throwable)ex);
                    }
                    SecurityUtil.remove(this.filter);
                } else {
                    this.filter.destroy();
                }
                if (!this.context.getIgnoreAnnotations()) {
                    try {
                        ((StandardContext)this.context).getInstanceManager().destroyInstance(this.filter);
                    }
                    catch (Exception e) {
                        this.context.getLogger().error((Object)"ApplicationFilterConfig.preDestroy", (Throwable)e);
                    }
                }
            }
            this.filter = null;
        } else {
            Filter filter = this.getFilter();
        }
    }

    private InstanceManager getInstanceManager() {
        if (this.instanceManager == null) {
            this.instanceManager = this.context instanceof StandardContext ? ((StandardContext)this.context).getInstanceManager() : new DefaultInstanceManager(null, new HashMap<String, Map<String, String>>(), this.context, this.getClass().getClassLoader());
        }
        return this.instanceManager;
    }
}

