/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.annotation.security.DeclareRoles;
import javax.servlet.annotation.MultipartConfig;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceEnvRef;
import org.apache.catalina.deploy.ContextService;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.MessageDestinationRef;
import org.apache.catalina.deploy.Multipart;

public class WebAnnotationSet {
    public static void loadApplicationAnnotations(Context context) {
        WebAnnotationSet.loadApplicationListenerAnnotations(context);
        WebAnnotationSet.loadApplicationFilterAnnotations(context);
        WebAnnotationSet.loadApplicationServletAnnotations(context);
    }

    protected static void loadApplicationListenerAnnotations(Context context) {
        String[] applicationListeners = context.findApplicationListeners();
        for (int i = 0; i < applicationListeners.length; ++i) {
            WebAnnotationSet.loadClassAnnotation(context, applicationListeners[i]);
        }
    }

    protected static void loadApplicationFilterAnnotations(Context context) {
        FilterDef[] filterDefs = context.findFilterDefs();
        for (int i = 0; i < filterDefs.length; ++i) {
            WebAnnotationSet.loadClassAnnotation(context, filterDefs[i].getFilterClass());
        }
    }

    protected static void loadApplicationServletAnnotations(Context context) {
        ClassLoader classLoader = context.getLoader().getClassLoader();
        StandardWrapper wrapper = null;
        Class<?> classClass = null;
        Container[] children = context.findChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof StandardWrapper) || (wrapper = (StandardWrapper)children[i]).getServletClass() == null) continue;
            try {
                classClass = classLoader.loadClass(wrapper.getServletClass());
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
            if (classClass == null) continue;
            WebAnnotationSet.loadClassAnnotation(context, wrapper.getServletClass());
            if (!classClass.isAnnotationPresent(MultipartConfig.class)) continue;
            MultipartConfig annotation = classClass.getAnnotation(MultipartConfig.class);
            Multipart multipartConfig = new Multipart();
            multipartConfig.setLocation(annotation.location());
            multipartConfig.setMaxRequestSize(annotation.maxRequestSize());
            multipartConfig.setMaxFileSize(annotation.maxFileSize());
            multipartConfig.setFileSizeThreshold(annotation.fileSizeThreshold());
            wrapper.setMultipartConfig(multipartConfig);
        }
    }

    protected static void loadClassAnnotation(Context context, String fileString) {
        int i;
        Resource annotation;
        ClassLoader classLoader = context.getLoader().getClassLoader();
        Class<?> classClass = null;
        try {
            classClass = classLoader.loadClass(fileString);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        if (classClass == null) {
            return;
        }
        if (classClass.isAnnotationPresent(Resource.class)) {
            annotation = classClass.getAnnotation(Resource.class);
            WebAnnotationSet.addResource(context, annotation);
        }
        if (classClass.isAnnotationPresent(Resources.class)) {
            annotation = classClass.getAnnotation(Resources.class);
            for (i = 0; annotation.value() != null && i < annotation.value().length; ++i) {
                WebAnnotationSet.addResource(context, annotation.value()[i]);
            }
        }
        if (classClass.isAnnotationPresent(DeclareRoles.class)) {
            annotation = classClass.getAnnotation(DeclareRoles.class);
            for (i = 0; annotation.value() != null && i < annotation.value().length; ++i) {
                context.addSecurityRole(annotation.value()[i]);
            }
        }
    }

    protected static void addResource(Context context, Resource annotation) {
        if (annotation.type().getCanonicalName().equals("java.lang.String") || annotation.type().getCanonicalName().equals("java.lang.Character") || annotation.type().getCanonicalName().equals("java.lang.Integer") || annotation.type().getCanonicalName().equals("java.lang.Boolean") || annotation.type().getCanonicalName().equals("java.lang.Double") || annotation.type().getCanonicalName().equals("java.lang.Byte") || annotation.type().getCanonicalName().equals("java.lang.Short") || annotation.type().getCanonicalName().equals("java.lang.Long") || annotation.type().getCanonicalName().equals("java.lang.Float")) {
            ContextEnvironment resource = new ContextEnvironment();
            resource.setName(annotation.name());
            resource.setType(annotation.type().getCanonicalName());
            resource.setDescription(annotation.description());
            resource.setValue(annotation.mappedName());
            context.getNamingResources().addEnvironment(resource);
        } else if (annotation.type().getCanonicalName().equals("javax.xml.rpc.Service")) {
            ContextService service = new ContextService();
            service.setName(annotation.name());
            service.setWsdlfile(annotation.mappedName());
            service.setType(annotation.type().getCanonicalName());
            service.setDescription(annotation.description());
            context.getNamingResources().addService(service);
        } else if (annotation.type().getCanonicalName().equals("javax.sql.DataSource") || annotation.type().getCanonicalName().equals("javax.jms.ConnectionFactory") || annotation.type().getCanonicalName().equals("javax.jms.QueueConnectionFactory") || annotation.type().getCanonicalName().equals("javax.jms.TopicConnectionFactory") || annotation.type().getCanonicalName().equals("javax.mail.Session") || annotation.type().getCanonicalName().equals("java.net.URL") || annotation.type().getCanonicalName().equals("javax.resource.cci.ConnectionFactory") || annotation.type().getCanonicalName().equals("org.omg.CORBA_2_3.ORB") || annotation.type().getCanonicalName().endsWith("ConnectionFactory")) {
            ContextResource resource = new ContextResource();
            resource.setName(annotation.name());
            resource.setType(annotation.type().getCanonicalName());
            if (annotation.authenticationType() == Resource.AuthenticationType.CONTAINER) {
                resource.setAuth("Container");
            } else if (annotation.authenticationType() == Resource.AuthenticationType.APPLICATION) {
                resource.setAuth("Application");
            }
            resource.setScope(annotation.shareable() ? "Shareable" : "Unshareable");
            resource.setProperty("mappedName", annotation.mappedName());
            resource.setDescription(annotation.description());
            context.getNamingResources().addResource(resource);
        } else if (annotation.type().getCanonicalName().equals("javax.jms.Queue") || annotation.type().getCanonicalName().equals("javax.jms.Topic")) {
            MessageDestinationRef resource = new MessageDestinationRef();
            resource.setName(annotation.name());
            resource.setType(annotation.type().getCanonicalName());
            resource.setUsage(annotation.mappedName());
            resource.setDescription(annotation.description());
            context.getNamingResources().addMessageDestinationRef(resource);
        } else {
            if (annotation.type().getCanonicalName().equals("javax.resource.cci.InteractionSpec") || !annotation.type().getCanonicalName().equals("javax.transaction.UserTransaction")) {
                // empty if block
            }
            ContextResourceEnvRef resource = new ContextResourceEnvRef();
            resource.setName(annotation.name());
            resource.setType(annotation.type().getCanonicalName());
            resource.setProperty("mappedName", annotation.mappedName());
            resource.setDescription(annotation.description());
            context.getNamingResources().addResourceEnvRef(resource);
        }
    }
}

