/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.JavaCompiler;
import org.apache.commons.jci.compilers.JavaCompilerFactory;
import org.apache.commons.jci.compilers.JavaCompilerSettings;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.readers.FileResourceReader;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.FileResourceStore;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.SmapUtil;

public class JCICompiler
extends Compiler {
    @Override
    protected void generateClass(String[] smap) throws FileNotFoundException, JasperException, Exception {
        long t1 = 0L;
        if (this.log.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        String packageName = this.ctxt.getServletPackageName();
        ClassLoader classLoader = this.ctxt.getJspLoader();
        String targetResource = ((packageName.length() != 0 ? packageName + "." : "") + this.ctxt.getServletClassName()).replace('.', '/') + ".java";
        String[] resources = new String[]{targetResource};
        JavaCompiler javaCompiler = new JavaCompilerFactory().createCompiler(this.options.getCompiler().substring(4));
        FileResourceReader reader = new FileResourceReader(this.ctxt.getOptions().getScratchDir());
        FileResourceStore store = new FileResourceStore(this.ctxt.getOptions().getScratchDir());
        JavaCompilerSettings settings = javaCompiler.createDefaultSettings();
        if (settings == null) {
            settings = new JavaCompilerSettings();
        }
        settings.setDeprecations(false);
        if (this.ctxt.getOptions().getJavaEncoding() != null) {
            settings.setSourceEncoding(this.ctxt.getOptions().getJavaEncoding());
        }
        if (this.ctxt.getOptions().getClassDebugInfo()) {
            // empty if block
        }
        if (this.ctxt.getOptions().getCompilerSourceVM() != null) {
            settings.setSourceVersion(this.ctxt.getOptions().getCompilerSourceVM());
        } else {
            settings.setSourceVersion("1.5");
        }
        if (this.ctxt.getOptions().getCompilerTargetVM() != null) {
            settings.setTargetVersion(this.ctxt.getOptions().getCompilerTargetVM());
        } else {
            settings.setTargetVersion("1.5");
        }
        CompilationResult result = javaCompiler.compile(resources, (ResourceReader)reader, (ResourceStore)store, classLoader, settings);
        ArrayList<JavacErrorDetail> problemList = new ArrayList<JavacErrorDetail>();
        CompilationProblem[] problems = result.getErrors();
        if (problems != null) {
            try {
                for (int i = 0; i < problems.length; ++i) {
                    CompilationProblem problem = problems[i];
                    problemList.add(ErrorDispatcher.createJavacError(problem.getFileName(), this.pageNodes, new StringBuilder(problem.getMessage()), problem.getStartLine(), this.ctxt));
                }
            }
            catch (JasperException e) {
                this.log.error((Object)"Error visiting node", (Throwable)((Object)e));
            }
        }
        if (!this.ctxt.keepGenerated()) {
            File javaFile = new File(this.ctxt.getServletJavaFileName());
            javaFile.delete();
        }
        if (!problemList.isEmpty()) {
            JavacErrorDetail[] jeds = problemList.toArray(new JavacErrorDetail[0]);
            this.errDispatcher.javacError(jeds);
        }
        if (this.log.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            this.log.debug((Object)("Compiled " + this.ctxt.getServletJavaFileName() + " " + (t2 - t1) + "ms"));
        }
        if (this.ctxt.isPrototypeMode()) {
            return;
        }
        if (!this.options.isSmapSuppressed()) {
            SmapUtil.installSmap(smap);
        }
    }
}

