/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.DispatcherType;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.JarRepository;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.ContextJarRepository;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.deploy.WebAbsoluteOrdering;
import org.apache.catalina.deploy.WebOrdering;
import org.apache.catalina.deploy.jsp.TagLibraryInfo;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.DigesterFactory;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.OrderingResolver;
import org.apache.catalina.startup.TldRuleSet;
import org.apache.catalina.startup.WebAnnotationSet;
import org.apache.catalina.startup.WebOrderingRuleSet;
import org.apache.catalina.startup.WebRuleSet;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.JARDirContext;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.tomcat.util.digester.Digester;
import org.jboss.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class ContextConfig
implements LifecycleListener {
    protected static Logger log = Logger.getLogger(ContextConfig.class);
    protected Map customAuthenticators;
    protected static Properties authenticators = null;
    protected Context context = null;
    protected String defaultContextXml = null;
    protected String defaultWebXml = null;
    protected boolean ok = false;
    protected SAXParseException parseException = null;
    protected String originalDocBase = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected static Digester contextDigester = null;
    protected static Digester webDigester = null;
    protected static Digester webFragmentDigester = null;
    protected static Digester tldDigester = null;
    protected static Digester fragmentOrderingDigester = null;
    protected static Digester orderingDigester = null;
    protected static WebRuleSet webRuleSet = new WebRuleSet();
    protected static WebRuleSet webFragmentRuleSet = new WebRuleSet("", true);
    protected static long deploymentCount = 0L;
    protected static final LoginConfig DUMMY_LOGIN_CONFIG = new LoginConfig("NONE", null, null, null);
    protected ArrayList<String> overlays = new ArrayList();
    protected ArrayList<String> webFragments = new ArrayList();
    protected Map<String, Set<String>> TLDs = new HashMap<String, Set<String>>();
    protected Map<String, ServletContainerInitializerInfo> servletContainerInitializerInfos = new HashMap<String, ServletContainerInitializerInfo>();
    protected LinkedList<String> order = new LinkedList();
    protected Class<?>[] handlesTypesArray = null;
    protected Map<Class<?>, ServletContainerInitializerInfo> handlesTypes = new HashMap();

    public String getDefaultWebXml() {
        if (this.defaultWebXml == null) {
            this.defaultWebXml = "conf/web.xml";
        }
        return this.defaultWebXml;
    }

    public void setDefaultWebXml(String path) {
        this.defaultWebXml = path;
    }

    public String getDefaultContextXml() {
        if (this.defaultContextXml == null) {
            this.defaultContextXml = "conf/context.xml";
        }
        return this.defaultContextXml;
    }

    public void setDefaultContextXml(String path) {
        this.defaultContextXml = path;
    }

    public void setCustomAuthenticators(Map customAuthenticators) {
        this.customAuthenticators = customAuthenticators;
    }

    public Iterator<String> getOverlays() {
        return this.overlays.iterator();
    }

    public Iterator<String> getWebFragments() {
        return this.order.iterator();
    }

    public Map<String, Set<String>> getTLDs() {
        return this.TLDs;
    }

    public Map<String, ServletContainerInitializerInfo> getServletContainerInitializerInfo() {
        return this.servletContainerInitializerInfos;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.context = (Context)((Object)event.getLifecycle());
        }
        catch (ClassCastException e) {
            log.error((Object)sm.getString("contextConfig.cce", event.getLifecycle()), (Throwable)e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("before_start")) {
            this.beforeStart();
        } else if (event.getType().equals("after_start")) {
            if (this.originalDocBase != null) {
                String docBase = this.context.getDocBase();
                this.context.setDocBase(this.originalDocBase);
                this.originalDocBase = docBase;
            }
            if (this.ok) {
                for (ServletContainerInitializerInfo service : this.getServletContainerInitializerInfo().values()) {
                    try {
                        ServletContainerInitializer servletContainerInitializer = (ServletContainerInitializer)service.getServletContainerInitializer().newInstance();
                        servletContainerInitializer.onStartup(service.getStartupNotifySet(), this.context.getServletContext());
                    }
                    catch (Throwable t) {
                        log.error((Object)sm.getString("contextConfig.servletContainerInitializer", service.getServletContainerInitializer().getName()), t);
                        this.ok = false;
                    }
                }
            }
        } else if (event.getType().equals("complete-config")) {
            this.completeConfig();
        } else if (event.getType().equals("stop")) {
            if (this.originalDocBase != null) {
                String docBase = this.context.getDocBase();
                this.context.setDocBase(this.originalDocBase);
                this.originalDocBase = docBase;
            }
            this.stop();
        } else if (event.getType().equals("init")) {
            this.init();
        } else if (event.getType().equals("destroy")) {
            this.destroy();
        }
    }

    protected void processConfigAnnotations(Class<?> clazz) {
        WebFilter annotation;
        if (clazz.isAnnotationPresent(WebFilter.class)) {
            DispatcherType[] dispatcherTypes;
            String[] servletNames;
            annotation = clazz.getAnnotation(WebFilter.class);
            String filterName = annotation.filterName();
            FilterDef filterDef = new FilterDef();
            filterDef.setFilterName(annotation.filterName());
            filterDef.setFilterClass(clazz.getName());
            WebInitParam[] params = annotation.initParams();
            for (int i = 0; i < params.length; ++i) {
                filterDef.addInitParameter(params[i].name(), params[i].value());
            }
            this.context.addFilterDef(filterDef);
            FilterMap filterMap = new FilterMap();
            filterMap.setFilterName(filterName);
            String[] urlPatterns = annotation.urlPatterns();
            if (urlPatterns != null) {
                for (int i = 0; i < urlPatterns.length; ++i) {
                    filterMap.addURLPattern(urlPatterns[i]);
                }
            }
            if ((servletNames = annotation.servletNames()) != null) {
                for (int i = 0; i < servletNames.length; ++i) {
                    filterMap.addServletName(servletNames[i]);
                }
            }
            if ((dispatcherTypes = annotation.dispatcherTypes()) != null) {
                for (int i = 0; i < dispatcherTypes.length; ++i) {
                    filterMap.setDispatcher(dispatcherTypes[i].toString());
                }
            }
            this.context.addFilterMap(filterMap);
        }
        if (clazz.isAnnotationPresent(WebServlet.class)) {
            annotation = clazz.getAnnotation(WebServlet.class);
            Wrapper wrapper = this.context.createWrapper();
            wrapper.setName(annotation.name());
            wrapper.setServletClass(clazz.getName());
            wrapper.setLoadOnStartup(annotation.loadOnStartup());
            WebInitParam[] params = annotation.initParams();
            for (int i = 0; i < params.length; ++i) {
                wrapper.addInitParameter(params[i].name(), params[i].value());
            }
            this.context.addChild(wrapper);
            String[] urlPatterns = annotation.urlPatterns();
            if (urlPatterns != null) {
                for (int i = 0; i < urlPatterns.length; ++i) {
                    this.context.addServletMapping(urlPatterns[i], annotation.name());
                }
            }
        }
        if (clazz.isAnnotationPresent(WebListener.class)) {
            this.context.addApplicationListener(clazz.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applicationWebConfig() {
        String altDDName = null;
        InputStream stream = null;
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext != null) {
            altDDName = (String)servletContext.getAttribute("org.apache.catalina.deploy.alt_dd");
            if (altDDName != null) {
                try {
                    stream = new FileInputStream(altDDName);
                }
                catch (FileNotFoundException e) {
                    log.error((Object)sm.getString("contextConfig.altDDNotFound", altDDName));
                }
            } else {
                stream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
            }
        }
        if (stream == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(sm.getString("contextConfig.applicationMissing") + " " + this.context));
            }
            return;
        }
        URL url = null;
        Digester digester = webDigester;
        synchronized (digester) {
            try {
                url = altDDName != null ? new File(altDDName).toURI().toURL() : servletContext.getResource("/WEB-INF/web.xml");
                if (url != null) {
                    InputSource is = new InputSource(url.toExternalForm());
                    is.setByteStream(stream);
                    if (this.context instanceof StandardContext) {
                        ((StandardContext)this.context).setReplaceWelcomeFiles(true);
                    }
                    webDigester.push(this.context);
                    webDigester.setErrorHandler(new ContextErrorHandler());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Parsing application web.xml file at " + url.toExternalForm()));
                    }
                    webDigester.parse(is);
                    if (this.parseException != null) {
                        this.ok = false;
                    }
                } else {
                    log.info((Object)("No web.xml, using defaults " + this.context));
                }
            }
            catch (SAXParseException e) {
                log.error((Object)sm.getString("contextConfig.applicationParse", url.toExternalForm()), (Throwable)e);
                log.error((Object)sm.getString("contextConfig.applicationPosition", "" + e.getLineNumber(), "" + e.getColumnNumber()));
                this.ok = false;
            }
            catch (Exception e) {
                log.error((Object)sm.getString("contextConfig.applicationParse", url.toExternalForm()), (Throwable)e);
                this.ok = false;
            }
            finally {
                webDigester.reset();
                webRuleSet.recycle();
                this.parseException = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)sm.getString("contextConfig.applicationClose"), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applicationTldConfig() {
        TagLibraryInfo tagLibraryInfo;
        Map<String, Set<String>> TLDs = this.getTLDs();
        Set<String> warTLDs = TLDs.get("");
        ArrayList<TagLibraryInfo> tagLibraries = new ArrayList<TagLibraryInfo>();
        Iterator<String> warTLDsIterator = warTLDs.iterator();
        InputStream stream = null;
        while (warTLDsIterator.hasNext()) {
            String tldPath = warTLDsIterator.next();
            try {
                stream = this.context.getServletContext().getResourceAsStream(tldPath);
                if (stream == null) {
                    log.error((Object)sm.getString("contextConfig.tldResourcePath", tldPath));
                    this.ok = false;
                    continue;
                }
                Digester digester = tldDigester;
                synchronized (digester) {
                    TagLibraryInfo tagLibraryInfo2 = new TagLibraryInfo();
                    try {
                        tldDigester.push(tagLibraryInfo2);
                        tldDigester.parse(new InputSource(stream));
                    }
                    finally {
                        tldDigester.reset();
                    }
                    tagLibraryInfo2.setLocation("");
                    tagLibraryInfo2.setPath(tldPath);
                    tagLibraries.add(tagLibraryInfo2);
                    this.context.addJspTagLibrary(tagLibraryInfo2);
                    this.context.addJspTagLibrary(tldPath, tagLibraryInfo2);
                }
            }
            catch (Exception e) {
                log.error((Object)sm.getString("contextConfig.tldFileException", tldPath, this.context.getPath()), (Throwable)e);
                this.ok = false;
            }
            finally {
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (Throwable t) {}
            }
        }
        for (String jarPath : TLDs.keySet()) {
            if (jarPath.equals("")) continue;
            JarRepository jarRepository = this.context.getJarRepository();
            JarFile jarFile = jarRepository.findJar(jarPath);
            Iterator<String> jarTLDsIterator = TLDs.get(jarPath).iterator();
            while (jarTLDsIterator.hasNext()) {
                try {
                    String tldPath = jarTLDsIterator.next();
                    stream = jarFile.getInputStream(jarFile.getEntry(tldPath));
                    Digester t = tldDigester;
                    synchronized (t) {
                        tagLibraryInfo = new TagLibraryInfo();
                        try {
                            tldDigester.push(tagLibraryInfo);
                            tldDigester.parse(new InputSource(stream));
                        }
                        finally {
                            tldDigester.reset();
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable t2) {}
                            }
                        }
                        tagLibraryInfo.setLocation(jarPath);
                        tagLibraryInfo.setPath(tldPath);
                        tagLibraries.add(tagLibraryInfo);
                        this.context.addJspTagLibrary(tagLibraryInfo);
                        if (tldPath.equals("META-INF/taglib.tld")) {
                            this.context.addJspTagLibrary(jarPath, tagLibraryInfo);
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("contextConfig.tldJarException", jarPath, this.context.getPath()), (Throwable)e);
                    this.ok = false;
                }
                finally {
                    if (stream == null) continue;
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        String[] taglibs = this.context.findTaglibs();
        for (int i = 0; i < taglibs.length; ++i) {
            String uri = taglibs[i];
            String path = this.context.findTaglib(taglibs[i]);
            String location = "";
            if (path.indexOf(58) == -1 && !path.startsWith("/")) {
                path = "/WEB-INF/" + path;
            }
            if (path.endsWith(".jar")) {
                location = path;
                path = "META-INF/taglib.tld";
            }
            for (int j = 0; j < tagLibraries.size(); ++j) {
                tagLibraryInfo = (TagLibraryInfo)tagLibraries.get(j);
                if (!tagLibraryInfo.getLocation().equals(location) || !tagLibraryInfo.getPath().equals(path)) continue;
                this.context.addJspTagLibrary(uri, tagLibraryInfo);
            }
        }
    }

    protected void authenticatorConfig() {
        Pipeline pipeline;
        SecurityConstraint[] constraints = this.context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            return;
        }
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = DUMMY_LOGIN_CONFIG;
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context instanceof Authenticator) {
            return;
        }
        if (this.context instanceof ContainerBase) {
            Pipeline pipeline2 = ((ContainerBase)((Object)this.context)).getPipeline();
            if (pipeline2 != null) {
                Valve basic = pipeline2.getBasic();
                if (basic != null && basic instanceof Authenticator) {
                    return;
                }
                Valve[] valves = pipeline2.getValves();
                for (int i = 0; i < valves.length; ++i) {
                    if (!(valves[i] instanceof Authenticator)) continue;
                    return;
                }
            }
        } else {
            return;
        }
        if (this.context.getRealm() == null) {
            log.error((Object)sm.getString("contextConfig.missingRealm"));
            this.ok = false;
            return;
        }
        Valve authenticator = null;
        if (this.customAuthenticators != null) {
            authenticator = (Valve)this.customAuthenticators.get(loginConfig.getAuthMethod());
        }
        if (authenticator == null) {
            if (authenticators == null) {
                try {
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/startup/Authenticators.properties");
                    if (is == null) {
                        log.error((Object)sm.getString("contextConfig.authenticatorResources"));
                        this.ok = false;
                        return;
                    }
                    authenticators = new Properties();
                    authenticators.load(is);
                }
                catch (IOException e) {
                    log.error((Object)sm.getString("contextConfig.authenticatorResources"), (Throwable)e);
                    this.ok = false;
                    return;
                }
            }
            String authenticatorName = null;
            authenticatorName = authenticators.getProperty(loginConfig.getAuthMethod());
            if (authenticatorName == null) {
                log.error((Object)sm.getString("contextConfig.authenticatorMissing", loginConfig.getAuthMethod()));
                this.ok = false;
                return;
            }
            try {
                Class<?> authenticatorClass = Class.forName(authenticatorName);
                authenticator = (Valve)authenticatorClass.newInstance();
            }
            catch (Throwable t) {
                log.error((Object)sm.getString("contextConfig.authenticatorInstantiate", authenticatorName), t);
                this.ok = false;
            }
        }
        if (authenticator instanceof Authenticator) {
            this.context.setAuthenticator((Authenticator)((Object)authenticator));
        }
        if (authenticator != null && this.context instanceof ContainerBase && (pipeline = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
            ((ContainerBase)((Object)this.context)).addValve(authenticator);
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("contextConfig.authenticatorConfigured", loginConfig.getAuthMethod()));
            }
        }
    }

    protected static Digester createWebDigester() {
        return DigesterFactory.newDigester(Globals.XML_NAMESPACE_AWARE, Globals.XML_VALIDATION, webRuleSet);
    }

    protected static Digester createWebFragmentDigester() {
        return DigesterFactory.newDigester(Globals.XML_NAMESPACE_AWARE, Globals.XML_VALIDATION, webFragmentRuleSet);
    }

    protected static Digester createTldDigester() {
        return DigesterFactory.newDigester(Globals.XML_NAMESPACE_AWARE, Globals.XML_VALIDATION, new TldRuleSet());
    }

    protected static Digester createFragmentOrderingDigester() {
        return DigesterFactory.newDigester(Globals.XML_NAMESPACE_AWARE, Globals.XML_VALIDATION, new WebOrderingRuleSet());
    }

    protected static Digester createContextDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        ContextRuleSet contextRuleSet = new ContextRuleSet("", false);
        digester.addRuleSet(contextRuleSet);
        NamingRuleSet namingRuleSet = new NamingRuleSet("Context/");
        digester.addRuleSet(namingRuleSet);
        return digester;
    }

    protected String getBaseDir() {
        Container engineC = this.context.getParent().getParent();
        if (engineC instanceof StandardEngine) {
            return ((StandardEngine)engineC).getBaseDir();
        }
        return System.getProperty("catalina.base");
    }

    protected void defaultWebConfig() {
        long t2;
        File file;
        long t1 = System.currentTimeMillis();
        if (this.defaultWebXml == null && this.context instanceof StandardContext) {
            this.defaultWebXml = ((StandardContext)this.context).getDefaultWebXml();
        }
        if (this.defaultWebXml == null) {
            this.getDefaultWebXml();
        }
        if (!(file = new File(this.defaultWebXml)).isAbsolute()) {
            file = new File(this.getBaseDir(), this.defaultWebXml);
        }
        InputStream stream = null;
        InputSource source = null;
        try {
            if (!file.exists()) {
                stream = this.getClass().getClassLoader().getResourceAsStream(this.defaultWebXml);
                if (stream != null) {
                    source = new InputSource(this.getClass().getClassLoader().getResource(this.defaultWebXml).toString());
                }
                if (stream == null && (stream = this.getClass().getClassLoader().getResourceAsStream("web-embed.xml")) != null) {
                    source = new InputSource(this.getClass().getClassLoader().getResource("web-embed.xml").toString());
                }
                if (stream == null) {
                    log.info((Object)"No default web.xml");
                }
            } else {
                source = new InputSource("file://" + file.getAbsolutePath());
                stream = new FileInputStream(file);
                this.context.addWatchedResource(file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            log.error((Object)(sm.getString("contextConfig.defaultMissing") + " " + this.defaultWebXml + " " + file), (Throwable)e);
        }
        if (stream != null) {
            this.processDefaultWebConfig(webDigester, stream, source);
            webRuleSet.recycle();
        }
        if ((t2 = System.currentTimeMillis()) - t1 > 200L) {
            log.debug((Object)("Processed default web.xml " + file + " " + (t2 - t1)));
        }
        stream = null;
        source = null;
        String resourceName = this.getHostConfigPath("web.xml.default");
        file = new File(this.getConfigBase(), resourceName);
        try {
            if (!file.exists()) {
                stream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
                if (stream != null) {
                    source = new InputSource(this.getClass().getClassLoader().getResource(resourceName).toString());
                }
            } else {
                source = new InputSource("file://" + file.getAbsolutePath());
                stream = new FileInputStream(file);
            }
        }
        catch (Exception e) {
            log.error((Object)(sm.getString("contextConfig.defaultMissing") + " " + resourceName + " " + file), (Throwable)e);
        }
        if (stream != null) {
            this.processDefaultWebConfig(webDigester, stream, source);
            webRuleSet.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDefaultWebConfig(Digester digester, InputStream stream, InputSource source) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing context [" + this.context.getName() + "] web configuration resource " + source.getSystemId()));
        }
        Digester digester2 = digester;
        synchronized (digester2) {
            try {
                source.setByteStream(stream);
                if (this.context instanceof StandardContext) {
                    ((StandardContext)this.context).setReplaceWelcomeFiles(true);
                }
                digester.setClassLoader(this.getClass().getClassLoader());
                digester.setUseContextClassLoader(false);
                digester.push(this.context);
                digester.setErrorHandler(new ContextErrorHandler());
                digester.parse(source);
                if (this.parseException != null) {
                    this.ok = false;
                }
            }
            catch (SAXParseException e) {
                log.error((Object)sm.getString("contextConfig.defaultParse"), (Throwable)e);
                log.error((Object)sm.getString("contextConfig.defaultPosition", "" + e.getLineNumber(), "" + e.getColumnNumber()));
                this.ok = false;
            }
            catch (Exception e) {
                log.error((Object)sm.getString("contextConfig.defaultParse"), (Throwable)e);
                this.ok = false;
            }
            finally {
                digester.reset();
                this.parseException = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)sm.getString("contextConfig.defaultClose"), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFragmentsOrder() {
        WebAbsoluteOrdering absoluteOrdering = this.context.getWebAbsoluteOrdering();
        ArrayList<WebOrdering> orderings = new ArrayList<WebOrdering>();
        HashSet<String> jarsSet = new HashSet<String>();
        boolean fragmentFound = false;
        JarRepository jarRepository = this.context.getJarRepository();
        JarFile[] jars = jarRepository.findJars();
        for (int i = 0; i < jars.length; ++i) {
            jarsSet.add(jars[i].getName());
            JarFile jarFile = jars[i];
            InputStream is = null;
            ZipEntry entry = jarFile.getEntry(Globals.WEB_FRAGMENT_PATH);
            if (entry != null) {
                fragmentFound = true;
                try {
                    this.webFragments.add(jars[i].getName());
                    is = jarFile.getInputStream(entry);
                    InputSource input = new InputSource(new File(jars[i].getName()).toURI().toURL().toExternalForm());
                    input.setByteStream(is);
                    Digester digester = fragmentOrderingDigester;
                    synchronized (digester) {
                        try {
                            fragmentOrderingDigester.parse(input);
                            WebOrdering ordering = (WebOrdering)fragmentOrderingDigester.peek();
                            if (ordering != null) {
                                ordering.setJar(jars[i].getName());
                                orderings.add(ordering);
                            }
                        }
                        finally {
                            fragmentOrderingDigester.reset();
                        }
                        continue;
                    }
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("contextConfig.fragmentOrderingParse", jars[i].getName()), (Throwable)e);
                    this.ok = false;
                    continue;
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
            WebOrdering ordering = new WebOrdering();
            ordering.setJar(jars[i].getName());
            orderings.add(ordering);
        }
        if (!fragmentFound) {
            orderings.clear();
        }
        if (absoluteOrdering != null) {
            List<String> fragmentNames = absoluteOrdering.getOrder();
            int otherPos = -1;
            block20: for (int i = 0; i < fragmentNames.size(); ++i) {
                String fragmentName = fragmentNames.get(i);
                if (fragmentName.equals("*")) {
                    if (otherPos >= 0) {
                        log.error((Object)sm.getString("contextConfig.invalidAbsoluteOrder"));
                        this.ok = false;
                    }
                    otherPos = i;
                    continue;
                }
                for (WebOrdering ordering : orderings) {
                    if (!fragmentName.equals(ordering.getName())) continue;
                    this.order.add(ordering.getJar());
                    jarsSet.remove(ordering.getJar());
                    continue block20;
                }
            }
            if (otherPos >= 0) {
                this.order.addAll(otherPos, jarsSet);
            }
        } else if (orderings.size() > 0) {
            try {
                OrderingResolver.resolveOrder(orderings, this.order);
            }
            catch (IllegalStateException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.ok = false;
            }
        } else {
            this.order.addAll(jarsSet);
        }
    }

    protected String getJarName(List<WebOrdering> orderings, String name) {
        for (WebOrdering ordering : orderings) {
            if (!name.equals(ordering.getName())) continue;
            return ordering.getJar();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applicationExtraDescriptorsConfig() {
        JarRepository jarRepository = this.context.getJarRepository();
        HashSet<String> warTLDs = new HashSet<String>();
        DirContext resources = this.context.getResources();
        if (resources != null) {
            this.tldScanResourcePathsWebInf(resources, "/WEB-INF", warTLDs);
        }
        this.TLDs.put("", warTLDs);
        File[] explodedJars = jarRepository.findExplodedJars();
        for (int i = 0; i < explodedJars.length; ++i) {
            this.scanClasses(explodedJars[i], "", !this.context.getIgnoreAnnotations());
        }
        for (String jar : this.order) {
            JarFile jarFile = jarRepository.findJar(jar);
            InputStream is = null;
            ZipEntry entry = jarFile.getEntry(Globals.WEB_FRAGMENT_PATH);
            if (entry != null) {
                try {
                    is = jarFile.getInputStream(entry);
                    InputSource input = new InputSource(new File(jar).toURI().toURL().toExternalForm());
                    input.setByteStream(is);
                    Digester digester = webFragmentDigester;
                    synchronized (digester) {
                        try {
                            webFragmentDigester.push(this.context);
                            webFragmentDigester.setErrorHandler(new ContextErrorHandler());
                            webFragmentDigester.parse(input);
                            if (this.parseException != null) {
                                this.ok = false;
                            }
                        }
                        finally {
                            webFragmentDigester.reset();
                            webFragmentRuleSet.recycle();
                            this.parseException = null;
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("contextConfig.applicationParse", jar), (Throwable)e);
                    this.ok = false;
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
            this.scanJar(jarFile, true);
        }
        JarFile[] jarFiles = jarRepository.findJars();
        for (int i = 0; i < jarFiles.length; ++i) {
            if (this.order.contains(jarFiles[i].getName())) continue;
            this.scanJar(jarFiles[i], false);
        }
    }

    protected void scanJar(JarFile jarFile, boolean annotations) {
        HashSet<String> jarTLDs = new HashSet<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.endsWith(".class")) {
                String className = this.getClassName(entry.getName());
                this.scanClass(className, annotations);
                continue;
            }
            if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
            jarTLDs.add(name);
        }
        if (jarTLDs.size() > 0) {
            this.TLDs.put(jarFile.getName(), jarTLDs);
        }
    }

    protected void tldScanResourcePathsWebInf(DirContext resources, String rootPath, HashSet<String> tldPaths) {
        try {
            NamingEnumeration<NameClassPair> items = resources.list(rootPath);
            while (items.hasMoreElements()) {
                NameClassPair item = (NameClassPair)items.nextElement();
                String resourcePath = rootPath + "/" + item.getName();
                if (!resourcePath.endsWith(".tld") && (resourcePath.startsWith("/WEB-INF/classes") || resourcePath.startsWith("/WEB-INF/lib"))) continue;
                if (resourcePath.endsWith(".tld")) {
                    tldPaths.add(resourcePath);
                    continue;
                }
                this.tldScanResourcePathsWebInf(resources, resourcePath, tldPaths);
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
    }

    protected void scanClasses(File folder, String path, boolean annotations) {
        String[] files = folder.list();
        for (int i = 0; i < files.length; ++i) {
            File file = new File(folder, files[i]);
            if (file.isDirectory()) {
                this.scanClasses(file, path + "/" + files[i], annotations);
                continue;
            }
            if (!files[i].endsWith(".class")) continue;
            String className = this.getClassName(path + "/" + files[i]);
            this.scanClass(className, annotations);
        }
    }

    protected void scanClass(String className, boolean annotations) {
        if (!annotations && this.handlesTypesArray == null) {
            return;
        }
        try {
            Class<?> clazz = this.context.getLoader().getClassLoader().loadClass(className);
            if (this.handlesTypesArray != null) {
                for (int i = 0; i < this.handlesTypesArray.length; ++i) {
                    if (!this.handlesTypesArray[i].isAssignableFrom(clazz)) continue;
                    ServletContainerInitializerInfo jarServletContainerInitializerService = this.handlesTypes.get(this.handlesTypesArray[i]);
                    jarServletContainerInitializerService.addStartupNotifyClass(clazz);
                }
            }
            if (annotations && (clazz.isAnnotationPresent(MultipartConfig.class) || clazz.isAnnotationPresent(WebFilter.class) || clazz.isAnnotationPresent(WebInitParam.class) || clazz.isAnnotationPresent(WebListener.class) || clazz.isAnnotationPresent(WebServlet.class))) {
                this.processConfigAnnotations(clazz);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected String getClassName(String filePath) {
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        if (filePath.endsWith(".class")) {
            filePath = filePath.substring(0, filePath.length() - ".class".length());
        }
        return filePath.replace('/', '.');
    }

    public void applicationServletContainerInitializerConfig() {
        int i;
        JarFile[] jars;
        JarRepository jarRepository = this.context.getJarRepository();
        if (jarRepository != null) {
            jars = jarRepository.findJars();
            for (i = 0; i < jars.length; ++i) {
                this.scanJarForServletContainerInitializer(jars[i]);
            }
        }
        if ((jarRepository = this.context.getParent().getJarRepository()) != null) {
            jars = jarRepository.findJars();
            for (i = 0; i < jars.length; ++i) {
                this.scanJarForServletContainerInitializer(jars[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanJarForServletContainerInitializer(JarFile file) {
        JarEntry servletContainerInitializerEntry = file.getJarEntry(Globals.SERVLET_CONTAINER_INITIALIZER_SERVICE_PATH);
        String servletContainerInitializerClassName = null;
        if (servletContainerInitializerEntry != null) {
            InputStream is = null;
            try {
                is = file.getInputStream(servletContainerInitializerEntry);
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                servletContainerInitializerClassName = reader.readLine();
                int pos = servletContainerInitializerClassName.indexOf(35);
                if (pos > 0) {
                    servletContainerInitializerClassName = servletContainerInitializerClassName.substring(0, pos);
                }
                servletContainerInitializerClassName = servletContainerInitializerClassName.trim();
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("contextConfig.servletContainerInitializer", file.getName()), (Throwable)e);
                return;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
            Class<?> servletContainerInitializerClass = null;
            Class[] typesArray = null;
            if (servletContainerInitializerClassName != null) {
                try {
                    servletContainerInitializerClass = this.context.getLoader().getClassLoader().loadClass(servletContainerInitializerClassName);
                    if (servletContainerInitializerClass.isAnnotationPresent(HandlesTypes.class)) {
                        HandlesTypes handlesTypes = servletContainerInitializerClass.getAnnotation(HandlesTypes.class);
                        typesArray = handlesTypes.value();
                    }
                }
                catch (Throwable t) {
                    log.warn((Object)sm.getString("contextConfig.servletContainerInitializer", file.getName()), t);
                    return;
                }
            }
            ServletContainerInitializerInfo jarServletContainerInitializerService = new ServletContainerInitializerInfo(servletContainerInitializerClass, this.handlesTypesArray);
            this.servletContainerInitializerInfos.put(file.getName(), jarServletContainerInitializerService);
            if (typesArray != null) {
                int i;
                ArrayList<Class> handlesTypesList = new ArrayList<Class>();
                if (this.handlesTypesArray != null) {
                    for (i = 0; i < this.handlesTypesArray.length; ++i) {
                        handlesTypesList.add(this.handlesTypesArray[i]);
                    }
                }
                for (i = 0; i < typesArray.length; ++i) {
                    handlesTypesList.add(typesArray[i]);
                    this.handlesTypes.put(typesArray[i], jarServletContainerInitializerService);
                }
                this.handlesTypesArray = handlesTypesList.toArray(this.handlesTypesArray);
            }
        }
    }

    protected void contextConfig() {
        if (this.defaultContextXml == null && this.context instanceof StandardContext) {
            this.defaultContextXml = ((StandardContext)this.context).getDefaultContextXml();
        }
        if (this.defaultContextXml == null) {
            this.getDefaultContextXml();
        }
        if (!this.context.getOverride()) {
            this.processContextConfig(new File(this.getBaseDir()), this.defaultContextXml);
            this.processContextConfig(this.getConfigBase(), this.getHostConfigPath("context.xml.default"));
        }
        if (this.context.getConfigFile() != null) {
            this.processContextConfig(new File(this.context.getConfigFile()), null);
        }
        if (this.context.getJarRepository() == null) {
            this.context.setJarRepository(new ContextJarRepository());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processContextConfig(File baseDir, String resourceName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing context [" + this.context.getName() + "] configuration file " + baseDir + " " + resourceName));
        }
        InputSource source = null;
        InputStream stream = null;
        File file = baseDir;
        if (resourceName != null) {
            file = new File(baseDir, resourceName);
        }
        try {
            if (!file.exists()) {
                if (resourceName != null && (stream = this.getClass().getClassLoader().getResourceAsStream(resourceName)) != null) {
                    source = new InputSource(this.getClass().getClassLoader().getResource(resourceName).toString());
                }
            } else {
                source = new InputSource("file://" + file.getAbsolutePath());
                stream = new FileInputStream(file);
                this.context.addWatchedResource(file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            log.error((Object)sm.getString("contextConfig.contextMissing", resourceName + " " + file), (Throwable)e);
        }
        if (source == null) {
            return;
        }
        Digester digester = contextDigester;
        synchronized (digester) {
            try {
                source.setByteStream(stream);
                contextDigester.setClassLoader(this.getClass().getClassLoader());
                contextDigester.setUseContextClassLoader(false);
                contextDigester.push(this.context.getParent());
                contextDigester.push(this.context);
                contextDigester.setErrorHandler(new ContextErrorHandler());
                contextDigester.parse(source);
                if (this.parseException != null) {
                    this.ok = false;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successfully processed context [" + this.context.getName() + "] configuration file " + baseDir + " " + resourceName));
                }
            }
            catch (SAXParseException e) {
                log.error((Object)sm.getString("contextConfig.contextParse", this.context.getName()), (Throwable)e);
                log.error((Object)sm.getString("contextConfig.defaultPosition", "" + e.getLineNumber(), "" + e.getColumnNumber()));
                this.ok = false;
            }
            catch (Exception e) {
                log.error((Object)sm.getString("contextConfig.contextParse", this.context.getName()), (Throwable)e);
                this.ok = false;
            }
            finally {
                contextDigester.reset();
                this.parseException = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)sm.getString("contextConfig.contextClose"), (Throwable)e);
                }
            }
        }
    }

    protected void fixDocBase() throws IOException {
        File file;
        File canonicalAppBase;
        Host host = (Host)this.context.getParent();
        String appBase = host.getAppBase();
        boolean unpackWARs = true;
        if (host instanceof StandardHost) {
            unpackWARs = ((StandardHost)host).isUnpackWARs() && ((StandardContext)this.context).getUnpackWAR();
        }
        canonicalAppBase = (canonicalAppBase = new File(appBase)).isAbsolute() ? canonicalAppBase.getCanonicalFile() : new File(System.getProperty("catalina.base"), appBase).getCanonicalFile();
        String docBase = this.context.getDocBase();
        if (docBase == null) {
            String path = this.context.getPath();
            if (path == null) {
                return;
            }
            docBase = path.equals("") ? "ROOT" : (path.startsWith("/") ? path.substring(1).replace('/', '#') : path.replace('/', '#'));
        }
        docBase = !(file = new File(docBase)).isAbsolute() ? new File(canonicalAppBase, docBase).getPath() : file.getCanonicalPath();
        file = new File(docBase);
        String origDocBase = docBase;
        String contextPath = this.context.getPath();
        if (contextPath.equals("")) {
            contextPath = "ROOT";
        } else if (contextPath.lastIndexOf(47) > 0) {
            contextPath = "/" + contextPath.substring(1).replace('/', '#');
        }
        if (docBase.toLowerCase().endsWith(".war") && !file.isDirectory() && unpackWARs) {
            URL war = new URL("jar:" + new File(docBase).toURI().toURL() + "!/");
            docBase = ExpandWar.expand(host, war, contextPath);
            file = new File(docBase);
            docBase = file.getCanonicalPath();
            if (this.context instanceof StandardContext) {
                ((StandardContext)this.context).setOriginalDocBase(origDocBase);
            }
        } else {
            File docDir = new File(docBase);
            if (!docDir.exists()) {
                File warFile = new File(docBase + ".war");
                if (warFile.exists()) {
                    if (unpackWARs) {
                        URL war = new URL("jar:" + warFile.toURI().toURL() + "!/");
                        docBase = ExpandWar.expand(host, war, contextPath);
                        file = new File(docBase);
                        docBase = file.getCanonicalPath();
                    } else {
                        docBase = warFile.getCanonicalPath();
                    }
                }
                if (this.context instanceof StandardContext) {
                    ((StandardContext)this.context).setOriginalDocBase(origDocBase);
                }
            }
        }
        if (docBase.startsWith(canonicalAppBase.getPath() + File.separatorChar)) {
            docBase = docBase.substring(canonicalAppBase.getPath().length());
            if ((docBase = docBase.replace(File.separatorChar, '/')).startsWith("/")) {
                docBase = docBase.substring(1);
            }
        } else {
            docBase = docBase.replace(File.separatorChar, '/');
        }
        this.context.setDocBase(docBase);
    }

    protected void antiLocking() {
        if (this.context instanceof StandardContext && ((StandardContext)this.context).getAntiResourceLocking()) {
            String path;
            Host host = (Host)this.context.getParent();
            String appBase = host.getAppBase();
            String docBase = this.context.getDocBase();
            if (docBase == null) {
                return;
            }
            if (this.originalDocBase == null) {
                this.originalDocBase = docBase;
            } else {
                docBase = this.originalDocBase;
            }
            File docBaseFile = new File(docBase);
            if (!docBaseFile.isAbsolute()) {
                File file = new File(appBase);
                if (!file.isAbsolute()) {
                    file = new File(System.getProperty("catalina.base"), appBase);
                }
                docBaseFile = new File(file, docBase);
            }
            if ((path = this.context.getPath()) == null) {
                return;
            }
            docBase = path.equals("") ? "ROOT" : (path.startsWith("/") ? path.substring(1) : path);
            File file = null;
            file = docBase.toLowerCase().endsWith(".war") ? new File(System.getProperty("java.io.tmpdir"), deploymentCount++ + "-" + docBase + ".war") : new File(System.getProperty("java.io.tmpdir"), deploymentCount++ + "-" + docBase);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Anti locking context[" + this.context.getPath() + "] setting docBase to " + file));
            }
            ExpandWar.delete(file);
            if (ExpandWar.copy(docBaseFile, file)) {
                this.context.setDocBase(file.getAbsolutePath());
            }
        }
    }

    protected void init() {
        if (webDigester == null) {
            webDigester = ContextConfig.createWebDigester();
            webDigester.getParser();
        }
        if (webFragmentDigester == null) {
            webFragmentDigester = ContextConfig.createWebFragmentDigester();
            webFragmentDigester.getParser();
        }
        if (tldDigester == null) {
            tldDigester = ContextConfig.createTldDigester();
            tldDigester.getParser();
        }
        if (fragmentOrderingDigester == null) {
            fragmentOrderingDigester = ContextConfig.createFragmentOrderingDigester();
            fragmentOrderingDigester.getParser();
        }
        if (contextDigester == null) {
            contextDigester = ContextConfig.createContextDigester();
            contextDigester.getParser();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.init"));
        }
        this.context.setConfigured(false);
        this.ok = true;
        this.contextConfig();
        try {
            this.fixDocBase();
        }
        catch (IOException e) {
            log.error((Object)sm.getString("contextConfig.fixDocBase"), (Throwable)e);
        }
    }

    protected void beforeStart() {
        this.antiLocking();
    }

    protected void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.start"));
        }
        if (this.ok) {
            this.defaultWebConfig();
        }
        if (this.ok) {
            this.applicationWebConfig();
        }
        if (this.ok) {
            this.applicationServletContainerInitializerConfig();
        }
        if (this.ok && !this.context.getIgnoreAnnotations()) {
            this.createFragmentsOrder();
        }
        if (this.ok) {
            this.applicationExtraDescriptorsConfig();
        }
        if (this.ok) {
            this.applicationTldConfig();
        }
        if (log.isDebugEnabled() && this.context instanceof ContainerBase) {
            log.debug((Object)"Pipeline Configuration:");
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            Valve[] valves = null;
            if (pipeline != null) {
                valves = pipeline.getValves();
            }
            if (valves != null) {
                for (int i = 0; i < valves.length; ++i) {
                    log.debug((Object)("  " + valves[i].getInfo()));
                }
            }
            log.debug((Object)"======================");
        }
        if (this.ok) {
            this.context.setConfigured(true);
        } else {
            log.error((Object)sm.getString("contextConfig.unavailable"));
            this.context.setConfigured(false);
        }
    }

    protected void completeConfig() {
        if (this.ok && !this.context.getIgnoreAnnotations()) {
            WebAnnotationSet.loadApplicationAnnotations(this.context);
        }
        if (this.ok) {
            this.resolveServletSecurity();
        }
        if (this.ok) {
            this.validateSecurityRoles();
        }
        if (this.ok) {
            this.authenticatorConfig();
        }
        if (this.ok) {
            JarRepository jarRepository = this.context.getJarRepository();
            JarFile[] jars = jarRepository.findJars();
            for (int i = 0; i < jars.length; ++i) {
                if (jars[i].getEntry(Globals.OVERLAY_PATH) == null) continue;
                if (this.context.getResources() instanceof ProxyDirContext) {
                    ProxyDirContext resources = (ProxyDirContext)this.context.getResources();
                    JARDirContext overlay = new JARDirContext();
                    overlay.setJarFile(jars[i], Globals.OVERLAY_PATH);
                    resources.addOverlay(overlay);
                } else {
                    log.error((Object)sm.getString("contextConfig.noOverlay", jars[i].getName()));
                    this.ok = false;
                }
                this.overlays.add(jars[i].getName());
            }
        }
        if (!this.ok) {
            log.error((Object)sm.getString("contextConfig.unavailable"));
            this.context.setConfigured(false);
        }
    }

    protected void stop() {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.stop"));
        }
        Container[] children = this.context.findChildren();
        for (i = 0; i < children.length; ++i) {
            this.context.removeChild(children[i]);
        }
        SecurityConstraint[] securityConstraints = this.context.findConstraints();
        for (i = 0; i < securityConstraints.length; ++i) {
            this.context.removeConstraint(securityConstraints[i]);
        }
        ErrorPage[] errorPages = this.context.findErrorPages();
        for (i = 0; i < errorPages.length; ++i) {
            this.context.removeErrorPage(errorPages[i]);
        }
        FilterDef[] filterDefs = this.context.findFilterDefs();
        for (i = 0; i < filterDefs.length; ++i) {
            this.context.removeFilterDef(filterDefs[i]);
        }
        FilterMap[] filterMaps = this.context.findFilterMaps();
        for (i = 0; i < filterMaps.length; ++i) {
            this.context.removeFilterMap(filterMaps[i]);
        }
        String[] mimeMappings = this.context.findMimeMappings();
        for (i = 0; i < mimeMappings.length; ++i) {
            this.context.removeMimeMapping(mimeMappings[i]);
        }
        String[] parameters = this.context.findParameters();
        for (i = 0; i < parameters.length; ++i) {
            this.context.removeParameter(parameters[i]);
        }
        String[] securityRoles = this.context.findSecurityRoles();
        for (i = 0; i < securityRoles.length; ++i) {
            this.context.removeSecurityRole(securityRoles[i]);
        }
        String[] servletMappings = this.context.findServletMappings();
        for (i = 0; i < servletMappings.length; ++i) {
            this.context.removeServletMapping(servletMappings[i]);
        }
        String[] taglibs = this.context.findTaglibs();
        for (i = 0; i < taglibs.length; ++i) {
            this.context.removeTaglib(taglibs[i]);
        }
        String[] welcomeFiles = this.context.findWelcomeFiles();
        for (i = 0; i < welcomeFiles.length; ++i) {
            this.context.removeWelcomeFile(welcomeFiles[i]);
        }
        String[] wrapperLifecycles = this.context.findWrapperLifecycles();
        for (i = 0; i < wrapperLifecycles.length; ++i) {
            this.context.removeWrapperLifecycle(wrapperLifecycles[i]);
        }
        String[] wrapperListeners = this.context.findWrapperListeners();
        for (i = 0; i < wrapperListeners.length; ++i) {
            this.context.removeWrapperListener(wrapperListeners[i]);
        }
        Host host = (Host)this.context.getParent();
        String appBase = host.getAppBase();
        String docBase = this.context.getDocBase();
        if (docBase != null && this.originalDocBase != null) {
            File docBaseFile = new File(docBase);
            if (!docBaseFile.isAbsolute()) {
                docBaseFile = new File(appBase, docBase);
            }
            ExpandWar.delete(docBaseFile);
        }
        this.overlays.clear();
        this.webFragments.clear();
        this.TLDs.clear();
        this.servletContainerInitializerInfos.clear();
        this.order.clear();
        this.handlesTypesArray = null;
        this.handlesTypes.clear();
        this.ok = true;
    }

    protected void destroy() {
        String workDir;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.destroy"));
        }
        if ((workDir = ((StandardContext)this.context).getWorkPath()) != null) {
            ExpandWar.delete(new File(workDir));
        }
    }

    protected void resolveServletSecurity() {
        Container[] wrappers = this.context.findChildren();
        for (int i = 0; i < wrappers.length; ++i) {
            SecurityConstraint[] constraints;
            Wrapper wrapper = (Wrapper)wrappers[i];
            ServletSecurityElement servletSecurity = wrapper.getServletSecurity();
            if (servletSecurity == null) continue;
            ArrayList<String> methodOmissions = new ArrayList<String>();
            boolean classPA = servletSecurity.getEmptyRoleSemantic().equals((Object)ServletSecurity.EmptyRoleSemantic.PERMIT);
            boolean classDA = servletSecurity.getEmptyRoleSemantic().equals((Object)ServletSecurity.EmptyRoleSemantic.DENY);
            boolean classTP = servletSecurity.getTransportGuarantee().equals((Object)ServletSecurity.TransportGuarantee.CONFIDENTIAL);
            String[] classRA = servletSecurity.getRolesAllowed();
            Collection httpMethodConstraints = servletSecurity.getHttpMethodConstraints();
            if (httpMethodConstraints != null && httpMethodConstraints.size() > 0) {
                for (HttpMethodConstraintElement httpMethodConstraint : httpMethodConstraints) {
                    SecurityConstraint[] constraints2;
                    methodOmissions.add(httpMethodConstraint.getMethodName());
                    boolean methodPA = httpMethodConstraint.getEmptyRoleSemantic().equals((Object)ServletSecurity.EmptyRoleSemantic.PERMIT);
                    boolean methodDA = httpMethodConstraint.getEmptyRoleSemantic().equals((Object)ServletSecurity.EmptyRoleSemantic.DENY);
                    boolean methodTP = httpMethodConstraint.getTransportGuarantee().equals((Object)ServletSecurity.TransportGuarantee.CONFIDENTIAL);
                    String[] methodRA = httpMethodConstraint.getRolesAllowed();
                    if (!methodDA && !methodTP && (methodRA == null || methodRA.length <= 0)) continue;
                    SecurityConstraint constraint = new SecurityConstraint();
                    if (methodDA) {
                        constraint.setAuthConstraint(true);
                    }
                    if (methodPA) {
                        constraint.addAuthRole("*");
                    }
                    if (methodRA != null) {
                        for (String role : methodRA) {
                            constraint.addAuthRole(role);
                        }
                    }
                    if (methodTP) {
                        constraint.setUserConstraint("CONFIDENTIAL");
                    }
                    SecurityCollection collection = new SecurityCollection();
                    collection.addMethod(httpMethodConstraint.getMethodName());
                    String[] urlPatterns = wrapper.findMappings();
                    HashSet<String> servletSecurityPatterns = new HashSet<String>();
                    for (String urlPattern : urlPatterns) {
                        servletSecurityPatterns.add(urlPattern);
                    }
                    for (SecurityConstraint constraint2 : constraints2 = this.context.findConstraints()) {
                        for (SecurityCollection collection2 : constraint2.findCollections()) {
                            for (String urlPattern : collection2.findPatterns()) {
                                if (!servletSecurityPatterns.contains(urlPattern)) continue;
                                servletSecurityPatterns.remove(urlPattern);
                            }
                        }
                    }
                    for (String urlPattern : servletSecurityPatterns) {
                        collection.addPattern(urlPattern);
                    }
                    constraint.addCollection(collection);
                    this.context.addConstraint(constraint);
                }
            }
            if (!classDA && !classTP && (classRA == null || classRA.length <= 0)) continue;
            SecurityConstraint constraint = new SecurityConstraint();
            if (classPA) {
                constraint.addAuthRole("*");
            }
            if (classDA) {
                constraint.setAuthConstraint(true);
            }
            if (classRA != null) {
                for (String role : classRA) {
                    constraint.addAuthRole(role);
                }
            }
            if (classTP) {
                constraint.setUserConstraint("CONFIDENTIAL");
            }
            SecurityCollection collection = new SecurityCollection();
            String[] urlPatterns = wrapper.findMappings();
            HashSet<String> servletSecurityPatterns = new HashSet<String>();
            for (String urlPattern : urlPatterns) {
                servletSecurityPatterns.add(urlPattern);
            }
            for (SecurityConstraint constraint2 : constraints = this.context.findConstraints()) {
                for (SecurityCollection collection2 : constraint2.findCollections()) {
                    for (String urlPattern : collection2.findPatterns()) {
                        if (!servletSecurityPatterns.contains(urlPattern)) continue;
                        servletSecurityPatterns.remove(urlPattern);
                    }
                }
            }
            for (String urlPattern : servletSecurityPatterns) {
                collection.addPattern(urlPattern);
            }
            for (String methodOmission : methodOmissions) {
                collection.addMethodOmission(methodOmission);
            }
            constraint.addCollection(collection);
            this.context.addConstraint(constraint);
        }
    }

    protected void validateSecurityRoles() {
        SecurityConstraint[] constraints = this.context.findConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            String[] roles = constraints[i].findAuthRoles();
            for (int j = 0; j < roles.length; ++j) {
                if ("*".equals(roles[j]) || this.context.findSecurityRole(roles[j])) continue;
                log.info((Object)sm.getString("contextConfig.role.auth", roles[j]));
                this.context.addSecurityRole(roles[j]);
            }
        }
        Container[] wrappers = this.context.findChildren();
        for (int i = 0; i < wrappers.length; ++i) {
            Wrapper wrapper = (Wrapper)wrappers[i];
            String runAs = wrapper.getRunAs();
            if (runAs != null && !this.context.findSecurityRole(runAs)) {
                log.info((Object)sm.getString("contextConfig.role.runas", runAs));
                this.context.addSecurityRole(runAs);
            }
            String[] names = wrapper.findSecurityReferences();
            for (int j = 0; j < names.length; ++j) {
                String link = wrapper.findSecurityReference(names[j]);
                if (link == null || this.context.findSecurityRole(link)) continue;
                log.info((Object)sm.getString("contextConfig.role.link", link));
                this.context.addSecurityRole(link);
            }
        }
    }

    protected File getConfigBase() {
        File configBase = new File(System.getProperty("catalina.base"), "conf");
        if (!configBase.exists()) {
            return null;
        }
        return configBase;
    }

    protected String getHostConfigPath(String resourceName) {
        StringBuilder result = new StringBuilder();
        Context host = null;
        Container engine = null;
        for (Container container = this.context; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = container;
            }
            if (!(container instanceof Engine)) continue;
            engine = container;
        }
        if (engine != null) {
            result.append(engine.getName()).append('/');
        }
        if (host != null) {
            result.append(host.getName()).append('/');
        }
        result.append(resourceName);
        return result.toString();
    }

    protected class ServletContainerInitializerInfo {
        protected Class<?> servletContainerInitializer = null;
        protected Class<?>[] interestClasses = null;
        protected HashSet<Class<?>> startupNotifySet = new HashSet();

        protected ServletContainerInitializerInfo(Class<?> servletContainerInitializer, Class<?>[] interestClasses) {
            this.servletContainerInitializer = servletContainerInitializer;
            this.interestClasses = interestClasses;
        }

        public Class<?> getServletContainerInitializer() {
            return this.servletContainerInitializer;
        }

        public Class<?>[] getInterestClasses() {
            return this.interestClasses;
        }

        protected void addStartupNotifyClass(Class<?> clazz) {
            this.startupNotifySet.add(clazz);
        }

        public Set<Class<?>> getStartupNotifySet() {
            return this.startupNotifySet;
        }
    }

    protected class ContextErrorHandler
    implements ErrorHandler {
        protected ContextErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) {
            ContextConfig.this.parseException = exception;
        }

        @Override
        public void fatalError(SAXParseException exception) {
            ContextConfig.this.parseException = exception;
        }

        @Override
        public void warning(SAXParseException exception) {
            ContextConfig.this.parseException = exception;
        }
    }
}

