/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.apache.catalina.deploy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class WebOrdering implements Serializable {

    private static final long serialVersionUID = 5603203103871892211L;

    protected String jar = null;
    protected String name = null;
    protected List<String> after = new ArrayList<String>();
    protected List<String> before = new ArrayList<String>();
    protected boolean afterOthers = false;
    protected boolean beforeOthers = false;
    
    public String getName() {
        return name;
    }
    
    public void setName(String name) {
        this.name = name;
    }

    public List<String> getAfter() {
        return after;
    }

    public void addAfter(String name) {
        after.add(name);
    }

    public List<String> getBefore() {
        return before;
    }

    public void addBefore(String name) {
        before.add(name);
    }

    public String getJar() {
        return jar;
    }
    
    public void setJar(String jar) {
        this.jar = jar;
    }
    
    public boolean isAfterOthers() {
        return afterOthers;
    }
    
    public void setAfterOthers(boolean afterOthers) {
        this.afterOthers = afterOthers;
    }
    
    public boolean isBeforeOthers() {
        return beforeOthers;
    }
    
    public void setBeforeOthers(boolean beforeOthers) {
        this.beforeOthers = beforeOthers;
    }

}
