/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;

public class WebappLoader
implements Lifecycle,
Loader,
PropertyChangeListener,
MBeanRegistration {
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.loader");
    private static boolean first = true;
    private WebappClassLoader classLoader = null;
    private Container container = null;
    private boolean delegate = false;
    private static final String info = "org.apache.catalina.loader.WebappLoader/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private String loaderClass = "org.apache.catalina.loader.WebappClassLoader";
    private ClassLoader parentClassLoader = null;
    private boolean reloadable = false;
    private boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean initialized = false;
    private static Logger log = Logger.getLogger(WebappLoader.class);
    private ObjectName oname;
    private MBeanServer mserver;
    private String domain;
    private ObjectName controller;

    public WebappLoader() {
        this(null);
    }

    public WebappLoader(ClassLoader parent) {
        this.parentClassLoader = parent;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
        if (this.container != null && this.container instanceof Context) {
            this.setReloadable(((Context)this.container).getReloadable());
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    @Override
    public boolean getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", new Boolean(oldDelegate), new Boolean(this.delegate));
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass(String loaderClass) {
        this.loaderClass = loaderClass;
    }

    @Override
    public boolean getReloadable() {
        return this.reloadable;
    }

    @Override
    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", new Boolean(oldReloadable), new Boolean(this.reloadable));
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void addRepository(String repository) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.addRepository", repository));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backgroundProcess() {
        if (this.reloadable && this.modified()) {
            try {
                Thread.currentThread().setContextClassLoader(WebappLoader.class.getClassLoader());
                if (this.container instanceof StandardContext) {
                    ((StandardContext)this.container).reload();
                }
            }
            finally {
                if (this.container.getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(this.container.getLoader().getClassLoader());
                }
            }
        }
    }

    @Override
    public String[] findRepositories() {
        return null;
    }

    @Override
    public String[] findLoaderRepositories() {
        return null;
    }

    @Override
    public boolean modified() {
        return false;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebappLoader[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void init() {
        this.initialized = true;
        if (this.oname == null && this.container instanceof StandardContext) {
            try {
                StandardContext ctx = (StandardContext)this.container;
                Engine eng = (Engine)ctx.getParent().getParent();
                String path = ctx.getPath();
                if (path.equals("")) {
                    path = "/";
                }
                this.oname = new ObjectName(ctx.getEngineName() + ":type=Loader,path=" + path + ",host=" + ctx.getParent().getName());
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
                this.controller = this.oname;
            }
            catch (Exception e) {
                log.error((Object)"Error registering loader", (Throwable)e);
            }
        }
        if (this.container == null) {
            // empty if block
        }
    }

    public void destroy() {
        if (this.controller == this.oname) {
            Registry.getRegistry(null, null).unregisterComponent(this.oname);
            this.oname = null;
        }
        this.initialized = false;
    }

    @Override
    public void start() throws LifecycleException {
        if (!this.initialized) {
            this.init();
        }
        if (this.started) {
            throw new LifecycleException(sm.getString("webappLoader.alreadyStarted"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.starting"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.container.getResources() == null) {
            log.info((Object)("No resources for " + this.container));
            return;
        }
        DirContextURLStreamHandlerFactory streamHandlerFactory = new DirContextURLStreamHandlerFactory();
        if (first) {
            first = false;
            try {
                URL.setURLStreamHandlerFactory(streamHandlerFactory);
            }
            catch (Exception e) {
                log.error((Object)"Error registering jndi stream handler", (Throwable)e);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            this.classLoader = this.createClassLoader();
            this.classLoader.setDelegate(this.delegate);
            if (this.container instanceof StandardContext) {
                this.classLoader.setAntiJARLocking(((StandardContext)this.container).getAntiJARLocking());
            }
            if (!(this.container instanceof Context)) {
                throw new IllegalStateException("This loader only supports a Context");
            }
            ServletContext servletContext = ((Context)this.container).getServletContext();
            if (servletContext == null) {
                throw new IllegalStateException("No servlet context available");
            }
            File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            if (workDir == null) {
                log.info((Object)("No work dir for " + servletContext));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("webappLoader.deploy", workDir.getAbsolutePath()));
            }
            this.classLoader.setWorkDir(workDir);
            this.classLoader.setRepository(this.container.getJarRepository());
            this.setPermissions();
            if (this.classLoader instanceof Lifecycle) {
                this.classLoader.start();
            }
            DirContextURLStreamHandler.bind(this.classLoader, this.container.getResources());
            StandardContext ctx = (StandardContext)this.container;
            Engine eng = (Engine)ctx.getParent().getParent();
            String path = ctx.getPath();
            if (path.equals("")) {
                path = "/";
            }
            ObjectName cloname = new ObjectName(ctx.getEngineName() + ":type=WebappClassLoader,path=" + path + ",host=" + ctx.getParent().getName());
            Registry.getRegistry(null, null).registerComponent((Object)this.classLoader, cloname, null);
        }
        catch (Throwable t) {
            log.error((Object)"LifecycleException ", t);
            throw new LifecycleException("start: ", t);
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("webappLoader.notStarted"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.stopping"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.container instanceof Context) {
            ServletContext servletContext = ((Context)this.container).getServletContext();
            servletContext.removeAttribute("org.apache.catalina.jsp_classpath");
        }
        if (this.classLoader instanceof Lifecycle) {
            this.classLoader.stop();
        }
        DirContextURLStreamHandler.unbind(this.classLoader);
        try {
            StandardContext ctx = (StandardContext)this.container;
            Engine eng = (Engine)ctx.getParent().getParent();
            String path = ctx.getPath();
            if (path.equals("")) {
                path = "/";
            }
            ObjectName cloname = new ObjectName(ctx.getEngineName() + ":type=WebappClassLoader,path=" + path + ",host=" + ctx.getParent().getName());
            Registry.getRegistry(null, null).unregisterComponent(cloname);
        }
        catch (Throwable t) {
            log.error((Object)"LifecycleException ", t);
        }
        this.classLoader = null;
        this.destroy();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        Context context = (Context)event.getSource();
        if (event.getPropertyName().equals("reloadable")) {
            try {
                this.setReloadable((Boolean)event.getNewValue());
            }
            catch (NumberFormatException e) {
                log.error((Object)sm.getString("webappLoader.reloadable", event.getNewValue().toString()));
            }
        }
    }

    private WebappClassLoader createClassLoader() throws Exception {
        Class<?> clazz = Class.forName(this.loaderClass);
        WebappClassLoader classLoader = null;
        if (this.parentClassLoader == null) {
            this.parentClassLoader = this.container.getParentClassLoader();
        }
        Class[] argTypes = new Class[]{ClassLoader.class};
        Object[] args = new Object[]{this.parentClassLoader};
        Constructor<?> constr = clazz.getConstructor(argTypes);
        classLoader = (WebappClassLoader)constr.newInstance(args);
        return classLoader;
    }

    private void setPermissions() {
        block20: {
            if (!Globals.IS_SECURITY_ENABLED) {
                return;
            }
            if (!(this.container instanceof Context)) {
                return;
            }
            ServletContext servletContext = ((Context)this.container).getServletContext();
            File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            if (workDir != null) {
                try {
                    String workDirPath = workDir.getCanonicalPath();
                    this.classLoader.addPermission(new FilePermission(workDirPath, "read,write"));
                    this.classLoader.addPermission(new FilePermission(workDirPath + File.separator + "-", "read,write,delete"));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                String path;
                URL rootURL = servletContext.getResource("/");
                this.classLoader.addPermission(rootURL);
                String contextRoot = servletContext.getRealPath("/");
                if (contextRoot != null) {
                    try {
                        contextRoot = new File(contextRoot).getCanonicalPath();
                        this.classLoader.addPermission(contextRoot);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                URL classesURL = servletContext.getResource("/WEB-INF/classes/");
                this.classLoader.addPermission(classesURL);
                URL libURL = servletContext.getResource("/WEB-INF/lib/");
                this.classLoader.addPermission(libURL);
                if (contextRoot != null) {
                    if (libURL != null) {
                        File rootDir = new File(contextRoot);
                        File libDir = new File(rootDir, "WEB-INF/lib/");
                        try {
                            String path2 = libDir.getCanonicalPath();
                            this.classLoader.addPermission(path2);
                        }
                        catch (IOException e) {}
                    }
                    break block20;
                }
                if (workDir == null) break block20;
                if (libURL != null) {
                    File libDir = new File(workDir, "WEB-INF/lib/");
                    try {
                        path = libDir.getCanonicalPath();
                        this.classLoader.addPermission(path);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (classesURL != null) {
                    File classesDir = new File(workDir, "WEB-INF/classes/");
                    try {
                        path = classesDir.getCanonicalPath();
                        this.classLoader.addPermission(path);
                    }
                    catch (IOException e) {}
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }
}

