/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.annotation.security.RunAs;
import javax.annotation.security.TransportProtected;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceEnvRef;
import org.apache.catalina.deploy.ContextService;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.MessageDestinationRef;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;

public class WebAnnotationSet {
    public static void loadApplicationAnnotations(Context context) {
        WebAnnotationSet.loadApplicationListenerAnnotations(context);
        WebAnnotationSet.loadApplicationFilterAnnotations(context);
        WebAnnotationSet.loadApplicationServletAnnotations(context);
    }

    protected static void loadApplicationListenerAnnotations(Context context) {
        String[] applicationListeners = context.findApplicationListeners();
        for (int i = 0; i < applicationListeners.length; ++i) {
            WebAnnotationSet.loadClassAnnotation(context, applicationListeners[i]);
        }
    }

    protected static void loadApplicationFilterAnnotations(Context context) {
        FilterDef[] filterDefs = context.findFilterDefs();
        for (int i = 0; i < filterDefs.length; ++i) {
            WebAnnotationSet.loadClassAnnotation(context, filterDefs[i].getFilterClass());
        }
    }

    protected static void loadApplicationServletAnnotations(Context context) {
        ClassLoader classLoader = context.getLoader().getClassLoader();
        StandardWrapper wrapper = null;
        Class<?> classClass = null;
        Container[] children = context.findChildren();
        for (int i = 0; i < children.length; ++i) {
            String[] urlPatterns;
            TransportProtected annotation;
            if (!(children[i] instanceof StandardWrapper) || (wrapper = (StandardWrapper)children[i]).getServletClass() == null) continue;
            try {
                classClass = classLoader.loadClass(wrapper.getServletClass());
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
            if (classClass == null) continue;
            WebAnnotationSet.loadClassAnnotation(context, wrapper.getServletClass());
            boolean classPA = false;
            boolean classTP = false;
            String[] classRA = null;
            ArrayList<String> methodOmissions = new ArrayList<String>();
            if (classClass.isAnnotationPresent(PermitAll.class)) {
                classPA = true;
            }
            if (classClass.isAnnotationPresent(TransportProtected.class)) {
                annotation = classClass.getAnnotation(TransportProtected.class);
                classTP = annotation.value();
            }
            if (classClass.isAnnotationPresent(RolesAllowed.class)) {
                annotation = classClass.getAnnotation(RolesAllowed.class);
                classRA = annotation.value();
            }
            if (classClass.isAnnotationPresent(RunAs.class)) {
                annotation = classClass.getAnnotation(RunAs.class);
                wrapper.setRunAs(annotation.value());
            }
            if (HttpServlet.class.isAssignableFrom(classClass)) {
                Method[] methods = null;
                final Class<?> classClass2 = classClass;
                methods = Globals.IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                    @Override
                    public Method[] run() {
                        return classClass2.getDeclaredMethods();
                    }
                }) : classClass.getDeclaredMethods();
                for (Method method : methods) {
                    String[] urlPatterns2;
                    TransportProtected annotation2;
                    if (method.getParameterTypes().length != 2 || method.getParameterTypes()[0] != HttpServletRequest.class || method.getParameterTypes()[1] != HttpServletResponse.class) continue;
                    String methodName = null;
                    if (method.getName().startsWith("do")) {
                        methodName = method.getName().substring(2).toUpperCase();
                    }
                    if (methodName == null) continue;
                    boolean methodAnnotation = false;
                    boolean methodPA = false;
                    boolean methodDA = false;
                    boolean methodTP = false;
                    String[] methodRA = null;
                    if (method.isAnnotationPresent(PermitAll.class)) {
                        methodPA = true;
                        methodAnnotation = true;
                    }
                    if (method.isAnnotationPresent(DenyAll.class)) {
                        methodDA = true;
                        methodAnnotation = true;
                    }
                    if (method.isAnnotationPresent(TransportProtected.class)) {
                        annotation2 = method.getAnnotation(TransportProtected.class);
                        methodTP = annotation2.value();
                        methodAnnotation = true;
                    }
                    if (method.isAnnotationPresent(RolesAllowed.class)) {
                        annotation2 = method.getAnnotation(RolesAllowed.class);
                        methodRA = annotation2.value();
                        methodAnnotation = true;
                    }
                    if (!methodAnnotation) continue;
                    methodOmissions.add(methodName);
                    SecurityConstraint constraint = new SecurityConstraint();
                    if (methodDA) {
                        constraint.setAuthConstraint(true);
                    }
                    if (methodPA) {
                        constraint.addAuthRole("*");
                    }
                    if (methodRA != null) {
                        for (String role : methodRA) {
                            constraint.addAuthRole(role);
                        }
                    }
                    if (methodTP) {
                        constraint.setUserConstraint("CONFIDENTIAL");
                    }
                    SecurityCollection collection = new SecurityCollection();
                    collection.addMethod(methodName);
                    for (String urlPattern : urlPatterns2 = wrapper.findMappings()) {
                        collection.addPattern(urlPattern);
                    }
                    constraint.addCollection(collection);
                    context.addConstraint(constraint);
                }
            }
            if (!classPA && !classTP && classRA == null) continue;
            SecurityConstraint constraint = new SecurityConstraint();
            if (classPA) {
                constraint.addAuthRole("*");
            }
            if (classRA != null) {
                for (String role : classRA) {
                    constraint.addAuthRole(role);
                }
            }
            if (classTP) {
                constraint.setUserConstraint("CONFIDENTIAL");
            }
            SecurityCollection collection = new SecurityCollection();
            for (String urlPattern : urlPatterns = wrapper.findMappings()) {
                collection.addPattern(urlPattern);
            }
            for (String methodOmission : methodOmissions) {
                collection.addMethodOmission(methodOmission);
            }
            constraint.addCollection(collection);
            context.addConstraint(constraint);
        }
    }

    protected static void loadClassAnnotation(Context context, String fileString) {
        int i;
        Resource annotation;
        ClassLoader classLoader = context.getLoader().getClassLoader();
        Class<?> classClass = null;
        try {
            classClass = classLoader.loadClass(fileString);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        if (classClass == null) {
            return;
        }
        if (classClass.isAnnotationPresent(Resource.class)) {
            annotation = classClass.getAnnotation(Resource.class);
            WebAnnotationSet.addResource(context, annotation);
        }
        if (classClass.isAnnotationPresent(Resources.class)) {
            annotation = classClass.getAnnotation(Resources.class);
            for (i = 0; annotation.value() != null && i < annotation.value().length; ++i) {
                WebAnnotationSet.addResource(context, annotation.value()[i]);
            }
        }
        if (classClass.isAnnotationPresent(DeclareRoles.class)) {
            annotation = classClass.getAnnotation(DeclareRoles.class);
            for (i = 0; annotation.value() != null && i < annotation.value().length; ++i) {
                context.addSecurityRole(annotation.value()[i]);
            }
        }
    }

    protected static void addResource(Context context, Resource annotation) {
        if (annotation.type().getCanonicalName().equals("java.lang.String") || annotation.type().getCanonicalName().equals("java.lang.Character") || annotation.type().getCanonicalName().equals("java.lang.Integer") || annotation.type().getCanonicalName().equals("java.lang.Boolean") || annotation.type().getCanonicalName().equals("java.lang.Double") || annotation.type().getCanonicalName().equals("java.lang.Byte") || annotation.type().getCanonicalName().equals("java.lang.Short") || annotation.type().getCanonicalName().equals("java.lang.Long") || annotation.type().getCanonicalName().equals("java.lang.Float")) {
            ContextEnvironment resource = new ContextEnvironment();
            resource.setName(annotation.name());
            resource.setType(annotation.type().getCanonicalName());
            resource.setDescription(annotation.description());
            resource.setValue(annotation.mappedName());
            context.getNamingResources().addEnvironment(resource);
        } else if (annotation.type().getCanonicalName().equals("javax.xml.rpc.Service")) {
            ContextService service = new ContextService();
            service.setName(annotation.name());
            service.setWsdlfile(annotation.mappedName());
            service.setType(annotation.type().getCanonicalName());
            service.setDescription(annotation.description());
            context.getNamingResources().addService(service);
        } else if (annotation.type().getCanonicalName().equals("javax.sql.DataSource") || annotation.type().getCanonicalName().equals("javax.jms.ConnectionFactory") || annotation.type().getCanonicalName().equals("javax.jms.QueueConnectionFactory") || annotation.type().getCanonicalName().equals("javax.jms.TopicConnectionFactory") || annotation.type().getCanonicalName().equals("javax.mail.Session") || annotation.type().getCanonicalName().equals("java.net.URL") || annotation.type().getCanonicalName().equals("javax.resource.cci.ConnectionFactory") || annotation.type().getCanonicalName().equals("org.omg.CORBA_2_3.ORB") || annotation.type().getCanonicalName().endsWith("ConnectionFactory")) {
            ContextResource resource = new ContextResource();
            resource.setName(annotation.name());
            resource.setType(annotation.type().getCanonicalName());
            if (annotation.authenticationType() == Resource.AuthenticationType.CONTAINER) {
                resource.setAuth("Container");
            } else if (annotation.authenticationType() == Resource.AuthenticationType.APPLICATION) {
                resource.setAuth("Application");
            }
            resource.setScope(annotation.shareable() ? "Shareable" : "Unshareable");
            resource.setProperty("mappedName", annotation.mappedName());
            resource.setDescription(annotation.description());
            context.getNamingResources().addResource(resource);
        } else if (annotation.type().getCanonicalName().equals("javax.jms.Queue") || annotation.type().getCanonicalName().equals("javax.jms.Topic")) {
            MessageDestinationRef resource = new MessageDestinationRef();
            resource.setName(annotation.name());
            resource.setType(annotation.type().getCanonicalName());
            resource.setUsage(annotation.mappedName());
            resource.setDescription(annotation.description());
            context.getNamingResources().addMessageDestinationRef(resource);
        } else {
            if (annotation.type().getCanonicalName().equals("javax.resource.cci.InteractionSpec") || !annotation.type().getCanonicalName().equals("javax.transaction.UserTransaction")) {
                // empty if block
            }
            ContextResourceEnvRef resource = new ContextResourceEnvRef();
            resource.setName(annotation.name());
            resource.setType(annotation.type().getCanonicalName());
            resource.setProperty("mappedName", annotation.mappedName());
            resource.setDescription(annotation.description());
            context.getNamingResources().addResourceEnvRef(resource);
        }
    }
}

