/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Enumeration;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class ResourceRef
extends Reference {
    public static final String DEFAULT_FACTORY = "org.apache.naming.factory.ResourceFactory";
    public static final String DESCRIPTION = "description";
    public static final String SCOPE = "scope";
    public static final String AUTH = "auth";

    public ResourceRef(String resourceClass, String description, String scope, String auth) {
        this(resourceClass, description, scope, auth, null, null);
    }

    public ResourceRef(String resourceClass, String description, String scope, String auth, String factory, String factoryLocation) {
        super(resourceClass, factory, factoryLocation);
        StringRefAddr refAddr = null;
        if (description != null) {
            refAddr = new StringRefAddr(DESCRIPTION, description);
            this.add(refAddr);
        }
        if (scope != null) {
            refAddr = new StringRefAddr(SCOPE, scope);
            this.add(refAddr);
        }
        if (auth != null) {
            refAddr = new StringRefAddr(AUTH, auth);
            this.add(refAddr);
        }
    }

    @Override
    public String getFactoryClassName() {
        String factory = super.getFactoryClassName();
        if (factory != null) {
            return factory;
        }
        factory = System.getProperty("java.naming.factory.object");
        if (factory != null) {
            return null;
        }
        return DEFAULT_FACTORY;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("ResourceRef[");
        sb.append("className=");
        sb.append(this.getClassName());
        sb.append(",factoryClassLocation=");
        sb.append(this.getFactoryClassLocation());
        sb.append(",factoryClassName=");
        sb.append(this.getFactoryClassName());
        Enumeration<RefAddr> refAddrs = this.getAll();
        while (refAddrs.hasMoreElements()) {
            RefAddr refAddr = refAddrs.nextElement();
            sb.append(",{type=");
            sb.append(refAddr.getType());
            sb.append(",content=");
            sb.append(refAddr.getContent());
            sb.append("}");
        }
        sb.append("]");
        return sb.toString();
    }
}

