/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager.host;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.manager.host.HostManagerServlet;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ServerInfo;

public final class HTMLHostManagerServlet
extends HostManagerServlet {
    private static final String HOSTS_HEADER_SECTION = "<table width=\"100%\" cellspacing=\"0\" class=\"tableStyle\" >\n<thead><th colspan=\"5\">{0}</th></thead>\n<tr class=\"UnsortableTableHeader\">\n <td>{0}</td>\n <td>{1}</td>\n <td>{2}</td>\n</tr>\n";
    private static final String HOSTS_ROW_DETAILS_SECTION = "<tr class=\"{2}\">\n <td class=\"first\"><a href=\"http://{0}\">{0}</a></td>\n <td>{1}</td>\n";
    private static final String MANAGER_HOST_ROW_BUTTON_SECTION = " <td>\n  &nbsp;{1}&nbsp;\n  &nbsp;{3}&nbsp;\n  &nbsp;{5}&nbsp;\n </td>\n</tr>\n";
    private static final String HOSTS_ROW_BUTTON_SECTION = " <td NOWRAP>\n  &nbsp;<a href=\"{0}\" onclick=\"return(confirm(''{1} {6}\\n\\nAre you sure?''))\">{1}</a>&nbsp;\n  &nbsp;<a href=\"{2}\" onclick=\"return(confirm(''{3} {6}\\n\\nAre you sure?''))\">{3}</a>&nbsp;\n  &nbsp;<a href=\"{4}\" onclick=\"return(confirm(''{5} {6}\\n\\nAre you sure?''))\">{5}</a>&nbsp;\n </td>\n</tr>\n";
    private static final String ADD_SECTION_START = "</table>\n<table width=\"100%\" cellspacing=\"0\" class=\"tableStyle\">\n<tr>\n <th colspan=\"2\">{0}</th>\n</tr>\n<tbody>\n <tr class=\"UnsortableTableHeader\"><td>{1}</td></tr>\n<tr class=\"oddRow\">\n <td colspan=\"2\" class=\"first\">\n<form method=\"get\" action=\"{2}\">\n<table cellpadding=\"3\" cellspacing=\"0\" style=\"border:0px;\"><tbody>\n<tr>\n <td style=\"border:0px;\">{3}</td>\n <td style=\"border:0px;\"><input type=\"text\" name=\"name\" size=\"20\"></td>\n</tr>\n<tr>\n <td style=\"border:0px;\">{4}</td>\n <td style=\"border:0px;\"><input type=\"text\" name=\"aliases\" size=\"64\"></td>\n</tr>\n<tr>\n <td style=\"border:0px;\">{5}</td>\n <td style=\"border:0px;\"><input type=\"text\" name=\"appBase\" size=\"64\"></td>\n</tr>\n";
    private static final String ADD_SECTION_BOOLEAN = "<tr>\n <td style=\"border:0px;\">{0}</small></td>\n <td style=\"border:0px;\"><input type=\"checkbox\" name=\"{1}\" {2}></td>\n</tr>\n";
    private static final String ADD_SECTION_END = "<tr>\n <td style=\"border:0px;\">&nbsp;</td>\n <td style=\"border:0px;\"><input type=\"submit\" value=\"{0}\" class=\"buttonmed\"></td>\n</tr>\n</tbody></table>\n</form>\n</td>\n</tr>\n</table>\n\n";

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String command = request.getPathInfo();
        String name = request.getParameter("name");
        response.setContentType("text/html; charset=utf-8");
        String message = "";
        if (command != null) {
            if (command.equals("/add")) {
                message = this.add(request, name);
            } else if (command.equals("/remove")) {
                message = this.remove(name);
            } else if (!command.equals("/list")) {
                message = command.equals("/start") ? this.start(name) : (command.equals("/stop") ? this.stop(name) : sm.getString("hostManagerServlet.unknownCommand", command));
            }
        }
        this.list(request, response, message);
    }

    protected String add(HttpServletRequest request, String name) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.add(request, printWriter, name, true);
        return stringWriter.toString();
    }

    protected String remove(String name) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.remove(printWriter, name);
        return stringWriter.toString();
    }

    protected String start(String name) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.start(printWriter, name);
        return stringWriter.toString();
    }

    protected String stop(String name) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        super.stop(printWriter, name);
        return stringWriter.toString();
    }

    public void list(HttpServletRequest request, HttpServletResponse response, String message) throws IOException {
        PrintWriter writer = response.getWriter();
        Object[] args = new Object[]{request.getContextPath()};
        writer.print(MessageFormat.format("<html>\n<head>\n<link href=\"{0}/jbossweb.css\" rel=\"stylesheet\" type=\"text/css\" />\n", args));
        args = new Object[]{request.getContextPath(), sm.getString("htmlHostManagerServlet.title")};
        writer.print(MessageFormat.format("<title>{1}</title>\n</head>\n\n<body>\n\n<div class=\"wrapper\">\n  <div class=\"header\">\n    <div class=\"floatleft\"><a href=\"list\"><img src=\"{0}/images/hdr_hdrtitle.gif\" border=\"0\"></a></div>\n    <div class=\"floatright\"><a href=\"http://www.jboss.com/\"><img src=\"{0}/images/hdr_jbosslogo.gif\" alt=\"JBoss, a division of Red Hat\" border=\"0\"></a><a href=\"http://www.jboss.org\"><img src=\"{0}/images/hdr_jbossorglogo.gif\" alt=\"JBoss.org - Community driven.\" border=\"0\" /></a></div>\n  </div>\n    <div class=\"container\">\n\n", args));
        args = new Object[]{sm.getString("htmlHostManagerServlet.manager"), response.encodeURL(request.getContextPath() + "/html/list"), sm.getString("htmlHostManagerServlet.list"), response.encodeURL(request.getContextPath() + "/" + sm.getString("htmlHostManagerServlet.helpHtmlManagerFile")), sm.getString("htmlHostManagerServlet.helpHtmlManager"), response.encodeURL(request.getContextPath() + "/" + sm.getString("htmlHostManagerServlet.helpManagerFile")), sm.getString("htmlHostManagerServlet.helpManager"), response.encodeURL("/manager/status"), sm.getString("statusServlet.title")};
        writer.print(MessageFormat.format("<div class=\"leftcol\"><dl>\n  <dt>Manager</dt>    <dd><a href=\"{1}\">{2}</a></dd>    <dd><a href=\"{3}\">{4}</a></dd>    <dd><a href=\"{5}\">{6}</a></dd>    <dd><a href=\"{7}\">{8}</a></dd></dl></div>\n<div class=\"maincol\">\n", args));
        args = new Object[3];
        args[0] = sm.getString("htmlHostManagerServlet.messageLabel");
        args[1] = message == null || message.length() == 0 ? "OK" : RequestUtil.filter(message);
        writer.print(MessageFormat.format("<table border=\"0\" class=\"message\"><tbody>\n <tr>\n  <td width=\"10%\"><strong>{0}</strong></td>  <td>{1}</td>\n </tr>\n</tbody></table>\n\n", args));
        args = new Object[]{sm.getString("htmlHostManagerServlet.hostName"), sm.getString("htmlHostManagerServlet.hostAliases"), sm.getString("htmlHostManagerServlet.hostTasks")};
        writer.print(MessageFormat.format(HOSTS_HEADER_SECTION, args));
        Container[] children = this.engine.findChildren();
        String[] hostNames = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            hostNames[i] = children[i].getName();
        }
        TreeMap<String, String> sortedHostNamesMap = new TreeMap<String, String>();
        for (int i = 0; i < hostNames.length; ++i) {
            String displayPath = hostNames[i];
            sortedHostNamesMap.put(displayPath, hostNames[i]);
        }
        String hostsStart = sm.getString("htmlHostManagerServlet.hostsStart");
        String hostsStop = sm.getString("htmlHostManagerServlet.hostsStop");
        String hostsRemove = sm.getString("htmlHostManagerServlet.hostsRemove");
        Iterator iterator = sortedHostNamesMap.entrySet().iterator();
        boolean isHighlighted = false;
        String highlightStyle = null;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String hostName = (String)entry.getKey();
            Host host = (Host)this.engine.findChild(hostName);
            if (host == null) continue;
            isHighlighted = !isHighlighted;
            highlightStyle = isHighlighted ? "oddRow" : "evenRow";
            args = new Object[3];
            args[0] = RequestUtil.filter(hostName);
            String[] aliases = host.findAliases();
            StringBuffer buf = new StringBuffer();
            if (aliases.length > 0) {
                buf.append(aliases[0]);
                for (int j = 1; j < aliases.length; ++j) {
                    buf.append(", ").append(aliases[j]);
                }
            }
            if (buf.length() == 0) {
                buf.append("&nbsp;");
                args[1] = buf.toString();
            } else {
                args[1] = RequestUtil.filter(buf.toString());
            }
            args[2] = highlightStyle;
            writer.print(MessageFormat.format(HOSTS_ROW_DETAILS_SECTION, args));
            args = new Object[]{response.encodeURL(request.getContextPath() + "/html/start?name=" + URLEncoder.encode(hostName, "UTF-8")), hostsStart, response.encodeURL(request.getContextPath() + "/html/stop?name=" + URLEncoder.encode(hostName, "UTF-8")), hostsStop, response.encodeURL(request.getContextPath() + "/html/remove?name=" + URLEncoder.encode(hostName, "UTF-8")), hostsRemove, RequestUtil.filter(hostName)};
            if (host == this.host) {
                writer.print(MessageFormat.format(MANAGER_HOST_ROW_BUTTON_SECTION, args));
                continue;
            }
            writer.print(MessageFormat.format(HOSTS_ROW_BUTTON_SECTION, args));
        }
        args = new Object[]{sm.getString("htmlHostManagerServlet.addTitle"), sm.getString("htmlHostManagerServlet.addHost"), response.encodeURL(request.getContextPath() + "/html/add"), sm.getString("htmlHostManagerServlet.addName"), sm.getString("htmlHostManagerServlet.addAliases"), sm.getString("htmlHostManagerServlet.addAppBase")};
        writer.print(MessageFormat.format(ADD_SECTION_START, args));
        args = new Object[]{sm.getString("htmlHostManagerServlet.addAutoDeploy"), "autoDeploy", "checked"};
        writer.print(MessageFormat.format(ADD_SECTION_BOOLEAN, args));
        args[0] = sm.getString("htmlHostManagerServlet.addDeployOnStartup");
        args[1] = "deployOnStartup";
        args[2] = "checked";
        writer.print(MessageFormat.format(ADD_SECTION_BOOLEAN, args));
        args[0] = sm.getString("htmlHostManagerServlet.addDeployXML");
        args[1] = "deployXML";
        args[2] = "checked";
        writer.print(MessageFormat.format(ADD_SECTION_BOOLEAN, args));
        args[0] = sm.getString("htmlHostManagerServlet.addUnpackWARs");
        args[1] = "unpackWARs";
        args[2] = "checked";
        writer.print(MessageFormat.format(ADD_SECTION_BOOLEAN, args));
        args[0] = sm.getString("htmlHostManagerServlet.addXmlNamespaceAware");
        args[1] = "xmlNamespaceAware";
        args[2] = "";
        writer.print(MessageFormat.format(ADD_SECTION_BOOLEAN, args));
        args[0] = sm.getString("htmlHostManagerServlet.addXmlValidation");
        args[1] = "xmlValidation";
        args[2] = "";
        writer.print(MessageFormat.format(ADD_SECTION_BOOLEAN, args));
        args[0] = sm.getString("htmlHostManagerServlet.addManager");
        args[1] = "manager";
        args[2] = "checked";
        writer.print(MessageFormat.format(ADD_SECTION_BOOLEAN, args));
        args = new Object[]{sm.getString("htmlHostManagerServlet.addButton")};
        writer.print(MessageFormat.format(ADD_SECTION_END, args));
        args = new Object[]{sm.getString("htmlHostManagerServlet.serverTitle"), sm.getString("htmlHostManagerServlet.serverVersion"), sm.getString("htmlHostManagerServlet.serverJVMVersion"), sm.getString("htmlHostManagerServlet.serverJVMVendor"), sm.getString("htmlHostManagerServlet.serverOSName"), sm.getString("htmlHostManagerServlet.serverOSVersion"), sm.getString("htmlHostManagerServlet.serverOSArch")};
        writer.print(MessageFormat.format("<table width=\"100%\" cellspacing=\"0\" class=\"tableStyle\" >\n<thead>\n <th colspan=\"6\">{0}</th>\n</thead>\n<tr class=\"UnsortableTableHeader\">\n <td>{1}</td>\n <td>{2}</td>\n <td>{3}</td>\n <td>{4}</td>\n <td>{5}</td>\n <td>{6}</td>\n</tr>\n", args));
        args = new Object[]{ServerInfo.getServerInfo(), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")};
        writer.print(MessageFormat.format("<tbody><tr class=\"oddRow\">\n <td class=\"first\">{0}</small></td>\n <td>{1}</td>\n <td>{2}</td>\n <td>{3}</td>\n <td>{4}</td>\n <td>{5}</td>\n</tr>\n</tbody></table>\n\n", args));
        writer.print("  </div>\n  </div>\n  <div class=\"footer\">&copy; 2008 Red Hat Middleware, LLC. All Rights Reserved. </div>\n</div></body></html>");
        writer.flush();
        writer.close();
    }
}

