/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileItemFactory;
import org.apache.tomcat.util.http.fileupload.FileUploadException;
import org.apache.tomcat.util.http.fileupload.MultipartStream;

public abstract class FileUploadBase {
    public static final String CONTENT_TYPE = "Content-type";
    public static final String CONTENT_DISPOSITION = "Content-disposition";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final int MAX_HEADER_SIZE = 1024;
    private long sizeMax = -1L;
    private String headerEncoding;

    public static final boolean isMultipartContent(HttpServletRequest req) {
        String contentType = req.getHeader(CONTENT_TYPE);
        if (contentType == null) {
            return false;
        }
        return contentType.startsWith(MULTIPART);
    }

    public abstract FileItemFactory getFileItemFactory();

    public abstract void setFileItemFactory(FileItemFactory var1);

    public long getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(long sizeMax) {
        this.sizeMax = sizeMax;
    }

    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    public void setHeaderEncoding(String encoding) {
        this.headerEncoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileItem> parseRequest(HttpServletRequest req) throws FileUploadException {
        if (null == req) {
            throw new NullPointerException("req parameter");
        }
        ArrayList<FileItem> items = new ArrayList<FileItem>();
        String contentType = req.getHeader(CONTENT_TYPE);
        if (null == contentType || !contentType.startsWith(MULTIPART)) {
            throw new InvalidContentTypeException("the request doesn't contain a multipart/form-data or multipart/mixed stream, content type header is " + contentType);
        }
        int requestSize = req.getContentLength();
        if (requestSize == -1) {
            throw new UnknownSizeException("the request was rejected because it's size is unknown");
        }
        if (this.sizeMax >= 0L && (long)requestSize > this.sizeMax) {
            throw new SizeLimitExceededException("the request was rejected because it's size exceeds allowed range");
        }
        try {
            int boundaryIndex = contentType.indexOf("boundary=");
            if (boundaryIndex < 0) {
                throw new FileUploadException("the request was rejected because no multipart boundary was found");
            }
            byte[] boundary = contentType.substring(boundaryIndex + 9).getBytes();
            ServletInputStream input = req.getInputStream();
            MultipartStream multi = new MultipartStream((InputStream)input, boundary);
            multi.setHeaderEncoding(this.headerEncoding);
            boolean nextPart = multi.skipPreamble();
            while (nextPart) {
                Map<String, String> headers = this.parseHeaders(multi.readHeaders());
                String fieldName = this.getFieldName(headers);
                if (fieldName != null) {
                    FileItem item;
                    String subContentType = this.getHeader(headers, CONTENT_TYPE);
                    if (subContentType != null && subContentType.startsWith(MULTIPART_MIXED)) {
                        byte[] subBoundary = subContentType.substring(subContentType.indexOf("boundary=") + 9).getBytes();
                        multi.setBoundary(subBoundary);
                        boolean nextSubPart = multi.skipPreamble();
                        while (nextSubPart) {
                            headers = this.parseHeaders(multi.readHeaders());
                            if (this.getFileName(headers) != null) {
                                FileItem item2 = this.createItem(headers, false);
                                OutputStream os = item2.getOutputStream();
                                try {
                                    multi.readBodyData(os);
                                }
                                finally {
                                    os.close();
                                }
                                items.add(item2);
                            } else {
                                multi.discardBodyData();
                            }
                            nextSubPart = multi.readBoundary();
                        }
                        multi.setBoundary(boundary);
                    } else if (this.getFileName(headers) != null) {
                        item = this.createItem(headers, false);
                        OutputStream os = item.getOutputStream();
                        try {
                            multi.readBodyData(os);
                        }
                        finally {
                            os.close();
                        }
                        items.add(item);
                    } else {
                        item = this.createItem(headers, true);
                        OutputStream os = item.getOutputStream();
                        try {
                            multi.readBodyData(os);
                        }
                        finally {
                            os.close();
                        }
                        items.add(item);
                    }
                } else {
                    multi.discardBodyData();
                }
                nextPart = multi.readBoundary();
            }
        }
        catch (IOException e) {
            throw new FileUploadException("Processing of multipart/form-data request failed. " + e.getMessage());
        }
        return items;
    }

    protected String getFileName(Map headers) {
        String fileName = null;
        String cd = this.getHeader(headers, CONTENT_DISPOSITION);
        if (cd.startsWith(FORM_DATA) || cd.startsWith(ATTACHMENT)) {
            int start = cd.indexOf("filename=\"");
            int end = cd.indexOf(34, start + 10);
            if (start != -1 && end != -1) {
                fileName = cd.substring(start + 10, end).trim();
            }
        }
        return fileName;
    }

    protected String getFieldName(Map headers) {
        String fieldName = null;
        String cd = this.getHeader(headers, CONTENT_DISPOSITION);
        if (cd != null && cd.startsWith(FORM_DATA)) {
            int start = cd.indexOf("name=\"");
            int end = cd.indexOf(34, start + 6);
            if (start != -1 && end != -1) {
                fieldName = cd.substring(start + 6, end);
            }
        }
        return fieldName;
    }

    protected FileItem createItem(Map<String, String> headers, boolean isFormField) throws FileUploadException {
        return this.getFileItemFactory().createItem(this.getFieldName(headers), this.getHeader(headers, CONTENT_TYPE), isFormField, this.getFileName(headers), headers);
    }

    protected Map<String, String> parseHeaders(String headerPart) {
        HashMap<String, String> headers = new HashMap<String, String>();
        char[] buffer = new char[1024];
        boolean done = false;
        int j = 0;
        try {
            while (!done) {
                int i = 0;
                while (i < 2 || buffer[i - 2] != '\r' || buffer[i - 1] != '\n') {
                    buffer[i++] = headerPart.charAt(j++);
                }
                String header = new String(buffer, 0, i - 2);
                if (header.equals("")) {
                    done = true;
                    continue;
                }
                if (header.indexOf(58) == -1) continue;
                String headerName = header.substring(0, header.indexOf(58)).trim().toLowerCase();
                String headerValue = header.substring(header.indexOf(58) + 1).trim();
                if (this.getHeader(headers, headerName) != null) {
                    headers.put(headerName, this.getHeader(headers, headerName) + ',' + headerValue);
                    continue;
                }
                headers.put(headerName, headerValue);
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        return headers;
    }

    protected final String getHeader(Map headers, String name) {
        return (String)headers.get(name.toLowerCase());
    }

    public static class SizeLimitExceededException
    extends FileUploadException {
        public SizeLimitExceededException() {
        }

        public SizeLimitExceededException(String message) {
            super(message);
        }
    }

    public static class UnknownSizeException
    extends FileUploadException {
        public UnknownSizeException() {
        }

        public UnknownSizeException(String message) {
            super(message);
        }
    }

    public static class InvalidContentTypeException
    extends FileUploadException {
        public InvalidContentTypeException() {
        }

        public InvalidContentTypeException(String message) {
            super(message);
        }
    }
}

