/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Enumeration;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class HandlerRef
extends Reference {
    public static final String DEFAULT_FACTORY = "org.apache.naming.factory.HandlerFactory";
    public static final String HANDLER_NAME = "handlername";
    public static final String HANDLER_CLASS = "handlerclass";
    public static final String HANDLER_LOCALPART = "handlerlocalpart";
    public static final String HANDLER_NAMESPACE = "handlernamespace";
    public static final String HANDLER_PARAMNAME = "handlerparamname";
    public static final String HANDLER_PARAMVALUE = "handlerparamvalue";
    public static final String HANDLER_SOAPROLE = "handlersoaprole";
    public static final String HANDLER_PORTNAME = "handlerportname";

    public HandlerRef(String refname, String handlerClass) {
        this(refname, handlerClass, null, null);
    }

    public HandlerRef(String refname, String handlerClass, String factory, String factoryLocation) {
        super(refname, factory, factoryLocation);
        StringRefAddr refAddr = null;
        if (refname != null) {
            refAddr = new StringRefAddr(HANDLER_NAME, refname);
            this.add(refAddr);
        }
        if (handlerClass != null) {
            refAddr = new StringRefAddr(HANDLER_CLASS, handlerClass);
            this.add(refAddr);
        }
    }

    @Override
    public String getFactoryClassName() {
        String factory = super.getFactoryClassName();
        if (factory != null) {
            return factory;
        }
        factory = System.getProperty("java.naming.factory.object");
        if (factory != null) {
            return null;
        }
        return DEFAULT_FACTORY;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("HandlerRef[");
        sb.append("className=");
        sb.append(this.getClassName());
        sb.append(",factoryClassLocation=");
        sb.append(this.getFactoryClassLocation());
        sb.append(",factoryClassName=");
        sb.append(this.getFactoryClassName());
        Enumeration<RefAddr> refAddrs = this.getAll();
        while (refAddrs.hasMoreElements()) {
            RefAddr refAddr = refAddrs.nextElement();
            sb.append(",{type=");
            sb.append(refAddr.getType());
            sb.append(",content=");
            sb.append(refAddr.getContent());
            sb.append("}");
        }
        sb.append("]");
        return sb.toString();
    }
}

