/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.backend;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.tomcat.util.modeler.Registry;

public class CollectedInfo {
    protected MBeanServer mBeanServer = null;
    protected ObjectName objName = null;
    int ready;
    int busy;

    public CollectedInfo(String host, int port) throws Exception {
        this.init(host, port);
    }

    public void init(String host, int port) throws Exception {
        String sport = Integer.toString(port);
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
        String onStr = "*:type=ThreadPool,*";
        ObjectName objectName = new ObjectName(onStr);
        Set<ObjectInstance> set = this.mBeanServer.queryMBeans(objectName, null);
        for (ObjectInstance oi : set) {
            String[] shosts;
            String[] elenames;
            this.objName = oi.getObjectName();
            String name = this.objName.getKeyProperty("name");
            if ((port != 0 || host != null) && ((elenames = name.split("-"))[elenames.length - 1].compareTo(sport) != 0 || host != null && (shosts = elenames[1].split("%2F"))[0].compareTo(host) != 0)) continue;
            break;
        }
        if (this.objName == null) {
            throw new Exception("Can't find connector for " + host + ":" + sport);
        }
    }

    public void refresh() throws Exception {
        if (this.mBeanServer == null || this.objName == null) {
            throw new Exception("Not initialized!!!");
        }
        Integer imax = (Integer)this.mBeanServer.getAttribute(this.objName, "maxThreads");
        Integer ibusy = (Integer)this.mBeanServer.getAttribute(this.objName, "currentThreadsBusy");
        this.busy = ibusy;
        this.ready = imax - ibusy;
    }
}

