/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.apache.catalina.deploy.jsp.FunctionInfo;
import org.apache.catalina.deploy.jsp.TagInfo;
import org.apache.catalina.deploy.jsp.TagLibraryValidatorInfo;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.TagConstants;
import org.apache.jasper.compiler.TagFileProcessor;
import org.jboss.logging.Logger;

class TagLibraryInfoImpl
extends TagLibraryInfo
implements TagConstants {
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private Logger log = Logger.getLogger(TagLibraryInfoImpl.class);
    private JspCompilationContext ctxt;
    private PageInfo pi;
    private ErrorDispatcher err;
    private ParserController parserController;
    protected TagLibraryValidator tagLibraryValidator;

    private final void print(String name, String value, PrintWriter w) {
        if (value != null) {
            w.print(name + " = {\n\t");
            w.print(value);
            w.print("\n}\n");
        }
    }

    public String toString() {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.print("tlibversion", this.tlibversion, out);
        this.print("jspversion", this.jspversion, out);
        this.print("shortname", this.shortname, out);
        this.print("urn", this.urn, out);
        this.print("info", this.info, out);
        this.print("uri", this.uri, out);
        this.print("tagLibraryValidator", "" + this.tagLibraryValidator, out);
        for (i = 0; i < this.tags.length; ++i) {
            out.println(this.tags[i].toString());
        }
        for (i = 0; i < this.tagFiles.length; ++i) {
            out.println(this.tagFiles[i].toString());
        }
        for (i = 0; i < this.functions.length; ++i) {
            out.println(this.functions[i].toString());
        }
        return sw.toString();
    }

    public TagLibraryInfoImpl(JspCompilationContext ctxt, ParserController pc, PageInfo pi, String prefix, String uriIn, String[] location, ErrorDispatcher err) throws JasperException {
        super(prefix, uriIn);
        this.ctxt = ctxt;
        this.parserController = pc;
        this.pi = pi;
        this.err = err;
        URL jarFileUrl = null;
        if (location == null) {
            err.jspError("jsp.error.file.not.found", uriIn);
        }
        if (location[0] != null && location[0].endsWith(".jar")) {
            try {
                jarFileUrl = new URL("jar:file:" + location[0] + "!/");
            }
            catch (MalformedURLException ex) {
                err.jspError("jsp.error.file.not.found", uriIn);
            }
        }
        org.apache.catalina.deploy.jsp.TagLibraryInfo tagLibraryInfo = (org.apache.catalina.deploy.jsp.TagLibraryInfo)((HashMap)ctxt.getServletContext().getAttribute("org.apache.catalina.JSP_TAG_LIBRARIES")).get(uriIn);
        ArrayList<javax.servlet.jsp.tagext.TagInfo> tagInfos = new ArrayList<javax.servlet.jsp.tagext.TagInfo>();
        ArrayList<TagFileInfo> tagFileInfos = new ArrayList<TagFileInfo>();
        HashMap<String, javax.servlet.jsp.tagext.FunctionInfo> functionInfos = new HashMap<String, javax.servlet.jsp.tagext.FunctionInfo>();
        this.jspversion = tagLibraryInfo.getJspversion();
        this.tlibversion = tagLibraryInfo.getTlibversion();
        this.shortname = tagLibraryInfo.getShortname();
        this.urn = tagLibraryInfo.getUri();
        this.info = tagLibraryInfo.getInfo();
        if (tagLibraryInfo.getValidator() != null) {
            this.tagLibraryValidator = this.createValidator(tagLibraryInfo);
        }
        TagInfo[] tagInfosArray = tagLibraryInfo.getTags();
        for (int i = 0; i < tagInfosArray.length; ++i) {
            javax.servlet.jsp.tagext.TagInfo tagInfo = this.createTagInfo(tagInfosArray[i]);
            tagInfos.add(tagInfo);
        }
        org.apache.catalina.deploy.jsp.TagFileInfo[] tagFileInfosArray = tagLibraryInfo.getTagFileInfos();
        for (int i = 0; i < tagFileInfosArray.length; ++i) {
            TagFileInfo tagFileInfo = this.createTagFileInfo(tagFileInfosArray[i], jarFileUrl);
            tagFileInfos.add(tagFileInfo);
        }
        FunctionInfo[] functionInfosArray = tagLibraryInfo.getFunctionInfos();
        for (int i = 0; i < functionInfosArray.length; ++i) {
            javax.servlet.jsp.tagext.FunctionInfo functionInfo = this.createFunctionInfo(functionInfosArray[i]);
            if (functionInfos.containsKey(functionInfo.getName())) {
                err.jspError("jsp.error.tld.fn.duplicate.name", functionInfo.getName(), this.uri);
            }
            functionInfos.put(functionInfo.getName(), functionInfo);
        }
        if (this.tlibversion == null) {
            err.jspError("jsp.error.tld.mandatory.element.missing", "tlib-version");
        }
        if (this.jspversion == null) {
            err.jspError("jsp.error.tld.mandatory.element.missing", "jsp-version");
        }
        this.tags = tagInfos.toArray(new javax.servlet.jsp.tagext.TagInfo[0]);
        this.tagFiles = tagFileInfos.toArray(new TagFileInfo[0]);
        this.functions = functionInfos.values().toArray(new javax.servlet.jsp.tagext.FunctionInfo[0]);
    }

    public TagLibraryInfo[] getTagLibraryInfos() {
        Collection coll = this.pi.getTaglibs();
        return coll.toArray(new TagLibraryInfo[0]);
    }

    protected javax.servlet.jsp.tagext.TagInfo createTagInfo(TagInfo tagInfo) throws JasperException {
        ArrayList<TagAttributeInfo> attributeInfos = new ArrayList<TagAttributeInfo>();
        ArrayList<TagVariableInfo> variableInfos = new ArrayList<TagVariableInfo>();
        org.apache.catalina.deploy.jsp.TagAttributeInfo[] attributeInfosArray = tagInfo.getTagAttributeInfos();
        for (int i = 0; i < attributeInfosArray.length; ++i) {
            TagAttributeInfo attributeInfo = this.createTagAttributeInfo(attributeInfosArray[i]);
            attributeInfos.add(attributeInfo);
        }
        org.apache.catalina.deploy.jsp.TagVariableInfo[] variableInfosArray = tagInfo.getTagVariableInfos();
        for (int i = 0; i < variableInfosArray.length; ++i) {
            TagVariableInfo variableInfo = this.createTagVariableInfo(variableInfosArray[i]);
            variableInfos.add(variableInfo);
        }
        TagExtraInfo tei = null;
        String teiClassName = tagInfo.getTagExtraInfo();
        if (teiClassName != null && !teiClassName.equals("")) {
            try {
                Class<?> teiClass = this.ctxt.getClassLoader().loadClass(teiClassName);
                tei = (TagExtraInfo)teiClass.newInstance();
            }
            catch (Exception e) {
                this.err.jspError("jsp.error.teiclass.instantiation", teiClassName, e);
            }
        }
        return new javax.servlet.jsp.tagext.TagInfo(tagInfo.getTagName(), tagInfo.getTagClassName(), tagInfo.getBodyContent(), tagInfo.getInfoString(), (TagLibraryInfo)this, tei, attributeInfos.toArray(new TagAttributeInfo[0]), tagInfo.getDisplayName(), tagInfo.getSmallIcon(), tagInfo.getLargeIcon(), variableInfos.toArray(new TagVariableInfo[0]), tagInfo.isDynamicAttributes());
    }

    protected TagAttributeInfo createTagAttributeInfo(org.apache.catalina.deploy.jsp.TagAttributeInfo attributeInfo) {
        String type = attributeInfo.getType();
        String expectedType = attributeInfo.getExpectedTypeName();
        String methodSignature = attributeInfo.getMethodSignature();
        boolean rtexprvalue = JspUtil.booleanValue(attributeInfo.getReqTime());
        boolean fragment = JspUtil.booleanValue(attributeInfo.getFragment());
        boolean deferredValue = attributeInfo.getDeferredValue() != null;
        boolean deferredMethod = attributeInfo.getDeferredMethod() != null;
        boolean required = JspUtil.booleanValue(attributeInfo.getRequired());
        if (type != null && "1.2".equals(this.jspversion) && (type.equals("Boolean") || type.equals("Byte") || type.equals("Character") || type.equals("Double") || type.equals("Float") || type.equals("Integer") || type.equals("Long") || type.equals("Object") || type.equals("Short") || type.equals("String"))) {
            type = "java.lang." + type;
        }
        if (deferredValue) {
            type = "javax.el.ValueExpression";
            expectedType = expectedType != null ? expectedType.trim() : "java.lang.Object";
        }
        if (deferredMethod) {
            type = "javax.el.MethodExpression";
            methodSignature = methodSignature != null ? methodSignature.trim() : "java.lang.Object method()";
        }
        if (fragment) {
            type = "javax.servlet.jsp.tagext.JspFragment";
            rtexprvalue = true;
        }
        if (!rtexprvalue && type == null) {
            type = "java.lang.String";
        }
        return new TagAttributeInfo(attributeInfo.getName(), required, type, rtexprvalue, fragment, attributeInfo.getDescription(), deferredValue, deferredMethod, expectedType, methodSignature);
    }

    protected TagVariableInfo createTagVariableInfo(org.apache.catalina.deploy.jsp.TagVariableInfo variableInfo) {
        String className;
        int scope = 0;
        String s = variableInfo.getScope();
        if (s != null) {
            if ("NESTED".equals(s)) {
                scope = 0;
            } else if ("AT_BEGIN".equals(s)) {
                scope = 1;
            } else if ("AT_END".equals(s)) {
                scope = 2;
            }
        }
        if ((className = variableInfo.getClassName()) != null) {
            className = "java.lang.String";
        }
        boolean declare = true;
        if (variableInfo.getDeclare() != null) {
            declare = JspUtil.booleanValue(s);
        }
        return new TagVariableInfo(variableInfo.getNameGiven(), variableInfo.getNameFromAttribute(), className, declare, scope);
    }

    protected TagFileInfo createTagFileInfo(org.apache.catalina.deploy.jsp.TagFileInfo tagFileInfo, URL jarFileUrl) throws JasperException {
        String name = tagFileInfo.getName();
        String path = tagFileInfo.getPath();
        if (path.startsWith("/META-INF/tags")) {
            this.ctxt.setTagFileJarUrl(path, jarFileUrl);
        } else if (!path.startsWith("/WEB-INF/tags")) {
            this.err.jspError("jsp.error.tagfile.illegalPath", path);
        }
        javax.servlet.jsp.tagext.TagInfo tagInfo = TagFileProcessor.parseTagFileDirectives(this.parserController, name, path, jarFileUrl, this);
        return new TagFileInfo(name, path, tagInfo);
    }

    protected javax.servlet.jsp.tagext.FunctionInfo createFunctionInfo(FunctionInfo functionInfo) {
        return new javax.servlet.jsp.tagext.FunctionInfo(functionInfo.getName(), functionInfo.getFunctionClass(), functionInfo.getFunctionSignature());
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private TagLibraryValidator createValidator(org.apache.catalina.deploy.jsp.TagLibraryInfo tagLibraryInfo) throws JasperException {
        TagLibraryValidatorInfo tlvInfo = tagLibraryInfo.getValidator();
        String validatorClass = tlvInfo.getValidatorClass();
        Map<String, Object> initParams = tlvInfo.getInitParams();
        TagLibraryValidator tlv = null;
        if (validatorClass != null && !validatorClass.equals("")) {
            try {
                Class<?> tlvClass = this.ctxt.getClassLoader().loadClass(validatorClass);
                tlv = (TagLibraryValidator)tlvClass.newInstance();
            }
            catch (Exception e) {
                this.err.jspError("jsp.error.tlvclass.instantiation", validatorClass, e);
            }
        }
        if (tlv != null) {
            tlv.setInitParameters(initParams);
        }
        return tlv;
    }

    public TagLibraryValidator getTagLibraryValidator() {
        return this.tagLibraryValidator;
    }

    public ValidationMessage[] validate(PageData thePage) {
        TagLibraryValidator tlv = this.getTagLibraryValidator();
        if (tlv == null) {
            return null;
        }
        String uri = this.getURI();
        if (uri.startsWith("/")) {
            uri = "urn:jsptld:" + uri;
        }
        return tlv.validate(this.getPrefixString(), uri, thePage);
    }
}

