/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.mux;

import java.io.Serializable;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.JChannelFactory;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.mux.Multiplexer;
import org.jgroups.mux.MuxHeader;
import org.jgroups.stack.ProtocolStack;

public class MuxChannel
extends JChannel {
    final JChannel ch;
    final String id;
    final JChannelFactory factory;
    final String stack_name;
    final MuxHeader hdr;
    final String name = "MUX";
    final Multiplexer mux;

    public MuxChannel(JChannelFactory f, JChannel ch, String id, String stack_name, Multiplexer mux) {
        super(false);
        this.factory = f;
        this.ch = ch;
        this.stack_name = stack_name;
        this.id = id;
        this.hdr = new MuxHeader(id);
        this.mux = mux;
        this.closed = !ch.isOpen();
    }

    public String getStackName() {
        return this.stack_name;
    }

    public String getId() {
        return this.id;
    }

    public Multiplexer getMultiplexer() {
        return this.mux;
    }

    public String getChannelName() {
        return this.ch.getClusterName();
    }

    public String getClusterName() {
        return this.ch.getClusterName();
    }

    public Address getLocalAddress() {
        return this.ch != null ? this.ch.getLocalAddress() : null;
    }

    public JChannel getChannel() {
        return this.ch;
    }

    public View getView() {
        return this.mux.getServiceView(this.id);
    }

    public View getClusterView() {
        return this.ch != null ? this.ch.getView() : null;
    }

    public ProtocolStack getProtocolStack() {
        return this.ch != null ? this.ch.getProtocolStack() : null;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Map dumpStats() {
        return this.ch.dumpStats();
    }

    public void setClosed(boolean f) {
        this.closed = f;
    }

    public void setConnected(boolean f) {
        this.connected = f;
    }

    public Object getOpt(int option) {
        return this.ch.getOpt(option);
    }

    public void setOpt(int option, Object value) {
        this.ch.setOpt(option, value);
        super.setOpt(option, value);
    }

    public synchronized void connect(String channel_name) throws ChannelException, ChannelClosedException {
        this.factory.connect(this);
        this.notifyChannelConnected(this);
    }

    public synchronized boolean connect(String cluster_name, Address target, String state_id, long timeout) throws ChannelException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public synchronized void disconnect() {
        try {
            this.closed = false;
            this.connected = false;
            this.factory.disconnect(this);
        }
        catch (Throwable t) {
            this.log.error((Object)"disconnecting channel failed", t);
        }
        this.closed = false;
        this.connected = false;
        this.notifyChannelDisconnected(this);
    }

    public synchronized void open() throws ChannelException {
        this.factory.open(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        try {
            this.closed = true;
            this.connected = false;
            this.factory.close(this);
        }
        finally {
            this.closed = true;
            this.connected = false;
            this.closeMessageQueue(true);
        }
        this.notifyChannelClosed(this);
    }

    protected void _close(boolean disconnect, boolean close_mq) {
        super._close(disconnect, close_mq);
        this.closed = !this.ch.isOpen();
        this.connected = this.ch.isConnected();
        this.notifyChannelClosed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        try {
            this.factory.shutdown(this);
        }
        finally {
            this.closed = true;
            this.connected = false;
            this.closeMessageQueue(true);
        }
    }

    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        msg.putHeader("MUX", this.hdr);
        this.ch.send(msg);
    }

    public void send(Address dst, Address src, Serializable obj) throws ChannelNotConnectedException, ChannelClosedException {
        this.send(new Message(dst, src, obj));
    }

    public void down(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            msg.putHeader("MUX", this.hdr);
            this.ch.down(evt);
        } else {
            if (evt.getType() == 11) {
                this.mux.blockOk();
                return;
            }
            this.ch.down(evt);
        }
    }

    public boolean getState(Address target, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        return this.getState(target, null, timeout);
    }

    public boolean getState(Address target, String state_id, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        String my_id = this.id;
        if (state_id != null) {
            my_id = my_id + "::" + state_id;
        }
        Address service_view_coordinator = this.mux.getServiceCoordinator(this.id);
        Address tmp = this.getLocalAddress();
        if (service_view_coordinator != null) {
            target = service_view_coordinator;
        }
        if (tmp != null && tmp.equals(target)) {
            target = null;
        }
        if (!this.mux.stateTransferListenersPresent()) {
            return this.ch.getState(target, my_id, timeout);
        }
        return this.mux.getState(target, my_id, timeout);
    }

    public void returnState(byte[] state) {
        this.ch.returnState(state, this.id);
    }

    public void returnState(byte[] state, String state_id) {
        String my_id = this.id;
        if (state_id != null) {
            my_id = my_id + "::" + state_id;
        }
        this.ch.returnState(state, my_id);
    }

    protected void checkNotConnected() throws ChannelNotConnectedException {
    }

    protected void checkClosed() throws ChannelClosedException {
    }
}

