/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class VIEW_SYNC
extends Protocol {
    Address local_addr = null;
    final Vector mbrs = new Vector();
    View my_view = null;
    ViewId my_vid = null;
    long avg_send_interval = 60000L;
    private int num_views_sent = 0;
    private int num_views_adjusted = 0;
    private volatile ViewSendTask view_send_task = null;
    final Object view_send_task_mutex = new Object();
    TimeScheduler timer = null;
    static final String name = "VIEW_SYNC";
    static /* synthetic */ Class class$org$jgroups$MergeView;
    static /* synthetic */ Class class$org$jgroups$View;

    public String getName() {
        return name;
    }

    public long getAverageSendInterval() {
        return this.avg_send_interval;
    }

    public void setAverageSendInterval(long gossip_interval) {
        this.avg_send_interval = gossip_interval;
    }

    public int getNumViewsSent() {
        return this.num_views_sent;
    }

    public int getNumViewsAdjusted() {
        return this.num_views_adjusted;
    }

    public void resetStats() {
        super.resetStats();
        this.num_views_sent = 0;
        this.num_views_adjusted = 0;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("avg_send_interval");
        if (str != null) {
            this.avg_send_interval = Long.parseLong(str);
            props.remove("avg_send_interval");
        }
        if (props.size() > 0) {
            this.log.error((Object)("these properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        if (this.stack == null || this.stack.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
        this.timer = this.stack.timer;
    }

    public void stop() {
        this.stopViewSender();
    }

    public void sendViewRequest() {
        Message msg = new Message(null);
        ViewSyncHeader hdr = new ViewSyncHeader(2, null);
        msg.putHeader(name, hdr);
        this.passDown(new Event(1, msg));
    }

    public void up(Event evt) {
        int type = evt.getType();
        switch (type) {
            case 1: {
                Message msg = (Message)evt.getArg();
                ViewSyncHeader hdr = (ViewSyncHeader)msg.removeHeader(name);
                if (hdr == null) break;
                Address sender = msg.getSrc();
                switch (hdr.type) {
                    case 1: {
                        this.handleView(hdr.view, sender);
                        break;
                    }
                    case 2: {
                        if (sender.equals(this.local_addr)) break;
                        this.sendView();
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error((Object)("ViewSyncHeader type " + hdr.type + " not known"));
                    }
                }
                return;
            }
            case 6: {
                View view = (View)evt.getArg();
                this.handleViewChange(view);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View v = (View)evt.getArg();
                this.handleViewChange(v);
            }
        }
        this.passDown(evt);
    }

    private void handleView(View v, Address sender) {
        Vector members = v.getMembers();
        if (!members.contains(this.local_addr)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("discarding view as I (" + this.local_addr + ") am not member of view (" + v + ")"));
            }
            return;
        }
        ViewId vid = v.getVid();
        int rc = vid.compareTo(this.my_vid);
        if (rc > 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("view from " + sender + " (" + vid + ") is greater than my own view (" + this.my_vid + ");" + " will update my own view"));
            }
            Message view_change = new Message(this.local_addr, this.local_addr, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(5, v);
            view_change.putHeader("GMS", hdr);
            this.passUp(new Event(1, view_change));
            ++this.num_views_adjusted;
        }
    }

    private void handleViewChange(View view) {
        Vector tmp = view.getMembers();
        if (tmp != null) {
            this.mbrs.clear();
            this.mbrs.addAll(tmp);
        }
        this.my_view = (View)view.clone();
        this.my_vid = this.my_view.getVid();
        if (!(this.my_view.size() <= 1 || this.view_send_task != null && this.view_send_task.running())) {
            this.startViewSender();
        }
    }

    private void sendView() {
        View tmp = (View)(this.my_view != null ? this.my_view.clone() : null);
        if (tmp == null) {
            return;
        }
        Message msg = new Message(null);
        ViewSyncHeader hdr = new ViewSyncHeader(1, tmp);
        msg.putHeader(name, hdr);
        this.passDown(new Event(1, msg));
        ++this.num_views_sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startViewSender() {
        if (this.view_send_task != null) {
            return;
        }
        Object object = this.view_send_task_mutex;
        synchronized (object) {
            if (this.view_send_task != null && this.view_send_task.running()) {
                return;
            }
            this.view_send_task = new ViewSendTask();
            this.timer.add(this.view_send_task, true);
        }
        if (this.trace) {
            this.log.trace((Object)"view send task started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopViewSender() {
        Object object = this.view_send_task_mutex;
        synchronized (object) {
            if (this.view_send_task != null) {
                this.view_send_task.stop();
                if (this.trace) {
                    this.log.trace((Object)"view send task stopped");
                }
                this.view_send_task = null;
            }
        }
    }

    private class ViewSendTask
    implements TimeScheduler.Task {
        boolean stopped = false;

        private ViewSendTask() {
        }

        public void stop() {
            this.stopped = true;
        }

        public boolean running() {
            return !this.stopped;
        }

        public boolean cancelled() {
            return this.stopped;
        }

        public long nextInterval() {
            long interval = this.computeSleepTime();
            if (interval <= 0L) {
                return 10000L;
            }
            return interval;
        }

        public void run() {
            VIEW_SYNC.this.sendView();
        }

        long computeSleepTime() {
            int num_mbrs = Math.max(VIEW_SYNC.this.mbrs.size(), 1);
            return this.getRandom((long)num_mbrs * VIEW_SYNC.this.avg_send_interval * 2L);
        }

        long getRandom(long range) {
            return (long)(Math.random() * (double)range % (double)range);
        }
    }

    public static class ViewSyncHeader
    extends Header
    implements Streamable {
        public static final int VIEW_SYNC = 1;
        public static final int VIEW_SYNC_REQ = 2;
        int type = 0;
        View view = null;

        public ViewSyncHeader() {
        }

        public ViewSyncHeader(int type, View view) {
            this.type = type;
            this.view = view;
        }

        public int getType() {
            return this.type;
        }

        public View getView() {
            return this.view;
        }

        static String type2String(int t) {
            switch (t) {
                case 1: {
                    return org.jgroups.protocols.VIEW_SYNC.name;
                }
                case 2: {
                    return "VIEW_SYNC_REQ";
                }
            }
            return "<unknown>";
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            sb.append(ViewSyncHeader.type2String(this.type));
            sb.append("]");
            if (this.view != null) {
                sb.append(", view= ").append(this.view);
            }
            return sb.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            if (this.view == null) {
                out.writeBoolean(false);
                return;
            }
            out.writeBoolean(true);
            this.view.writeExternal(out);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            boolean available = in.readBoolean();
            if (available) {
                this.view = new View();
                this.view.readExternal(in);
            }
        }

        public long size() {
            long retval = 6L;
            if (this.view != null) {
                retval += (long)this.view.serializedSize();
            }
            return retval;
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeInt(this.type);
            byte b = (byte)(this.view == null ? 0 : (this.view instanceof MergeView ? 2 : 1));
            out.writeByte(b);
            Util.writeStreamable(this.view, out);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readInt();
            byte b = in.readByte();
            Class clazz = b == 2 ? (class$org$jgroups$MergeView == null ? (class$org$jgroups$MergeView = org.jgroups.protocols.VIEW_SYNC.class$("org.jgroups.MergeView")) : class$org$jgroups$MergeView) : (class$org$jgroups$View == null ? (class$org$jgroups$View = org.jgroups.protocols.VIEW_SYNC.class$("org.jgroups.View")) : class$org$jgroups$View);
            Class clazz2 = clazz;
            this.view = (View)Util.readStreamable(clazz2, in);
        }
    }
}

