/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.misc;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConversions;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ELException;

public class NumberOperations {
    private static final Long LONG_ZERO = 0L;

    private static final boolean isDotEe(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '.': 
                case 'E': 
                case 'e': {
                    return true;
                }
            }
        }
        return false;
    }

    private static final boolean isDotEe(Object object) {
        return object instanceof String && NumberOperations.isDotEe((String)object);
    }

    private static final boolean isFloatOrDouble(Object object) {
        return object instanceof Float || object instanceof Double;
    }

    private static final boolean isFloatOrDoubleOrDotEe(Object object) {
        return NumberOperations.isFloatOrDouble(object) || NumberOperations.isDotEe(object);
    }

    private static final boolean isBigDecimalOrBigInteger(Object object) {
        return object instanceof BigDecimal || object instanceof BigInteger;
    }

    private static final boolean isBigDecimalOrFloatOrDoubleOrDotEe(Object object) {
        return object instanceof BigDecimal || NumberOperations.isFloatOrDoubleOrDotEe(object);
    }

    private static final BigDecimal toBigDecimal(Object object) {
        return TypeConversions.coerceToNumber(object, BigDecimal.class);
    }

    private static final BigInteger toBigInteger(Object object) {
        return TypeConversions.coerceToNumber(object, BigInteger.class);
    }

    private static final Double toDouble(Object object) {
        return TypeConversions.coerceToNumber(object, Double.class);
    }

    private static final Long toLong(Object object) {
        return TypeConversions.coerceToNumber(object, Long.class);
    }

    public static final Number add(Object object, Object object2) {
        if (object == null && object2 == null) {
            return LONG_ZERO;
        }
        if (object instanceof BigDecimal || object2 instanceof BigDecimal) {
            return NumberOperations.toBigDecimal(object).add(NumberOperations.toBigDecimal(object2));
        }
        if (NumberOperations.isFloatOrDoubleOrDotEe(object) || NumberOperations.isFloatOrDoubleOrDotEe(object2)) {
            if (object instanceof BigInteger || object2 instanceof BigInteger) {
                return NumberOperations.toBigDecimal(object).add(NumberOperations.toBigDecimal(object2));
            }
            return NumberOperations.toDouble(object) + NumberOperations.toDouble(object2);
        }
        if (object instanceof BigInteger || object2 instanceof BigInteger) {
            return NumberOperations.toBigInteger(object).add(NumberOperations.toBigInteger(object2));
        }
        return NumberOperations.toLong(object) + NumberOperations.toLong(object2);
    }

    public static final Number sub(Object object, Object object2) {
        if (object == null && object2 == null) {
            return LONG_ZERO;
        }
        if (object instanceof BigDecimal || object2 instanceof BigDecimal) {
            return NumberOperations.toBigDecimal(object).subtract(NumberOperations.toBigDecimal(object2));
        }
        if (NumberOperations.isFloatOrDoubleOrDotEe(object) || NumberOperations.isFloatOrDoubleOrDotEe(object2)) {
            if (object instanceof BigInteger || object2 instanceof BigInteger) {
                return NumberOperations.toBigDecimal(object).subtract(NumberOperations.toBigDecimal(object2));
            }
            return NumberOperations.toDouble(object) - NumberOperations.toDouble(object2);
        }
        if (object instanceof BigInteger || object2 instanceof BigInteger) {
            return NumberOperations.toBigInteger(object).subtract(NumberOperations.toBigInteger(object2));
        }
        return NumberOperations.toLong(object) - NumberOperations.toLong(object2);
    }

    public static final Number mul(Object object, Object object2) {
        if (object == null && object2 == null) {
            return LONG_ZERO;
        }
        if (object instanceof BigDecimal || object2 instanceof BigDecimal) {
            return NumberOperations.toBigDecimal(object).multiply(NumberOperations.toBigDecimal(object2));
        }
        if (NumberOperations.isFloatOrDoubleOrDotEe(object) || NumberOperations.isFloatOrDoubleOrDotEe(object2)) {
            if (object instanceof BigInteger || object2 instanceof BigInteger) {
                return NumberOperations.toBigDecimal(object).multiply(NumberOperations.toBigDecimal(object2));
            }
            return NumberOperations.toDouble(object) * NumberOperations.toDouble(object2);
        }
        if (object instanceof BigInteger || object2 instanceof BigInteger) {
            return NumberOperations.toBigInteger(object).multiply(NumberOperations.toBigInteger(object2));
        }
        return NumberOperations.toLong(object) * NumberOperations.toLong(object2);
    }

    public static final Number div(Object object, Object object2) {
        if (object == null && object2 == null) {
            return LONG_ZERO;
        }
        if (NumberOperations.isBigDecimalOrBigInteger(object) || NumberOperations.isBigDecimalOrBigInteger(object2)) {
            return NumberOperations.toBigDecimal(object).divide(NumberOperations.toBigDecimal(object2), 4);
        }
        return NumberOperations.toDouble(object) / NumberOperations.toDouble(object2);
    }

    public static final Number mod(Object object, Object object2) {
        if (object == null && object2 == null) {
            return LONG_ZERO;
        }
        if (NumberOperations.isBigDecimalOrFloatOrDoubleOrDotEe(object) || NumberOperations.isBigDecimalOrFloatOrDoubleOrDotEe(object2)) {
            return NumberOperations.toDouble(object) % NumberOperations.toDouble(object2);
        }
        if (object instanceof BigInteger || object2 instanceof BigInteger) {
            return NumberOperations.toBigInteger(object).remainder(NumberOperations.toBigInteger(object2));
        }
        return NumberOperations.toLong(object) % NumberOperations.toLong(object2);
    }

    public static final Number neg(Object object) {
        if (object == null) {
            return LONG_ZERO;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).negate();
        }
        if (object instanceof BigInteger) {
            return ((BigInteger)object).negate();
        }
        if (object instanceof Double) {
            return -((Double)object).doubleValue();
        }
        if (object instanceof Float) {
            return Float.valueOf(-((Float)object).floatValue());
        }
        if (object instanceof String) {
            if (NumberOperations.isDotEe((String)object)) {
                return -NumberOperations.toDouble(object).doubleValue();
            }
            return -NumberOperations.toLong(object).longValue();
        }
        if (object instanceof Long) {
            return -((Long)object).longValue();
        }
        if (object instanceof Integer) {
            return -((Integer)object).intValue();
        }
        if (object instanceof Short) {
            return -((Short)object).shortValue();
        }
        if (object instanceof Byte) {
            return -((Byte)object).byteValue();
        }
        throw new ELException(LocalMessages.get("error.negate", object.getClass()));
    }
}

