/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.IdentifierNode;
import de.odysseus.el.tree.impl.ast.AstNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstIdentifier
extends AstNode
implements IdentifierNode {
    private final String name;
    private final int index;

    public AstIdentifier(String string, int n) {
        this.name = string;
        this.index = n;
    }

    @Override
    public Class<?> getType(Bindings bindings, ELContext eLContext) {
        ValueExpression valueExpression = bindings.getVariable(this.index);
        if (valueExpression != null) {
            return valueExpression.getType(eLContext);
        }
        Class clazz = eLContext.getELResolver().getType(eLContext, null, (Object)this.name);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", this.name));
        }
        return clazz;
    }

    @Override
    public boolean isLeftValue() {
        return true;
    }

    @Override
    public boolean isLiteralText() {
        return false;
    }

    @Override
    public Object eval(Bindings bindings, ELContext eLContext) {
        ValueExpression valueExpression = bindings.getVariable(this.index);
        if (valueExpression != null) {
            return valueExpression.getValue(eLContext);
        }
        Object object = eLContext.getELResolver().getValue(eLContext, null, (Object)this.name);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", this.name));
        }
        return object;
    }

    @Override
    public void setValue(Bindings bindings, ELContext eLContext, Object object) {
        ValueExpression valueExpression = bindings.getVariable(this.index);
        if (valueExpression != null) {
            valueExpression.setValue(eLContext, object);
        }
        eLContext.getELResolver().setValue(eLContext, null, (Object)this.name, object);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", this.name));
        }
    }

    @Override
    public boolean isReadOnly(Bindings bindings, ELContext eLContext) {
        ValueExpression valueExpression = bindings.getVariable(this.index);
        if (valueExpression != null) {
            return valueExpression.isReadOnly(eLContext);
        }
        boolean bl = eLContext.getELResolver().isReadOnly(eLContext, null, (Object)this.name);
        if (!eLContext.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", this.name));
        }
        return bl;
    }

    private Method getMethod(Bindings bindings, ELContext eLContext, Class<?> clazz, Class<?>[] classArray) {
        Object object = this.eval(bindings, eLContext);
        if (object == null) {
            throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notfound", this.name));
        }
        if (object instanceof Method) {
            Method method = (Method)object;
            if (clazz != null && !clazz.isAssignableFrom(method.getReturnType())) {
                throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notfound", this.name));
            }
            if (!Arrays.equals(method.getParameterTypes(), classArray)) {
                throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notfound", this.name));
            }
            return method;
        }
        throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notamethod", this.name, object.getClass()));
    }

    @Override
    public MethodInfo getMethodInfo(Bindings bindings, ELContext eLContext, Class<?> clazz, Class<?>[] classArray) {
        Method method = this.getMethod(bindings, eLContext, clazz, classArray);
        return new MethodInfo(method.getName(), method.getReturnType(), (Class[])classArray);
    }

    @Override
    public Object invoke(Bindings bindings, ELContext eLContext, Class<?> clazz, Class<?>[] classArray, Object[] objectArray) {
        Method method = this.getMethod(bindings, eLContext, clazz, classArray);
        try {
            return method.invoke(null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ELException(LocalMessages.get("error.identifier.method.access", this.name));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ELException(LocalMessages.get("error.identifier.method.invocation", this.name, illegalArgumentException));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ELException(LocalMessages.get("error.identifier.method.invocation", this.name, invocationTargetException.getCause()));
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void appendStructure(StringBuilder stringBuilder, Bindings bindings) {
        ValueExpression valueExpression = bindings == null ? null : bindings.getVariable(this.index);
        stringBuilder.append(valueExpression != null ? "<var>" : this.name);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getCardinality() {
        return 0;
    }

    @Override
    public AstNode getChild(int n) {
        return null;
    }
}

