/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el;

import de.odysseus.el.ObjectValueExpression;
import de.odysseus.el.TreeMethodExpression;
import de.odysseus.el.TreeValueExpression;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.tree.TreeBuilder;
import de.odysseus.el.tree.TreeStore;
import de.odysseus.el.tree.impl.Builder;
import de.odysseus.el.tree.impl.Cache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.EnumSet;
import java.util.Properties;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionFactoryImpl
extends ExpressionFactory {
    private final TreeStore store;
    private final TypeConverter converter;

    public ExpressionFactoryImpl() {
        Properties properties = this.loadProperties("el.properties");
        this.store = this.createTreeStore(1000, properties);
        this.converter = this.createTypeConverter(properties);
    }

    public ExpressionFactoryImpl(Properties properties) {
        this.store = this.createTreeStore(1000, properties);
        this.converter = this.createTypeConverter(properties);
    }

    public ExpressionFactoryImpl(TreeStore treeStore) {
        this(treeStore, TypeConverter.DEFAULT);
    }

    public ExpressionFactoryImpl(TreeStore treeStore, TypeConverter typeConverter) {
        this.store = treeStore;
        this.converter = typeConverter;
    }

    private Properties loadDefaultProperties() {
        String string = System.getProperty("java.home");
        String string2 = string + File.separator + "lib" + File.separator + "el.properties";
        File file = new File(string2);
        if (file.exists()) {
            Properties properties = new Properties();
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                throw new ELException("Cannot read default EL properties", (Throwable)iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            String string3 = properties.getProperty("javax.el.ExpressionFactory");
            if (((Object)((Object)this)).getClass().getName().equals(string3)) {
                return properties;
            }
        }
        return null;
    }

    private Properties loadProperties(String string) {
        Properties properties = new Properties(this.loadDefaultProperties());
        InputStream inputStream = null;
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        }
        catch (SecurityException securityException) {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
        }
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                throw new ELException("Cannot read EL properties", (Throwable)iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    protected TreeStore createTreeStore(int n, Properties properties) {
        EnumSet<Builder.Feature> enumSet = EnumSet.noneOf(Builder.Feature.class);
        if (properties != null) {
            if (Boolean.valueOf(properties.getProperty("javax.el.methodInvocations")).booleanValue()) {
                enumSet.add(Builder.Feature.METHOD_INVOCATIONS);
            }
            if (Boolean.valueOf(properties.getProperty("javax.el.nullProperties")).booleanValue()) {
                enumSet.add(Builder.Feature.NULL_PROPERTIES);
            }
            if (Boolean.valueOf(properties.getProperty("javax.el.varArgs")).booleanValue()) {
                enumSet.add(Builder.Feature.VARARGS);
            }
        }
        TreeBuilder treeBuilder = this.createTreeBuilder(properties, enumSet.toArray(new Builder.Feature[0]));
        int n2 = n;
        if (properties != null && properties.containsKey("javax.el.cacheSize")) {
            try {
                n2 = Integer.parseInt(properties.getProperty("javax.el.cacheSize"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ELException("Cannot parse EL property javax.el.cacheSize", (Throwable)numberFormatException);
            }
        }
        Cache cache = n2 > 0 ? new Cache(n2) : null;
        return new TreeStore(treeBuilder, cache);
    }

    protected TypeConverter createTypeConverter(Properties properties) {
        Class<?> clazz = this.load(TypeConverter.class, properties);
        if (clazz == null) {
            return TypeConverter.DEFAULT;
        }
        try {
            return (TypeConverter)TypeConverter.class.cast(clazz.newInstance());
        }
        catch (Exception exception) {
            throw new ELException("TypeConverter " + clazz + " could not be instantiated", (Throwable)exception);
        }
    }

    protected TreeBuilder createTreeBuilder(Properties properties, Builder.Feature ... featureArray) {
        Class<?> clazz = this.load(TreeBuilder.class, properties);
        if (clazz == null) {
            return new Builder(featureArray);
        }
        try {
            if (Builder.class.isAssignableFrom(clazz)) {
                Constructor<?> constructor = clazz.getConstructor(Builder.Feature[].class);
                if (constructor == null) {
                    if (featureArray == null || featureArray.length == 0) {
                        return (TreeBuilder)TreeBuilder.class.cast(clazz.newInstance());
                    }
                    throw new ELException("Builder " + clazz + " is missing constructor (can't pass features)");
                }
                return (TreeBuilder)TreeBuilder.class.cast(constructor.newInstance(new Object[]{featureArray}));
            }
            return (TreeBuilder)TreeBuilder.class.cast(clazz.newInstance());
        }
        catch (Exception exception) {
            throw new ELException("TreeBuilder " + clazz + " could not be instantiated", (Throwable)exception);
        }
    }

    private Class<?> load(Class<?> clazz, Properties properties) {
        String string;
        if (properties != null && (string = properties.getProperty(clazz.getName())) != null) {
            ClassLoader classLoader;
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception exception) {
                throw new ELException("Could not get context class loader", (Throwable)exception);
            }
            try {
                return classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ELException("Class " + string + " not found", (Throwable)classNotFoundException);
            }
            catch (Exception exception) {
                throw new ELException("Class " + string + " could not be instantiated", (Throwable)exception);
            }
        }
        return null;
    }

    public final Object coerceToType(Object object, Class<?> clazz) {
        return this.converter.convert(object, clazz);
    }

    public final ObjectValueExpression createValueExpression(Object object, Class<?> clazz) {
        return new ObjectValueExpression(this.converter, object, clazz);
    }

    public final TreeValueExpression createValueExpression(ELContext eLContext, String string, Class<?> clazz) {
        return new TreeValueExpression(this.store, eLContext.getFunctionMapper(), eLContext.getVariableMapper(), this.converter, string, clazz);
    }

    public final TreeMethodExpression createMethodExpression(ELContext eLContext, String string, Class<?> clazz, Class<?>[] classArray) {
        return new TreeMethodExpression(this.store, eLContext.getFunctionMapper(), eLContext.getVariableMapper(), this.converter, string, clazz, classArray);
    }
}

