/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.BooleanOperations;
import de.odysseus.el.misc.NumberOperations;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstRightValue;
import javax.el.ELContext;
import javax.el.ELException;

public class AstUnary
extends AstRightValue {
    public static final Operator EMPTY = new Operator(){

        public Object apply(TypeConverter typeConverter, Object object) {
            return BooleanOperations.empty(typeConverter, object);
        }

        public String toString() {
            return "empty";
        }
    };
    public static final Operator NEG = new Operator(){

        public Object apply(TypeConverter typeConverter, Object object) {
            return NumberOperations.neg(typeConverter, object);
        }

        public String toString() {
            return "-";
        }
    };
    public static final Operator NOT = new Operator(){

        public Object apply(TypeConverter typeConverter, Object object) {
            return BooleanOperations.not(typeConverter, object);
        }

        public String toString() {
            return "!";
        }
    };
    private final Operator operator;
    private final AstNode child;

    public AstUnary(AstNode astNode, Operator operator) {
        this.child = astNode;
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Object eval(Bindings bindings, ELContext eLContext) throws ELException {
        return this.operator.apply(bindings, this.child.eval(bindings, eLContext));
    }

    public String toString() {
        return "'" + this.operator.toString() + "'";
    }

    public void appendStructure(StringBuilder stringBuilder, Bindings bindings) {
        stringBuilder.append(this.operator);
        stringBuilder.append(' ');
        this.child.appendStructure(stringBuilder, bindings);
    }

    public int getCardinality() {
        return 1;
    }

    public AstNode getChild(int n) {
        return n == 0 ? this.child : null;
    }

    public static interface Operator {
        public Object apply(TypeConverter var1, Object var2);
    }
}

