/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.appcompat.app.AlertDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import ly.warp.sdk.db.WarplyDBHelper;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.callbacks.CampaignsHook;
import ly.warp.sdk.io.callbacks.InboxStatsHook;
import ly.warp.sdk.io.callbacks.PostHook;
import ly.warp.sdk.io.callbacks.SimpleCallbackReceiver;
import ly.warp.sdk.io.callbacks.VolleyTransformer;
import ly.warp.sdk.io.callbacks.WarplyReadyCallback;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.models.InboxStats;
import ly.warp.sdk.io.request.WarplyInboxRequest;
import ly.warp.sdk.io.request.WarplyJsonArrayRequest;
import ly.warp.sdk.io.request.WarplyJsonObjectRequest;
import ly.warp.sdk.io.volley.RequestQueue;
import ly.warp.sdk.io.volley.Response;
import ly.warp.sdk.io.volley.toolbox.Volley;
import ly.warp.sdk.receivers.WarplyBeaconsApplication;
import ly.warp.sdk.utils.ObjectSerializer;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyDeviceInfoCollector;
import ly.warp.sdk.utils.WarplyInitializer;
import ly.warp.sdk.utils.WarplyPreferences;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyLocationManager;
import ly.warp.sdk.utils.managers.WarplyServerPreferencesManager;
import ly.warp.sdk.utils.managers.WarplyUserManager;
import ly.warp.sdk.views.dialogs.InAppDialog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public enum Warply {
    INSTANCE;

    public static Map<WarpConstants.LocationSetting, Integer> LOCATION_SETTINGS_MAP;
    private static final int MINIMUM_REQUESTS_FOR_SENDING = 10;
    public Context mContext;
    private CallbackReceiver<WarpConstants.ServiceRegistrationCallback> mRegistrationListener;
    private RequestQueue mRequestQueue;
    private final AtomicBoolean registerLock = new AtomicBoolean(false);
    private final AtomicBoolean postLock = new AtomicBoolean(false);
    private CampaignList mLastReceivedCampaigns;
    public CampaignList mInAppCampaigns;
    private CallbackReceiver<JSONObject> mRegistrationCallBackReceiver = new CallbackReceiver<JSONObject>(){

        @Override
        public void onSuccess(JSONObject result) {
            if ((result = result.optJSONObject("context")) != null) {
                WarpUtils.setLastDeviceInfo(Warply.this.mContext, "");
                WarpUtils.setLastApplicationData(Warply.this.mContext, "");
                WarpUtils.setLastApplicationUUID(Warply.this.mContext, WarplyProperty.getAppUuid(Warply.this.mContext));
                WarplyDBHelper.getInstance(Warply.this.mContext).deleteAllRequests();
                WarplyDBHelper.getInstance(Warply.this.mContext).deleteAllPushRequests();
                WarplyDBHelper.getInstance(Warply.this.mContext).deleteAllPushAckRequests();
                String webId = result.optString("web_id", "");
                WarpUtils.setWebId(Warply.this.mContext, webId);
                String apiKey = result.optString("api_key", "");
                WarpUtils.setApiKey(Warply.this.mContext, apiKey);
                WarpUtils.log("************* WARPLY Registration ********************");
                WarpUtils.log("[WARPLY Registration] URL: " + WarplyProperty.getBaseUrl(Warply.this.mContext));
                WarpUtils.log("[WARPLY Registration] WEB_ID: " + webId);
                try {
                    WarpUtils.log("[WARPLY Registration] Response: " + result.toString(2));
                }
                catch (JSONException e) {
                    WarpUtils.warn("[WARP Trace] Failed converting JSON to string", (Exception)((Object)e));
                }
                WarpUtils.log("******************************************************");
                if (Warply.this.mRegistrationListener != null) {
                    Warply.this.mRegistrationListener.onSuccess(WarpConstants.ServiceRegistrationCallback.REGISTERED_WARPLY);
                }
                Warply.this.postApplicationData(true);
            }
            Warply.this.releaseRegisterLock();
        }

        @Override
        public void onFailure(int errorCode) {
            WarpUtils.log("************* WARPLY Registration ********************");
            WarpUtils.log("[WARP Registration] Error: " + String.valueOf(errorCode));
            WarpUtils.log("******************************************************");
            if (Warply.this.mRegistrationListener != null) {
                Warply.this.mRegistrationListener.onFailure(errorCode);
            }
            if (errorCode == 3) {
                String url = WarplyProperty.getBaseUrl(Warply.this.mContext) + "/api/mobile/v2/" + WarplyProperty.getAppUuid(Warply.this.mContext) + "/" + "register" + "/";
                Warply.this.requestToServerInternal(0, url, null, (CallbackReceiver<JSONObject>)Warply.this.mRegistrationCallBackReceiver, null);
            } else {
                Warply.this.releaseRegisterLock();
            }
        }
    };
    private static WarplyServerPreferencesManager.ServerPreferencesReceivedListener mServerPreferencesReceiveListener;

    public static WarplyInitializer getInitializer(Context context) {
        return Warply.getInitializer(context, null);
    }

    public static WarplyInitializer getInitializer(Context context, WarplyReadyCallback callback) {
        return new WarplyInitializer(context, callback, new WarplyInitializer.WarplyInitCallback(){

            @Override
            public void onInit(Context context) {
                if (context != null) {
                    Warply.INSTANCE.mContext = context.getApplicationContext();
                }
                Warply.initInternal(context);
            }
        });
    }

    private static void initInternal(Context context) {
        if (context == null) {
            INSTANCE.check();
            return;
        }
        if (Warply.INSTANCE.mRequestQueue == null) {
            Warply.INSTANCE.mRequestQueue = Volley.newRequestQueue(context);
        }
        Warply.INSTANCE.mContext = context.getApplicationContext();
        WarpConstants.DEBUG = WarplyProperty.isDebugMode(Warply.INSTANCE.mContext);
        INSTANCE.isInitializedOrThrow();
        WarpConstants.GCM_SENDER_ID = WarpUtils.getLastGCMSenderId(Warply.INSTANCE.mContext);
        if (!WarpUtils.getLastApplicationUUID(context).equals(WarplyProperty.getAppUuid(context))) {
            Warply.resetWarplyWebId();
        }
        WarplyServerPreferencesManager.initiateMicroAppStatusesMap(context);
    }

    private void isInitializedOrThrow() {
        if (this.mContext == null) {
            WarpUtils.log("Warply has not been initialized, call init(Context) first");
        }
        if (this.mContext != null) {
            WarpUtils.log("Warply has been initialized, all good");
        }
        if (this.mContext != null) {
            String apiKey = WarplyProperty.getAppUuid(this.mContext);
            if (TextUtils.isEmpty((CharSequence)apiKey)) {
                WarpUtils.log("Warply application UUID has not been set in the Manifest");
            }
            if (!TextUtils.isEmpty((CharSequence)apiKey) && apiKey.length() != 32 && apiKey.length() != 36) {
                WarpUtils.log("Warply application UUID has not been set correctly in the Manifest, key got: " + apiKey);
            }
        }
    }

    public static boolean isInitialized(boolean printError) {
        return INSTANCE.isInitializedInternal(printError);
    }

    private boolean isInitializedInternal(boolean printError) {
        try {
            this.isInitializedOrThrow();
        }
        catch (RuntimeException e) {
            if (printError) {
                WarpUtils.log("************* WARPLY Initialisation Error ********************");
            }
            WarpUtils.log("[WARPLY Trace] Error: " + e.getMessage());
            WarpUtils.log("**************************************************************");
            return false;
        }
        return true;
    }

    public static boolean isInitialized() {
        return INSTANCE.isInitializedInternal();
    }

    private boolean isInitializedInternal() {
        return Warply.isInitialized(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquirePostLockInternal() {
        AtomicBoolean atomicBoolean = this.postLock;
        synchronized (atomicBoolean) {
            if (this.postLock.get()) {
                return false;
            }
            this.postLock.set(true);
        }
        return true;
    }

    public static void releasePostLock() {
        INSTANCE.releasePostLockInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releasePostLockInternal() {
        AtomicBoolean atomicBoolean = this.postLock;
        synchronized (atomicBoolean) {
            this.postLock.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireRegisterLock() {
        AtomicBoolean atomicBoolean = this.registerLock;
        synchronized (atomicBoolean) {
            if (this.registerLock.get()) {
                return false;
            }
            this.registerLock.set(true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRegisterLock() {
        AtomicBoolean atomicBoolean = this.registerLock;
        synchronized (atomicBoolean) {
            this.registerLock.set(false);
        }
    }

    public static void getContext(CallbackReceiver<JSONObject> receiver) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.getContextInternal(receiver);
    }

    private void getContextInternal(CallbackReceiver<JSONObject> receiver) {
        if (!WarpUtils.isRegisteredWarply(this.mContext)) {
            if (receiver != null) {
                receiver.onFailure(-4);
            }
            return;
        }
        this.getFromServerInternal(null, null, receiver, null);
    }

    public static void getMicroappData(String microappName, CallbackReceiver<JSONObject> receiver) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.getMicroappDataInternal(microappName, receiver);
    }

    private void getMicroappDataInternal(String microappName, CallbackReceiver<JSONObject> receiver) {
        if (!WarpUtils.isRegisteredWarply(this.mContext)) {
            if (receiver != null) {
                receiver.onFailure(-4);
            }
            return;
        }
        this.getFromServerInternal(null, microappName, receiver, null);
    }

    public static void postReceiveMicroappData(String microappName, JSONObject jObj, CallbackReceiver<JSONObject> receiver) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.postReceiveMicroappDataInternal(microappName, jObj, receiver);
    }

    public static void postReceiveMicroappData(boolean hasAuthHeaders, String path, JSONObject jObj, CallbackReceiver<JSONObject> receiver) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.postReceiveMicroappDataInternal(hasAuthHeaders, path, jObj, receiver);
    }

    public static void postReceiveMicroappData(String microappName, boolean hasAuthHeaders, String path, JSONObject jObj, CallbackReceiver<JSONObject> receiver) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.postReceiveMicroappDataInternal(microappName, hasAuthHeaders, path, jObj, receiver);
    }

    private void postReceiveMicroappDataInternal(String microappName, JSONObject jObj, CallbackReceiver<JSONObject> receiver) {
        JSONObject jObject;
        block4: {
            if (!WarpUtils.isRegisteredWarply(this.mContext)) {
                if (receiver != null) {
                    receiver.onFailure(-4);
                }
                return;
            }
            jObject = new JSONObject();
            try {
                jObject.putOpt(microappName, (Object)jObj);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        this.postToServerInternal(jObject, receiver, null);
    }

    private void postReceiveMicroappDataInternal(boolean hasAuthHeaders, String path, JSONObject jObj, CallbackReceiver<JSONObject> receiver) {
        if (!WarpUtils.isRegisteredWarply(this.mContext)) {
            if (receiver != null) {
                receiver.onFailure(-4);
            }
            return;
        }
        String tag = null;
        if (path.equals("cosuser")) {
            tag = "cosuser";
        }
        this.postToServerInternal(hasAuthHeaders, path, jObj, receiver, (Object)tag);
    }

    private void postReceiveMicroappDataInternal(String microappName, boolean hasAuthHeaders, String path, JSONObject jObj, CallbackReceiver<JSONObject> receiver) {
        JSONObject jObject;
        block4: {
            if (!WarpUtils.isRegisteredWarply(this.mContext)) {
                if (receiver != null) {
                    receiver.onFailure(-4);
                }
                return;
            }
            jObject = new JSONObject();
            try {
                jObject.putOpt(microappName, (Object)jObj);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        this.postToServerInternal(hasAuthHeaders, path, jObject, receiver, null);
    }

    public static void postMicroappData(String microappName, JSONObject jObj) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.postMicroappDataInternal(microappName, jObj);
    }

    private void postMicroappDataInternal(String microappName, JSONObject jObj) {
        Warply.postMicroappData(microappName, jObj, false);
    }

    public static void postMicroappData(String microappName, JSONObject jObj, boolean force) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.postMicroappDataInternal(microappName, jObj, force);
    }

    public static void postMicroappData(Context context, String microappName, JSONObject jObj, boolean force) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.postMicroappDataInternal(context, microappName, jObj, force);
    }

    private void postMicroappDataInternal(String microappName, JSONObject jObj, boolean force) {
        this.isInitializedOrThrow();
        long requestsInQueueCount = 0L;
        if (jObj != null && this.mContext != null) {
            requestsInQueueCount = WarplyDBHelper.getInstance(this.mContext).addRequest(microappName, jObj.toString(), force);
        }
        this.tryWakingSendingTaskInternal(requestsInQueueCount);
    }

    private void postMicroappDataInternal(Context context, String microappName, JSONObject jObj, boolean force) {
        this.isInitializedOrThrow();
        long requestsInQueueCount = 0L;
        if (jObj != null && context != null) {
            requestsInQueueCount = WarplyDBHelper.getInstance(context).addRequest(microappName, jObj.toString(), force);
        }
        this.tryWakingSendingTaskInternal(context, requestsInQueueCount);
    }

    public static void postMicroappPush(String microappName, JSONObject jObj, boolean force) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.postMicroappPushInternal(microappName, jObj, force);
    }

    private void postMicroappPushInternal(String microappName, JSONObject jObj, boolean force) {
        this.isInitializedOrThrow();
        long requestsInQueueCount = 0L;
        if (jObj != null) {
            requestsInQueueCount = WarplyDBHelper.getInstance(this.mContext).addPushRequest(microappName, jObj.toString(), force);
        }
        this.tryWakingSendingPushTaskInternal(requestsInQueueCount, false);
    }

    public static void postMicroappPushAck(String microappName, JSONObject jObj, boolean force) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.postMicroappPushAckInternal(microappName, jObj, force);
    }

    private void postMicroappPushAckInternal(String microappName, JSONObject jObj, boolean force) {
        this.isInitializedOrThrow();
        long requestsInQueueCount = 0L;
        if (jObj != null) {
            requestsInQueueCount = WarplyDBHelper.getInstance(this.mContext).addPushAckRequest(microappName, jObj.toString(), force);
        }
        this.tryWakingSendingPushAckTaskInternal(requestsInQueueCount, false);
    }

    public static void getInbox(CallbackReceiver<CampaignList> receiver) {
        Warply.getInbox(null, receiver);
    }

    public static void getInbox(WarplyInboxRequest request, final CallbackReceiver<CampaignList> receiver) {
        long updateInterval;
        boolean isNeedUpdateCampaignsByTimeStamp;
        if (request == null) {
            request = new WarplyInboxRequest();
        }
        final String requestSignature = request.getSignature();
        final WarplyPreferences warplyPreferences = new WarplyPreferences(Warply.INSTANCE.mContext);
        long elapsedTimeAfterLastUpdate = System.currentTimeMillis() - warplyPreferences.getInboxLastCachedTimeStamp(requestSignature);
        boolean bl = isNeedUpdateCampaignsByTimeStamp = elapsedTimeAfterLastUpdate > (updateInterval = request.getCacheUpdateInterval());
        if (isNeedUpdateCampaignsByTimeStamp || Warply.INSTANCE.mLastReceivedCampaigns == null || Warply.INSTANCE.mLastReceivedCampaigns.size() == 0 || !Warply.INSTANCE.mLastReceivedCampaigns.getRequestSignature().equals(requestSignature)) {
            final ObjectSerializer objectSerializer = new ObjectSerializer(Warply.INSTANCE.mContext);
            CampaignList campaignsCache = (CampaignList)objectSerializer.deserialize(File.separator + requestSignature);
            if (isNeedUpdateCampaignsByTimeStamp || campaignsCache == null || campaignsCache.size() == 0 || !campaignsCache.getRequestSignature().equals(requestSignature)) {
                INSTANCE.isInitializedOrThrow();
                INSTANCE.getInboxInternal(new CallbackReceiver<CampaignList>(){

                    @Override
                    public void onSuccess(CampaignList result) {
                        if (result.size() >= 0) {
                            objectSerializer.serialize(result, File.separator + requestSignature);
                            warplyPreferences.saveInboxLastCachedTimeStamp(requestSignature, System.currentTimeMillis());
                            CampaignList campaignLoyaltyList = new CampaignList();
                            campaignLoyaltyList.clear();
                            for (Campaign camp : result) {
                                try {
                                    JSONObject extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
                                    if (extraFields == null || extraFields.length() != 0 && (extraFields.has("ccms_offer") || extraFields.has("type"))) continue;
                                    campaignLoyaltyList.add(camp);
                                }
                                catch (Exception exception) {
                                    campaignLoyaltyList.add(camp);
                                }
                            }
                            INSTANCE.mLastReceivedCampaigns = result;
                            if (receiver != null) {
                                receiver.onSuccess(result);
                            }
                        }
                    }

                    @Override
                    public void onFailure(int errorCode) {
                        if (receiver != null) {
                            receiver.onFailure(errorCode);
                        }
                    }
                }, request);
            } else {
                Warply.INSTANCE.mLastReceivedCampaigns = campaignsCache;
                if (receiver != null) {
                    receiver.onSuccess(Warply.INSTANCE.mLastReceivedCampaigns);
                }
            }
        } else if (receiver != null) {
            receiver.onSuccess(Warply.INSTANCE.mLastReceivedCampaigns);
        }
    }

    public static void getInboxInApp(WarplyInboxRequest request, final CallbackReceiver<CampaignList> receiver) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.getInboxInAppInternal(new CallbackReceiver<CampaignList>(){

            @Override
            public void onSuccess(CampaignList result) {
                receiver.onSuccess(result);
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onFailure(errorCode);
            }
        }, request);
    }

    public CampaignList getLastReceivedCampaigns() {
        return this.mLastReceivedCampaigns;
    }

    public CampaignList getInAppCampaigns() {
        return this.mInAppCampaigns;
    }

    public void getInboxUnreadCount(final CallbackReceiver<Integer> receiver, WarplyInboxRequest request) {
        Warply.getInbox(request, new CallbackReceiver<CampaignList>(){

            @Override
            public void onSuccess(CampaignList result) {
                receiver.onSuccess(result != null ? result.getUnreadCampaignsCount() : 0);
            }

            @Override
            public void onFailure(int errorCode) {
                receiver.onSuccess(0);
            }
        });
    }

    @Deprecated
    public static void getCampaigns(CallbackReceiver<CampaignList> receiver) {
        Warply.getInbox(receiver);
    }

    public static void getInboxStats(CallbackReceiver<InboxStats> receiver) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.getInboxStatsInternal(receiver);
    }

    private void getInboxInternal(CallbackReceiver<CampaignList> receiver, WarplyInboxRequest request) {
        WarpUtils.log("************* WARPLY Microapp ********************");
        if (!WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.OFFERS)) {
            WarpUtils.log("[WARP Trace] Offers Microapp is not active");
            WarpUtils.log("**************************************************");
            receiver.onFailure(2);
            return;
        }
        WarpUtils.log("[WARP Trace] Offers Microapp is active");
        WarpUtils.log("**************************************************");
        request = request != null ? request : new WarplyInboxRequest();
        this.postReceiveMicroappDataInternal("offers", request.toJson(), new CampaignsHook(receiver, request.getSignature()));
    }

    private void getInboxInAppInternal(CallbackReceiver<CampaignList> receiver, WarplyInboxRequest request) {
        WarpUtils.log("************* WARPLY Microapp ********************");
        if (!WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.OFFERS)) {
            WarpUtils.log("[WARP Trace] Offers Microapp is not active");
            WarpUtils.log("**************************************************");
            receiver.onFailure(2);
            return;
        }
        WarpUtils.log("[WARP Trace] Offers Microapp is active");
        WarpUtils.log("**************************************************");
        request = request != null ? request : new WarplyInboxRequest();
        this.postReceiveMicroappDataInternal("offers", request.toJsonInApp(), new CampaignsHook(receiver, request.getSignature()));
    }

    private void getInboxStatsInternal(CallbackReceiver<InboxStats> receiver) {
        JSONObject jObj;
        block3: {
            WarpUtils.log("************* WARPLY Microapp ********************");
            if (!WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.OFFERS)) {
                WarpUtils.log("[WARP Trace] Offers Microapp is not active");
                WarpUtils.log("**************************************************");
                receiver.onFailure(2);
                return;
            }
            WarpUtils.log("[WARP Trace] Offers Microapp is active");
            WarpUtils.log("**************************************************");
            jObj = new JSONObject();
            try {
                jObj.put("action", (Object)"offer_status");
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block3;
                e.printStackTrace();
            }
        }
        this.postReceiveMicroappDataInternal("offers", jObj, new InboxStatsHook(receiver));
    }

    public static void checkForAppUpdate(final Context activityContext, final SimpleCallbackReceiver<Boolean> callback) {
        INSTANCE.isInitializedOrThrow();
        WarplyPreferences warplyPreferences = new WarplyPreferences(Warply.INSTANCE.mContext);
        if (warplyPreferences.getBoolean("ANDROID_HAS_UPDATE", false) && warplyPreferences.getInt("ANDROID_NEW_VERSION", 0) > WarplyProperty.getAppVersionCode(Warply.getWarplyContext())) {
            AlertDialog.Builder builder = new AlertDialog.Builder(activityContext);
            builder.setCancelable(false);
            builder.setTitle((CharSequence)"Update");
            builder.setMessage((CharSequence)"A new version of your app is available.");
            builder.setPositiveButton((CharSequence)"Update", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id) {
                    block4: {
                        callback.onResult(true, 0);
                        try {
                            activityContext.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + activityContext.getApplicationContext().getPackageName()))));
                        }
                        catch (ActivityNotFoundException e) {
                            try {
                                activityContext.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + activityContext.getApplicationContext().getPackageName()))));
                            }
                            catch (ActivityNotFoundException e1) {
                                if (!WarpConstants.DEBUG) break block4;
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
            if (!warplyPreferences.getBoolean("ANDROID_FORCE_UPDATE", false)) {
                builder.setNegativeButton((CharSequence)"Close", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id) {
                        dialog.dismiss();
                        callback.onResult(false, 0);
                    }
                });
            }
            builder.create().show();
        } else {
            callback.onResult(false, 0);
        }
    }

    public static void setRegistrationListener(CallbackReceiver<WarpConstants.ServiceRegistrationCallback> receiver) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.listenGCMInternal(receiver);
    }

    private void listenGCMInternal(CallbackReceiver<WarpConstants.ServiceRegistrationCallback> receiver) {
        this.mRegistrationListener = receiver;
    }

    public static void stopRegistrationListening() {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.stopGCMListeningInternal();
    }

    private void stopGCMListeningInternal() {
        this.mRegistrationListener = null;
    }

    public static void registerWarply() {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.registerWarplyInternal();
    }

    private void registerWarplyInternal() {
        this.isInitializedOrThrow();
        if (!WarpUtils.isRegisteredWarply(this.mContext)) {
            this.wakeRegistrationTask();
        }
    }

    public static void resetWarplyWebId() {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.resetWarplyWebIdInternal();
    }

    private void resetWarplyWebIdInternal() {
        this.isInitializedOrThrow();
        WarpUtils.setWebId(this.mContext, "");
        if (this.mRegistrationListener != null) {
            this.mRegistrationListener.onSuccess(WarpConstants.ServiceRegistrationCallback.UNREGISTERED_WARPLY);
        }
        Warply.registerWarply();
    }

    public void setGCMEnabled(boolean enabled) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.setGCMEnabledInternal(enabled);
    }

    private void setGCMEnabledInternal(boolean enabled) {
        WarpUtils.setGCMEnabled(this.mContext, enabled);
    }

    public static Warply getWarplyInstance() {
        return INSTANCE;
    }

    public static Context getWarplyContext() {
        INSTANCE.isInitializedOrThrow();
        return INSTANCE.getWarplyContextInternal();
    }

    private Context getWarplyContextInternal() {
        return this.mContext;
    }

    public void postDeviceInfoData() {
        this.isInitializedOrThrow();
        WarpUtils.log("************* WARPLY Microapp ********************");
        if (!WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.APPLICATION_DATA)) {
            WarpUtils.log("[WARP Trace] Application Info Microapp is not active");
            return;
        }
        WarpUtils.log("[WARP Trace] Application Info Microapp is active");
        WarpUtils.log("**************************************************");
        WarplyDeviceInfoCollector deviceInfoCollector = new WarplyDeviceInfoCollector(this.mContext);
        deviceInfoCollector.collectToJson(new SimpleCallbackReceiver<JSONObject>(){

            @Override
            public void onResult(JSONObject json, int errorCode) {
                super.onResult(json, errorCode);
                if (json != null) {
                    if (!WarpUtils.getIsDeviceInfoSaved(Warply.this.mContext)) {
                        WarpUtils.setIsDeviceInfoSaved(Warply.this.mContext, true);
                        WarpUtils.setDeviceInfoObject(Warply.this.mContext, json);
                        Warply.postMicroappData("device_info", json, true);
                    } else if (Warply.this.hasDeviceInfoDifference(WarpUtils.getDeviceInfoObject(Warply.this.mContext), json)) {
                        WarpUtils.setDeviceInfoObject(Warply.this.mContext, json);
                        Warply.postMicroappData("device_info", json, true);
                    }
                }
            }
        });
    }

    private boolean hasDeviceInfoDifference(JSONObject savedDeviceInfo, JSONObject toSendDeviceInfo) {
        if (savedDeviceInfo.length() != toSendDeviceInfo.length()) {
            return true;
        }
        Iterator iterToSend = toSendDeviceInfo.keys();
        while (iterToSend.hasNext()) {
            String keyToSend = (String)iterToSend.next();
            Iterator iterSaved = savedDeviceInfo.keys();
            while (iterSaved.hasNext()) {
                String keySaved = (String)iterSaved.next();
                if (!keyToSend.equals(keySaved)) continue;
                try {
                    if (toSendDeviceInfo.get(keyToSend).equals(savedDeviceInfo.get(keySaved))) continue;
                    return true;
                }
                catch (JSONException e) {
                    return false;
                }
            }
        }
        return false;
    }

    private void postApplicationData(boolean force) {
        this.isInitializedOrThrow();
        WarpUtils.log("************* WARPLY Microapp ********************");
        if (!WarplyServerPreferencesManager.isMicroAppActive(WarpConstants.MicroApp.APPLICATION_DATA)) {
            WarpUtils.log("[WARP Trace] Application Info Microapp is not active");
            return;
        }
        WarpUtils.log("[WARP Trace] Application Info Microapp is active");
        WarpUtils.log("**************************************************");
        JSONObject object = new JSONObject();
        try {
            PackageInfo info = this.mContext.getPackageManager().getPackageInfo(this.mContext.getApplicationContext().getPackageName(), 0);
            if (WarpUtils.getTrackersEnabled(this.mContext)) {
                object.putOpt("app_version", (Object)info.versionName);
                object.putOpt("sdk_version", (Object)"4.5.5.4");
                object.putOpt("app_build", (Object)info.versionCode);
            }
            if (!WarpUtils.getHasApplicationInfo(this.mContext)) {
                WarpUtils.setHasApplicationInfo(this.mContext, true);
                WarpUtils.setAppDataObject(this.mContext, object);
                Warply.postMicroappData("application_data", object, force);
            } else if (this.hasApplicationDataDifference(WarpUtils.getAppDataObject(this.mContext), object)) {
                WarpUtils.setAppDataObject(this.mContext, object);
                Warply.postMicroappData("application_data", object, force);
            }
        }
        catch (JSONException e) {
            WarpUtils.warn("Problem when creating Device Info JSON", (Exception)((Object)e));
        }
        catch (PackageManager.NameNotFoundException e) {
            WarpUtils.warn("Problem when creating Application Data JSON, in package", (Exception)((Object)e));
        }
    }

    private boolean hasApplicationDataDifference(JSONObject savedAppData, JSONObject toSendAppData) {
        Iterator iterToSend = toSendAppData.keys();
        while (iterToSend.hasNext()) {
            String keyToSend = (String)iterToSend.next();
            Iterator iterSaved = savedAppData.keys();
            while (iterSaved.hasNext()) {
                String keySaved = (String)iterSaved.next();
                if (!keyToSend.equals(keySaved)) continue;
                try {
                    if (toSendAppData.get(keyToSend).equals(savedAppData.get(keySaved))) continue;
                    return true;
                }
                catch (JSONException e) {
                    return false;
                }
            }
        }
        return false;
    }

    public static void resetApplicationInfo() {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.resetApplicationInfoInternal();
    }

    private void resetApplicationInfoInternal() {
        WarpUtils.log("************* WARPLY Info ********************");
        WarpUtils.log("[WARP Trace] Resetting application info");
        WarpUtils.log("**********************************************");
        WarpUtils.setLastApplicationData(this.mContext, "");
        if (WarpUtils.getIsAPPDATAENABLED(this.mContext)) {
            this.postApplicationData(true);
        }
    }

    public static void resetDeviceInfo() {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.resetDeviceInfoInternal();
    }

    private void resetDeviceInfoInternal() {
        WarpUtils.setLastDeviceInfo(this.mContext, "");
    }

    public static void resetIsWarped() {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.resetIsWarpedInternal();
    }

    private void resetIsWarpedInternal() {
        String lastGCMSenderId = WarpUtils.getLastGCMSenderId(this.mContext);
        if (lastGCMSenderId == null) {
            return;
        }
        if (lastGCMSenderId.equals("")) {
            return;
        }
    }

    public void onGCMRegistrationSuccess() {
        if (this.mRegistrationListener != null) {
            this.mRegistrationListener.onSuccess(WarpConstants.ServiceRegistrationCallback.REGISTERED_GCM);
        }
        this.resetDeviceInfoInternal();
    }

    public void onGCMUnregistrationSuccess() {
        if (this.mRegistrationListener != null) {
            this.mRegistrationListener.onSuccess(WarpConstants.ServiceRegistrationCallback.UNREGISTERED_GCM);
        }
    }

    public void onGCMRegistrationFail(int errorCode) {
        if (this.mRegistrationListener != null) {
            this.mRegistrationListener.onFailure(errorCode);
        }
    }

    private void check() {
        if (this.mContext == null) {
            return;
        }
        if (!WarpUtils.isRegisteredWarply(this.mContext)) {
            Warply.registerWarply();
            return;
        }
        if (WarpUtils.getIsDEVICEINFOENABLED(this.mContext)) {
            this.postDeviceInfoData();
        }
        if (WarpUtils.getIsAPPDATAENABLED(this.mContext)) {
            this.postApplicationData(true);
        }
        this.tryWakingSendingTaskInternal(WarplyDBHelper.getInstance(this.mContext).getRequestsInQueueCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeSendingTask() {
        if (!this.acquirePostLockInternal()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        JSONArray jArray = new JSONArray();
        Cursor c = WarplyDBHelper.getInstance(this.mContext).getAllRequests();
        while (c.moveToNext()) {
            JSONObject jObj = new JSONObject();
            try {
                jObj.putOpt(c.getString(c.getColumnIndex("microapp")), (Object)new JSONObject(c.getString(c.getColumnIndex("entity"))));
                jArray.put((Object)jObj);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) continue;
                WarpUtils.warn("[WARP Trace] Exception thrown when creating the JSON from DB with id: " + c.getLong(c.getColumnIndex("_id")), (Exception)((Object)e));
            }
            finally {
                ids.add(c.getLong(c.getColumnIndex("_id")));
            }
        }
        c.close();
        PostHook ph = new PostHook(Warply.getWarplyContext(), ids);
        this.postToServerInternal(null, jArray, ph, null);
        this.getFromServerInternal(null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeSendingPushTask() {
        if (!this.acquirePostLockInternal()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        JSONArray jArray = new JSONArray();
        Cursor c = WarplyDBHelper.getInstance(this.mContext).getAllPushRequests();
        while (c.moveToNext()) {
            JSONObject jObj = new JSONObject();
            try {
                jObj.putOpt(c.getString(c.getColumnIndex("microapp")), (Object)new JSONObject(c.getString(c.getColumnIndex("entity"))));
                jArray.put((Object)jObj);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) continue;
                WarpUtils.warn("[WARP Trace] Exception thrown when creating the JSON from DB with id: " + c.getLong(c.getColumnIndex("_id")), (Exception)((Object)e));
            }
            finally {
                ids.add(c.getLong(c.getColumnIndex("_id")));
            }
        }
        c.close();
        PostHook ph = new PostHook(Warply.getWarplyContext(), ids, true);
        this.postToServerInternal(null, jArray, ph, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeSendingPushAckTask() {
        if (!this.acquirePostLockInternal()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        JSONArray jArray = new JSONArray();
        Cursor c = WarplyDBHelper.getInstance(this.mContext).getAllPushAckRequests();
        while (c.moveToNext()) {
            JSONObject jObj = new JSONObject();
            try {
                jObj.putOpt(c.getString(c.getColumnIndex("microapp")), (Object)new JSONObject(c.getString(c.getColumnIndex("entity"))));
                jArray.put((Object)jObj);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) continue;
                WarpUtils.warn("[WARP Trace] Exception thrown when creating the JSON from DB with id: " + c.getLong(c.getColumnIndex("_id")), (Exception)((Object)e));
            }
            finally {
                ids.add(c.getLong(c.getColumnIndex("_id")));
            }
        }
        c.close();
        PostHook ph = new PostHook(Warply.getWarplyContext(), ids, false, true);
        this.postToServerInternal(null, jArray, ph, null);
    }

    public static void tryWakingSendingTask() {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.tryWakingSendingTaskInternal(WarplyDBHelper.getInstance(Warply.INSTANCE.mContext).getRequestsInQueueCount());
    }

    private void tryWakingSendingTaskInternal(long requestsInQueue) {
        if (!WarpUtils.isRegisteredWarply(this.mContext)) {
            WarpUtils.log("************* WARPLY Registration ********************");
            WarpUtils.log("[WARP TRace] Not registered yet, not waking post task!");
            WarpUtils.log("******************************************************");
            return;
        }
        if (WarplyDBHelper.getInstance(this.mContext).isForceRequestsExist() || requestsInQueue > 0L) {
            WarpUtils.log("Waking post task!");
            this.wakeSendingTask();
        } else {
            WarpUtils.log("Criteria not matched, not waking post task!");
        }
    }

    private void tryWakingSendingTaskInternal(Context context, long requestsInQueue) {
        if (!WarpUtils.isRegisteredWarply(this.mContext)) {
            WarpUtils.log("************* WARPLY Registration ********************");
            WarpUtils.log("[WARP TRace] Not registered yet, not waking post task!");
            WarpUtils.log("******************************************************");
            return;
        }
        if (WarplyDBHelper.getInstance(this.mContext).isForceRequestsExist() || requestsInQueue > 0L) {
            WarpUtils.log("Waking post task!");
            this.wakeSendingTask(context);
        } else {
            WarpUtils.log("Criteria not matched, not waking post task!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeSendingTask(Context context) {
        if (!this.acquirePostLockInternal()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        JSONArray jArray = new JSONArray();
        Cursor c = WarplyDBHelper.getInstance(this.mContext).getAllRequests();
        while (c.moveToNext()) {
            JSONObject jObj = new JSONObject();
            try {
                jObj.putOpt(c.getString(c.getColumnIndex("microapp")), (Object)new JSONObject(c.getString(c.getColumnIndex("entity"))));
                jArray.put((Object)jObj);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) continue;
                WarpUtils.warn("[WARP Trace] Exception thrown when creating the JSON from DB with id: " + c.getLong(c.getColumnIndex("_id")), (Exception)((Object)e));
            }
            finally {
                ids.add(c.getLong(c.getColumnIndex("_id")));
            }
        }
        c.close();
        PostHook ph = new PostHook(Warply.getWarplyContext(), ids);
        this.postToServerInternal(context, null, jArray, (CallbackReceiver<JSONObject>)ph, null);
        this.getFromServerInternal(null, null, null, null);
    }

    private void postToServerInternal(Context context, String warplyPath, JSONArray data, CallbackReceiver<JSONObject> listener, Object tag) {
        String url = this.buildWarplyRequestUrl(context, warplyPath);
        JSONArray tempAnalytics = new JSONArray();
        JSONArray tempDeviceInfo = new JSONArray();
        JSONArray tempOther = new JSONArray();
        if (data.length() > 0) {
            for (int i = 0; i < data.length(); ++i) {
                JSONObject microappItem = data.optJSONObject(i);
                if (microappItem == null) continue;
                if (microappItem.has("inapp_analytics")) {
                    tempAnalytics.put((Object)microappItem);
                    continue;
                }
                if (microappItem.has("device_info") || microappItem.has("application_data")) {
                    tempDeviceInfo.put((Object)microappItem);
                    continue;
                }
                tempOther.put((Object)microappItem);
            }
        }
        if (tempAnalytics != null && tempAnalytics.length() > 0) {
            url = WarplyProperty.getBaseUrl(this.mContext) + "/api/async/" + "analytics/" + WarplyProperty.getAppUuid(this.mContext) + "/";
        }
        if (tempDeviceInfo != null && tempDeviceInfo.length() > 0) {
            url = WarplyProperty.getBaseUrl(this.mContext) + "/api/async/" + "info/" + WarplyProperty.getAppUuid(this.mContext) + "/";
        }
        if (tempOther != null && tempOther.length() > 0) {
            url = this.buildWarplyRequestUrl(warplyPath);
        }
        this.requestToServerInternal(1, url, data, listener, tag);
    }

    private String buildWarplyRequestUrl(Context context, String warplyPath) {
        StringBuilder sb = new StringBuilder(WarplyProperty.getBaseUrl(context) + "/api/mobile/v2/");
        sb.append(WarplyProperty.getAppUuid(this.mContext)).append("/").append("context").append("/");
        if (warplyPath != null) {
            sb.append("?path=").append(warplyPath);
        }
        return sb.toString();
    }

    public static void tryWakingSendingPushTask(boolean force) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.tryWakingSendingPushTaskInternal(WarplyDBHelper.getInstance(Warply.INSTANCE.mContext).getPushRequestsInQueueCount(), force);
    }

    private void tryWakingSendingPushTaskInternal(long requestsInQueue, boolean force) {
        if (!WarpUtils.isRegisteredWarply(this.mContext)) {
            WarpUtils.log("************* WARPLY Registration ********************");
            WarpUtils.log("[WARP TRace] Not registered yet, not waking post task!");
            WarpUtils.log("******************************************************");
            return;
        }
        if (force || requestsInQueue >= 10L) {
            WarpUtils.log("Waking post task!");
            this.wakeSendingPushTask();
        } else {
            WarpUtils.log("Criteria not matched, not waking post task!");
        }
    }

    public static void tryWakingSendingPushAckTask(boolean force) {
        INSTANCE.isInitializedOrThrow();
        INSTANCE.tryWakingSendingPushAckTaskInternal(WarplyDBHelper.getInstance(Warply.INSTANCE.mContext).getPushAckRequestsInQueueCount(), force);
    }

    private void tryWakingSendingPushAckTaskInternal(long requestsInQueue, boolean force) {
        if (!WarpUtils.isRegisteredWarply(this.mContext)) {
            WarpUtils.log("************* WARPLY Registration ********************");
            WarpUtils.log("[WARP TRace] Not registered yet, not waking post task!");
            WarpUtils.log("******************************************************");
            return;
        }
        if (force || requestsInQueue >= 10L) {
            WarpUtils.log("Waking post task!");
            this.wakeSendingPushAckTask();
        } else {
            WarpUtils.log("Criteria not matched, not waking post task!");
        }
    }

    private void wakeRegistrationTask() {
        if (!this.acquireRegisterLock()) {
            return;
        }
        this.registerToServerInternal();
    }

    public static void onApplicationStarted() {
        INSTANCE.isInitializedOrThrow();
        WarplyAnalyticsManager.logAppLifeCycleEvent();
    }

    public static void onApplicationEnterForeground() {
        INSTANCE.isInitializedOrThrow();
        new WarplyPreferences(Warply.getWarplyContext()).saveAppStatus("foreground");
        Warply.changeLocationSettings(true);
        WarplyServerPreferencesManager.checkServerPreferences(mServerPreferencesReceiveListener);
    }

    public static void onApplicationEnterBackground() {
        INSTANCE.isInitializedOrThrow();
        new WarplyPreferences(Warply.getWarplyContext()).saveAppStatus("background");
        Warply.changeLocationSettings(false);
    }

    private static void changeLocationSettings(boolean isForeground) {
        WarplyAnalyticsManager.logAppLifeCycleEvent(isForeground);
        if (LOCATION_SETTINGS_MAP != null) {
            String provider;
            int mode = LOCATION_SETTINGS_MAP.get((Object)(isForeground ? WarpConstants.LocationSetting.LOCATION_FOREGROUND_MODE : WarpConstants.LocationSetting.LOCATION_BACKGROUND_MODE));
            switch (mode) {
                case 0: {
                    provider = WarpConstants.LocationModes.OFF.getJsonKey();
                    break;
                }
                case 1: {
                    provider = WarpConstants.LocationModes.PASSIVE.getJsonKey();
                    break;
                }
                case 2: {
                    provider = WarpConstants.LocationModes.NETWORK.getJsonKey();
                    break;
                }
                case 3: {
                    provider = WarpConstants.LocationModes.GPS.getJsonKey();
                    break;
                }
                default: {
                    provider = WarpConstants.LocationModes.OFF.getJsonKey();
                }
            }
            long minTime = LOCATION_SETTINGS_MAP.get((Object)(isForeground ? WarpConstants.LocationSetting.FOREGROUND_MIN_TIME : WarpConstants.LocationSetting.BACKGROUND_MIN_TIME)).intValue();
            float minDistance = LOCATION_SETTINGS_MAP.get((Object)(isForeground ? WarpConstants.LocationSetting.FOREGROUND_MIN_DISTANCE : WarpConstants.LocationSetting.BACKGROUND_MIN_DISTANCE)).intValue();
            WarplyLocationManager.regulateLocationWithNewSettings(Warply.getWarplyContext(), provider, minTime * 1000L, minDistance);
        }
    }

    public static void initBeaconsApplicationIfNeed() {
        block5: {
            try {
                WarplyBeaconsApplication beaconsApplication = WarplyBeaconsApplication.getInstance();
                if (beaconsApplication != null) {
                    if (WarplyBeaconsApplication.isMicroAppEnabled()) {
                        beaconsApplication.enable();
                        beaconsApplication.addBeaconLayouts(WarplyBeaconsApplication.getBeaconLayouts());
                    } else {
                        beaconsApplication.disable();
                    }
                }
            }
            catch (NoClassDefFoundError e) {
                if (!WarpConstants.DEBUG) break block5;
                e.printStackTrace();
            }
        }
    }

    private void requestToServerInternal(int method, String url, JSONObject data, CallbackReceiver<JSONObject> listener, Object tag) {
        VolleyTransformer vt = new VolleyTransformer(listener);
        String methodName = null;
        switch (method) {
            case 0: {
                methodName = "GET";
                break;
            }
            case 1: {
                methodName = "POST";
                break;
            }
            case 2: {
                methodName = "PUT";
                break;
            }
            case 3: {
                methodName = "DELETE";
            }
        }
        WarpUtils.log("************* WARPLY " + methodName + " Context ********************");
        WarpUtils.log("[WARP Trace] HTTP Web Id: " + WarpUtils.getWebId(this.mContext));
        WarpUtils.log("[WARP Trace] HTTP API Key: " + WarplyProperty.getAppUuid(this.mContext));
        WarpUtils.verbose("[WARP Trace] HTTP " + methodName + " Request URL: " + url);
        if (data != null) {
            try {
                WarpUtils.verbose("[WARP Trace] Request: " + data.toString(2));
            }
            catch (JSONException e) {
                WarpUtils.warn("[WARP Trace] Failed conversting JSON to string", (Exception)((Object)e));
            }
        }
        WarpUtils.log("**********************************************************");
        WarplyJsonObjectRequest request = new WarplyJsonObjectRequest(method, url, data, vt, (Response.ErrorListener)vt);
        request.setTag(tag);
        this.mRequestQueue.add(request);
    }

    public void requestToServerInternalNew(int method, String url, JSONObject data, CallbackReceiver<JSONObject> listener, Object tag) {
        VolleyTransformer vt = new VolleyTransformer(listener);
        String methodName = null;
        switch (method) {
            case 0: {
                methodName = "GET";
                break;
            }
            case 1: {
                methodName = "POST";
                break;
            }
            case 2: {
                methodName = "PUT";
                break;
            }
            case 3: {
                methodName = "DELETE";
            }
        }
        WarpUtils.log("************* WARPLY " + methodName + " Context ********************");
        WarpUtils.log("[WARP Trace] HTTP Web Id: " + WarpUtils.getWebId(Warply.getWarplyContext()));
        WarpUtils.log("[WARP Trace] HTTP API Key: " + WarplyProperty.getAppUuid(Warply.getWarplyContext()));
        WarpUtils.verbose("[WARP Trace] HTTP " + methodName + " Request URL: " + url);
        if (data != null) {
            try {
                WarpUtils.verbose("[WARP Trace] Request: " + data.toString(2));
            }
            catch (JSONException e) {
                WarpUtils.warn("[WARP Trace] Failed conversting JSON to string", (Exception)((Object)e));
            }
        }
        WarpUtils.log("**********************************************************");
        WarplyJsonObjectRequest request = new WarplyJsonObjectRequest(method, url, data, vt, (Response.ErrorListener)vt);
        request.setTag(tag);
        this.mRequestQueue.add(request);
    }

    private void requestToServerInternal(int method, String url, JSONObject data, CallbackReceiver<JSONObject> listener, Object tag, boolean hasAuthHeaders) {
        VolleyTransformer vt = new VolleyTransformer(listener);
        String methodName = null;
        switch (method) {
            case 0: {
                methodName = "GET";
                break;
            }
            case 1: {
                methodName = "POST";
                break;
            }
            case 2: {
                methodName = "PUT";
                break;
            }
            case 3: {
                methodName = "DELETE";
            }
        }
        WarpUtils.log("************* WARPLY " + methodName + " Context ********************");
        WarpUtils.log("[WARP Trace] HTTP Web Id: " + WarpUtils.getWebId(this.mContext));
        WarpUtils.log("[WARP Trace] HTTP API Key: " + WarplyProperty.getAppUuid(this.mContext));
        WarpUtils.verbose("[WARP Trace] HTTP " + methodName + " Request URL: " + url);
        if (data != null) {
            try {
                WarpUtils.verbose("[WARP Trace] Request: " + data.toString(2));
            }
            catch (JSONException e) {
                WarpUtils.warn("[WARP Trace] Failed conversting JSON to string", (Exception)((Object)e));
            }
        }
        WarpUtils.log("**********************************************************");
        WarplyJsonObjectRequest request = new WarplyJsonObjectRequest(method, url, data, vt, (Response.ErrorListener)vt);
        request.setTag(hasAuthHeaders ? "true" : tag);
        this.mRequestQueue.add(request);
    }

    private void requestToServerInternal(int method, String url, JSONArray data, CallbackReceiver<JSONObject> listener, Object tag) {
        VolleyTransformer vt = new VolleyTransformer(listener);
        String methodName = null;
        switch (method) {
            case 0: {
                methodName = "GET";
                break;
            }
            case 1: {
                methodName = "POST";
                break;
            }
            case 2: {
                methodName = "PUT";
                break;
            }
            case 3: {
                methodName = "DELETE";
            }
        }
        WarpUtils.log("************* WARPLY " + methodName + " Context ********************");
        WarpUtils.log("[WARP Trace] HTTP Web Id: " + WarpUtils.getWebId(this.mContext));
        WarpUtils.log("[WARP Trace] HTTP API Key: " + WarplyProperty.getAppUuid(this.mContext));
        WarpUtils.verbose("[WARP Trace] HTTP " + methodName + " Request URL: " + url);
        if (data != null) {
            try {
                WarpUtils.verbose("[WARP Trace] Request: " + data.toString(2));
            }
            catch (JSONException e) {
                WarpUtils.warn("[WARP Trace] Failed conversting JSON to string", (Exception)((Object)e));
            }
        }
        if (data != null) {
            JSONArray tempAnalytics = new JSONArray();
            JSONArray tempDeviceInfo = new JSONArray();
            JSONArray tempOther = new JSONArray();
            if (data.length() > 0) {
                for (int i = 0; i < data.length(); ++i) {
                    JSONObject microappItem = data.optJSONObject(i);
                    if (microappItem == null) continue;
                    if (microappItem.has("inapp_analytics")) {
                        tempAnalytics.put((Object)microappItem);
                        continue;
                    }
                    if (microappItem.has("device_info") || microappItem.has("application_data")) {
                        tempDeviceInfo.put((Object)microappItem);
                        continue;
                    }
                    tempOther.put((Object)microappItem);
                }
            }
            if (Warply.INSTANCE.mRequestQueue == null && Warply.INSTANCE.mContext != null) {
                Warply.INSTANCE.mRequestQueue = Volley.newRequestQueue(Warply.INSTANCE.mContext);
            }
            if (tempAnalytics != null && tempAnalytics.length() > 0) {
                String urlAnalytics = WarplyProperty.getBaseUrl(this.mContext) + "/api/async/" + "analytics/" + WarplyProperty.getAppUuid(this.mContext) + "/";
                WarplyJsonArrayRequest requestAnalytics = new WarplyJsonArrayRequest(method, urlAnalytics, tempAnalytics, vt, (Response.ErrorListener)vt);
                requestAnalytics.setTag(tag);
                if (this.mRequestQueue == null) {
                    this.mRequestQueue = Volley.newRequestQueue(this.mContext);
                }
                this.mRequestQueue.add(requestAnalytics);
            }
            if (tempDeviceInfo != null && tempDeviceInfo.length() > 0) {
                String urlDeviceInfo = WarplyProperty.getBaseUrl(this.mContext) + "/api/async/" + "info/" + WarplyProperty.getAppUuid(this.mContext) + "/";
                WarplyJsonArrayRequest requestDeviceInfo = new WarplyJsonArrayRequest(method, urlDeviceInfo, tempDeviceInfo, vt, (Response.ErrorListener)vt);
                requestDeviceInfo.setTag(tag);
                if (this.mRequestQueue == null) {
                    this.mRequestQueue = Volley.newRequestQueue(this.mContext);
                }
                this.mRequestQueue.add(requestDeviceInfo);
            }
            if (tempOther != null && tempOther.length() > 0) {
                WarplyJsonArrayRequest request = new WarplyJsonArrayRequest(method, url, tempOther, vt, (Response.ErrorListener)vt);
                request.setTag(tag);
                if (this.mRequestQueue == null) {
                    this.mRequestQueue = Volley.newRequestQueue(this.mContext);
                }
                this.mRequestQueue.add(request);
            }
        }
    }

    private void postToServerInternal(JSONObject data, CallbackReceiver<JSONObject> listener, Object tag) {
        String url = this.buildWarplyRequestUrl(null);
        this.requestToServerInternal(1, url, data, listener, tag);
    }

    private void postToServerInternal(boolean hasAuthHeaders, String path, JSONObject data, CallbackReceiver<JSONObject> listener, Object tag) {
        String url = "";
        url = path.equals("register") || path.equals("change_password") || path.equals("password_reset") || path.equals("generate") ? this.buildWarplyAuthRequestUrl(path, true) : (path.equals("campaigns") ? this.buildWarplyRequestUrl(null) : (path.equals("campaignsPersonalized") ? this.buildWarplyRequestUrl(null, true) : this.buildWarplyAuthRequestUrl(path, false)));
        this.requestToServerInternal(1, url, data, listener, tag, hasAuthHeaders);
    }

    private void postToServerInternal(String warplyPath, JSONArray data, CallbackReceiver<JSONObject> listener, Object tag) {
        String url = this.buildWarplyRequestUrl(warplyPath);
        JSONArray tempAnalytics = new JSONArray();
        JSONArray tempDeviceInfo = new JSONArray();
        JSONArray tempOther = new JSONArray();
        if (data.length() > 0) {
            for (int i = 0; i < data.length(); ++i) {
                JSONObject microappItem = data.optJSONObject(i);
                if (microappItem == null) continue;
                if (microappItem.has("inapp_analytics")) {
                    tempAnalytics.put((Object)microappItem);
                    continue;
                }
                if (microappItem.has("device_info") || microappItem.has("application_data")) {
                    tempDeviceInfo.put((Object)microappItem);
                    continue;
                }
                tempOther.put((Object)microappItem);
            }
        }
        if (tempAnalytics != null && tempAnalytics.length() > 0) {
            url = WarplyProperty.getBaseUrl(this.mContext) + "/api/async/" + "analytics/" + WarplyProperty.getAppUuid(this.mContext) + "/";
        }
        if (tempDeviceInfo != null && tempDeviceInfo.length() > 0) {
            url = WarplyProperty.getBaseUrl(this.mContext) + "/api/async/" + "info/" + WarplyProperty.getAppUuid(this.mContext) + "/";
        }
        if (tempOther != null && tempOther.length() > 0) {
            url = this.buildWarplyRequestUrl(warplyPath);
        }
        this.requestToServerInternal(1, url, data, listener, tag);
    }

    private void getFromServerInternal(JSONObject data, String warplyPath, CallbackReceiver<JSONObject> listener, Object tag) {
        String url = this.buildWarplyRequestUrl(warplyPath);
        if (WarpUtils.getCurrentTimeMillis(this.mContext) == 0L || WarpUtils.getCurrentTimeMillis(this.mContext) > 0L && System.currentTimeMillis() > WarpUtils.getCurrentTimeMillis(this.mContext) + 3600000L) {
            WarpUtils.setCurrentTimeMillis(this.mContext, System.currentTimeMillis());
            this.requestToServerInternal(0, url, data, listener, tag);
        }
    }

    public void getSingleCampaign(JSONObject data, String url, CallbackReceiver<JSONObject> listener, Object tag) {
        this.requestToServerInternalNew(0, url, data, listener, tag);
    }

    private void registerToServerInternal() {
        final String url = WarplyProperty.getBaseUrl(this.mContext) + "/api/mobile/v2/" + WarplyProperty.getAppUuid(this.mContext) + "/" + "register" + "/";
        new WarplyDeviceInfoCollector(this.mContext).getRegistrationParams(new SimpleCallbackReceiver<JSONObject>(){

            @Override
            public void onResult(JSONObject result, int errorCode) {
                super.onResult(result, errorCode);
                Warply.this.requestToServerInternal(1, url, result, (CallbackReceiver<JSONObject>)Warply.this.mRegistrationCallBackReceiver, null);
            }
        });
    }

    private String buildWarplyRequestUrl(String warplyPath) {
        StringBuilder sb = new StringBuilder(WarplyProperty.getBaseUrl(this.mContext) + "/api/mobile/v2/");
        sb.append(WarplyProperty.getAppUuid(this.mContext)).append("/").append("context").append("/");
        if (warplyPath != null) {
            sb.append("?path=").append(warplyPath);
        }
        return sb.toString();
    }

    private String buildWarplyRequestUrl(String warplyPath, boolean personalized) {
        StringBuilder sb = new StringBuilder(WarplyProperty.getBaseUrl(this.mContext) + "/oauth/");
        sb.append(WarplyProperty.getAppUuid(this.mContext)).append("/").append("context");
        if (warplyPath != null) {
            sb.append("?path=").append(warplyPath);
        }
        return sb.toString();
    }

    private String buildWarplyAuthRequestUrl(String warplyPath, boolean isUserPath) {
        StringBuilder sb = isUserPath ? new StringBuilder(WarplyProperty.getBaseUrl(this.mContext) + "/user/") : (warplyPath.equals("handle_image") ? new StringBuilder(WarplyProperty.getBaseUrl(this.mContext) + "/api/") : (warplyPath.equals("verify") ? new StringBuilder(WarplyProperty.getBaseUrl(this.mContext) + WarplyProperty.getVerifyUrl(this.mContext)) : (warplyPath.equals("cosuser") ? new StringBuilder(WarplyProperty.getBaseUrl(this.mContext) + "/partners/oauth/" + WarplyProperty.getAppUuid(this.mContext) + "/token") : new StringBuilder(WarplyProperty.getBaseUrl(this.mContext) + "/oauth/"))));
        if (warplyPath != null && !warplyPath.equals("verify")) {
            if (warplyPath.equals("cosuser")) {
                return sb.toString();
            }
            sb.append(WarplyProperty.getAppUuid(this.mContext)).append("/");
            if (warplyPath.equals("generate")) {
                sb.append("otp/");
            }
            sb.append(warplyPath);
        }
        return sb.toString();
    }

    public static void showInAppCampaign(Context context, String eventId) {
        String tempOfferCategoryName = eventId.split(":")[1];
        CampaignList tempCampaignList = new CampaignList();
        if (INSTANCE.getInAppCampaigns() != null && INSTANCE.getInAppCampaigns().size() > 0) {
            Campaign campaignToShow;
            for (Campaign campaign : INSTANCE.getInAppCampaigns()) {
                if (!campaign.getOfferCategory().equals("all") && !campaign.getOfferCategory().equalsIgnoreCase(tempOfferCategoryName) || !campaign.isShow()) continue;
                tempCampaignList.add(campaign);
            }
            Collections.sort(tempCampaignList, new Comparator<Campaign>(){

                @Override
                public int compare(Campaign o1, Campaign o2) {
                    return Integer.valueOf(o2.getSorting()).compareTo(o1.getSorting());
                }
            });
            Log.v((String)"SORTED ", (String)"SUCCESS");
            if (tempCampaignList.size() > 0 && (campaignToShow = (Campaign)tempCampaignList.get(1)).getActions() == null) {
                if (campaignToShow.getAction() == 0) {
                    InAppDialog.showDefaultInAppDialog(context, campaignToShow, true, 0);
                } else if (campaignToShow.getAction() == 1) {
                    InAppDialog.showDefaultInAppDialog(context, campaignToShow, false, 0);
                }
            }
        }
    }

    static {
        mServerPreferencesReceiveListener = new WarplyServerPreferencesManager.ServerPreferencesReceivedListener(){

            @Override
            public void onServerPreferencesReceived() {
                Warply.initBeaconsApplicationIfNeed();
                WarplyUserManager.rewriteTags();
            }
        };
    }
}

